/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.concurrency;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.ListUtils;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.concurrency.ConcurrencyTestRunner;
import org.pentaho.di.concurrency.StopOnErrorCallable;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobConfiguration;
import org.pentaho.di.www.CarteObjectEntry;
import org.pentaho.di.www.JobMap;

public class JobMapConcurrencyTest {
    public static final String JOB_NAME_STRING = "job";
    public static final String JOB_ID_STRING = "job";
    public static final int INITIAL_JOB_MAP_SIZE = 100;
    private static final int gettersAmount = 20;
    private static final int replaceAmount = 20;
    private static final int updatersAmount = 5;
    private static final int updatersCycles = 10;
    private static JobMap jobMap;

    @BeforeClass
    public static void init() {
        jobMap = new JobMap();
        for (int i = 0; i < 100; ++i) {
            jobMap.addJob("job" + i, "job" + i, JobMapConcurrencyTest.mockJob(i), (JobConfiguration)Mockito.mock(JobConfiguration.class));
        }
    }

    private static Job mockJob(int id) {
        Job job = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)job.getContainerObjectId()).thenReturn((Object)("job" + id));
        return job;
    }

    @Test
    public void updateGetAndReplaceConcurrently() throws Exception {
        AtomicBoolean condition = new AtomicBoolean(true);
        AtomicInteger generator = new AtomicInteger(10);
        ArrayList<Updater> updaters = new ArrayList<Updater>();
        for (int i = 0; i < 5; ++i) {
            Updater updater = new Updater(jobMap, generator, 10);
            updaters.add(updater);
        }
        ArrayList<Getter> getters = new ArrayList<Getter>();
        for (int i = 0; i < 20; ++i) {
            getters.add(new Getter(jobMap, condition));
        }
        ArrayList<Replacer> replacers = new ArrayList<Replacer>();
        for (int i = 0; i < 20; ++i) {
            replacers.add(new Replacer(jobMap, condition));
        }
        ConcurrencyTestRunner.runAndCheckNoExceptionRaised(updaters, (List)ListUtils.union(replacers, getters), (AtomicBoolean)condition);
    }

    private static class Replacer
    extends StopOnErrorCallable<Object> {
        private final JobMap jobMap;
        private final Random random;

        public Replacer(JobMap jobMap, AtomicBoolean condition) {
            super(condition);
            this.jobMap = jobMap;
            this.random = new Random();
        }

        public Object doCall() throws Exception {
            int i = this.random.nextInt(100);
            String jobName = "job" + i;
            String jobId = "job" + i;
            CarteObjectEntry entry = new CarteObjectEntry(jobName, jobId);
            this.jobMap.replaceJob(entry, JobMapConcurrencyTest.mockJob(i + 1), (JobConfiguration)Mockito.mock(JobConfiguration.class));
            return null;
        }
    }

    private static class Updater
    implements Callable<Exception> {
        private final JobMap jobMap;
        private final AtomicInteger generator;
        private final int cycles;

        public Updater(JobMap jobMap, AtomicInteger generator, int cycles) {
            this.jobMap = jobMap;
            this.generator = generator;
            this.cycles = cycles;
        }

        @Override
        public Exception call() throws Exception {
            Exception exception = null;
            try {
                for (int i = 0; i < this.cycles; ++i) {
                    int id = this.generator.get();
                    this.jobMap.addJob("job" + id, "job" + id, JobMapConcurrencyTest.mockJob(id), (JobConfiguration)Mockito.mock(JobConfiguration.class));
                }
            }
            catch (Exception e) {
                exception = e;
            }
            return exception;
        }
    }

    private static class Getter
    extends StopOnErrorCallable<Object> {
        private final JobMap jobMap;
        private final Random random;

        public Getter(JobMap jobMap, AtomicBoolean condition) {
            super(condition);
            this.jobMap = jobMap;
            this.random = new Random();
        }

        public Object doCall() throws Exception {
            while (this.condition.get()) {
                int i = this.random.nextInt(100);
                CarteObjectEntry entry = (CarteObjectEntry)this.jobMap.getJobObjects().get(i);
                if (entry == null) {
                    throw new IllegalStateException(String.format("Returned CarteObjectEntry must not be null. EntryId = %d", i));
                }
                String jobName = "job" + i;
                Job job = this.jobMap.getJob(entry.getName());
                if (job == null) {
                    throw new IllegalStateException(String.format("Returned job must not be null. Job name = %s", jobName));
                }
                JobConfiguration jobConfiguration = this.jobMap.getConfiguration(entry.getName());
                if (jobConfiguration != null) continue;
                throw new IllegalStateException(String.format("Returned jobConfiguration must not be null. Job name = %s", jobName));
            }
            return null;
        }
    }
}

