/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.concurrency;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.AbstractFileProvider;
import org.apache.commons.vfs2.provider.FileProvider;
import org.junit.After;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.concurrency.ConcurrencyTestRunner;
import org.pentaho.di.concurrency.StopOnErrorCallable;
import org.pentaho.di.core.osgi.api.VfsEmbeddedFileSystemCloser;
import org.pentaho.di.core.vfs.ConcurrentFileSystemManager;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;

public class ConcurrentFileSystemManagerTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private DefaultFileSystemManager fileSystemManager = (DefaultFileSystemManager)KettleVFS.getInstance().getFileSystemManager();

    @After
    public void tearUp() {
        this.fileSystemManager.freeUnusedResources();
        this.fileSystemManager.close();
    }

    @Test
    public void getAndPutConcurrently() throws Exception {
        int numberOfGetters = 5;
        int numberOfPutters = 1;
        AtomicBoolean condition = new AtomicBoolean(true);
        ArrayList<Getter> getters = new ArrayList<Getter>();
        for (int i = 0; i < numberOfGetters; ++i) {
            getters.add(new Getter(condition, this.fileSystemManager));
        }
        ArrayList<Putter> putters = new ArrayList<Putter>();
        for (int i = 0; i < numberOfPutters; ++i) {
            putters.add(new Putter(condition, this.fileSystemManager));
        }
        ConcurrencyTestRunner.runAndCheckNoExceptionRaised(putters, getters, (AtomicBoolean)condition);
    }

    @Test
    public void testNcCloseEmbeddedFileSystem() throws Exception {
        ConcurrentFileSystemManager concurrentFileSystemManager = new ConcurrentFileSystemManager();
        MockNamedClusterProvider mockFileProvider = (MockNamedClusterProvider)Mockito.mock(MockNamedClusterProvider.class);
        concurrentFileSystemManager.addProvider(new String[]{"hc"}, (FileProvider)mockFileProvider);
        concurrentFileSystemManager.closeEmbeddedFileSystem("key");
        ((MockNamedClusterProvider)Mockito.verify((Object)mockFileProvider)).closeFileSystem("key");
    }

    @Test
    public void testNonNcCloseEmbeddedFileSystem() throws Exception {
        ConcurrentFileSystemManager concurrentFileSystemManager = new ConcurrentFileSystemManager();
        MockNamedClusterProvider mockFileProvider = (MockNamedClusterProvider)Mockito.mock(MockNamedClusterProvider.class);
        concurrentFileSystemManager.addProvider(new String[]{"notnc"}, (FileProvider)mockFileProvider);
        concurrentFileSystemManager.closeEmbeddedFileSystem("key");
        ((MockNamedClusterProvider)Mockito.verify((Object)mockFileProvider, (VerificationMode)Mockito.times((int)0))).closeFileSystem("key");
    }

    private class Putter
    extends StopOnErrorCallable<Object> {
        private DefaultFileSystemManager fsm;
        AbstractFileProvider provider;

        Putter(AtomicBoolean condition, DefaultFileSystemManager fsm) {
            super(condition);
            this.fsm = fsm;
            this.provider = (AbstractFileProvider)Mockito.mock(AbstractFileProvider.class);
            ((AbstractFileProvider)Mockito.doNothing().when((Object)this.provider)).freeUnusedResources();
        }

        Object doCall() throws Exception {
            while (this.condition.get()) {
                this.fsm.addProvider("scheme", (FileProvider)this.provider);
                this.condition.set(false);
            }
            return null;
        }
    }

    private class Getter
    extends StopOnErrorCallable<Object> {
        private DefaultFileSystemManager fsm;

        Getter(AtomicBoolean condition, DefaultFileSystemManager fsm) {
            super(condition);
            this.fsm = fsm;
        }

        Object doCall() throws Exception {
            while (this.condition.get()) {
                this.fsm.getSchemes();
            }
            return null;
        }
    }

    public static interface MockNamedClusterProvider
    extends FileProvider,
    VfsEmbeddedFileSystemCloser {
    }
}

