/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.concurrency;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.concurrency.ConcurrencyTestRunner;
import org.pentaho.di.concurrency.StopOnErrorCallable;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepPartitioningMeta;

public class BaseStepConcurrencyTest {
    private static final String STEP_META = "StepMeta";
    private BaseStep baseStep;

    @Test
    public void testRowListeners() throws Exception {
        int modifiersAmount = 100;
        int traversersAmount = 100;
        StepMeta stepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        TransMeta transMeta = (TransMeta)Mockito.mock(TransMeta.class);
        Mockito.when((Object)stepMeta.getName()).thenReturn((Object)STEP_META);
        Mockito.when((Object)transMeta.findStep(STEP_META)).thenReturn((Object)stepMeta);
        Mockito.when((Object)stepMeta.getTargetStepPartitioningMeta()).thenReturn(Mockito.mock(StepPartitioningMeta.class));
        this.baseStep = new BaseStep(stepMeta, null, 0, transMeta, (Trans)Mockito.mock(Trans.class));
        AtomicBoolean condition = new AtomicBoolean(true);
        ArrayList<RowListenersModifier> rowListenersModifiers = new ArrayList<RowListenersModifier>();
        for (int i = 0; i < modifiersAmount; ++i) {
            rowListenersModifiers.add(new RowListenersModifier(condition));
        }
        ArrayList<RowListenersTraverser> rowListenersTraversers = new ArrayList<RowListenersTraverser>();
        for (int i = 0; i < traversersAmount; ++i) {
            rowListenersTraversers.add(new RowListenersTraverser(condition));
        }
        ConcurrencyTestRunner runner = new ConcurrencyTestRunner(rowListenersModifiers, rowListenersTraversers, condition);
        runner.runConcurrentTest();
        runner.checkNoExceptionRaised();
    }

    @Test
    public void testInputOutputRowSets() throws Exception {
        int modifiersAmount = 100;
        int traversersAmount = 100;
        StepMeta stepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        TransMeta transMeta = (TransMeta)Mockito.mock(TransMeta.class);
        Mockito.when((Object)stepMeta.getName()).thenReturn((Object)STEP_META);
        Mockito.when((Object)transMeta.findStep(STEP_META)).thenReturn((Object)stepMeta);
        Mockito.when((Object)stepMeta.getTargetStepPartitioningMeta()).thenReturn(Mockito.mock(StepPartitioningMeta.class));
        this.baseStep = new BaseStep(stepMeta, null, 0, transMeta, (Trans)Mockito.mock(Trans.class));
        AtomicBoolean condition = new AtomicBoolean(true);
        ArrayList<RowSetsModifier> rowSetsModifiers = new ArrayList<RowSetsModifier>();
        for (int i = 0; i < modifiersAmount; ++i) {
            rowSetsModifiers.add(new RowSetsModifier(condition));
        }
        ArrayList<RowSetsTraverser> rowSetsTraversers = new ArrayList<RowSetsTraverser>();
        for (int i = 0; i < traversersAmount; ++i) {
            rowSetsTraversers.add(new RowSetsTraverser(condition));
        }
        ConcurrencyTestRunner runner = new ConcurrencyTestRunner(rowSetsModifiers, rowSetsTraversers, condition);
        runner.runConcurrentTest();
        runner.checkNoExceptionRaised();
    }

    private class RowListenersTraverser
    extends StopOnErrorCallable<BaseStep> {
        RowListenersTraverser(AtomicBoolean condition) {
            super(condition);
        }

        BaseStep doCall() throws Exception {
            for (RowListener rowListener : BaseStepConcurrencyTest.this.baseStep.getRowListeners()) {
                rowListener.rowWrittenEvent((RowMetaInterface)Mockito.mock(RowMetaInterface.class), new Object[0]);
            }
            return null;
        }
    }

    private class RowListenersModifier
    extends StopOnErrorCallable<BaseStep> {
        RowListenersModifier(AtomicBoolean condition) {
            super(condition);
        }

        BaseStep doCall() {
            BaseStepConcurrencyTest.this.baseStep.addRowListener((RowListener)Mockito.mock(RowListener.class));
            return null;
        }
    }

    private class RowSetsTraverser
    extends StopOnErrorCallable<BaseStep> {
        RowSetsTraverser(AtomicBoolean condition) {
            super(condition);
        }

        BaseStep doCall() {
            for (RowSet rowSet : BaseStepConcurrencyTest.this.baseStep.getInputRowSets()) {
                rowSet.setRowMeta((RowMetaInterface)Mockito.mock(RowMetaInterface.class));
            }
            for (RowSet rowSet : BaseStepConcurrencyTest.this.baseStep.getOutputRowSets()) {
                rowSet.setRowMeta((RowMetaInterface)Mockito.mock(RowMetaInterface.class));
            }
            return null;
        }
    }

    private class RowSetsModifier
    extends StopOnErrorCallable<BaseStep> {
        RowSetsModifier(AtomicBoolean condition) {
            super(condition);
        }

        BaseStep doCall() {
            BaseStepConcurrencyTest.this.baseStep.addRowSetToInputRowSets((RowSet)Mockito.mock(RowSet.class));
            BaseStepConcurrencyTest.this.baseStep.addRowSetToOutputRowSets((RowSet)Mockito.mock(RowSet.class));
            return null;
        }
    }
}

