/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.concurrency;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Test;
import org.pentaho.di.concurrency.ConcurrencyTestRunner;
import org.pentaho.di.concurrency.StopOnErrorCallable;
import org.pentaho.di.trans.Trans;

public class ActiveSubTransformationsConcurrencyTest {
    private static final int NUMBER_OF_GETTERS = 10;
    private static final int NUMBER_OF_CREATES = 10;
    private static final int NUMBER_OF_CREATE_CYCLES = 20;
    private static final int INITIAL_NUMBER_OF_TRANS = 100;
    private static final String TRANS_NAME = "transformation";
    private final Object lock = new Object();

    @Test
    public void getAndCreateConcurrently() throws Exception {
        AtomicBoolean condition = new AtomicBoolean(true);
        Trans trans = new Trans();
        this.createSubTransformations(trans);
        List<Getter> getters = this.generateGetters(trans, condition);
        List<Creator> creators = this.generateCreators(trans, condition);
        ConcurrencyTestRunner.runAndCheckNoExceptionRaised(creators, getters, (AtomicBoolean)condition);
    }

    private void createSubTransformations(Trans trans) {
        for (int i = 0; i < 100; ++i) {
            trans.addActiveSubTransformation(this.createTransName(i), new Trans());
        }
    }

    private List<Getter> generateGetters(Trans trans, AtomicBoolean condition) {
        ArrayList<Getter> getters = new ArrayList<Getter>();
        for (int i = 0; i < 10; ++i) {
            getters.add(new Getter(trans, condition));
        }
        return getters;
    }

    private List<Creator> generateCreators(Trans trans, AtomicBoolean condition) {
        ArrayList<Creator> creators = new ArrayList<Creator>();
        for (int i = 0; i < 10; ++i) {
            creators.add(new Creator(trans, condition));
        }
        return creators;
    }

    private String createTransName(int id) {
        return "transformation - " + id;
    }

    private class Creator
    extends StopOnErrorCallable<Object> {
        private final Trans trans;
        private final Random random;

        Creator(Trans trans, AtomicBoolean condition) {
            super(condition);
            this.trans = trans;
            this.random = new Random();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object doCall() throws Exception {
            for (int i = 0; i < 20; ++i) {
                Object object = ActiveSubTransformationsConcurrencyTest.this.lock;
                synchronized (object) {
                    String transName = ActiveSubTransformationsConcurrencyTest.this.createTransName(this.randomInt(100, Integer.MAX_VALUE));
                    this.trans.addActiveSubTransformation(transName, new Trans());
                    continue;
                }
            }
            return null;
        }

        private int randomInt(int min, int max) {
            return this.random.nextInt(max - min) + min;
        }
    }

    private class Getter
    extends StopOnErrorCallable<Object> {
        private final Trans trans;
        private final Random random;

        Getter(Trans trans, AtomicBoolean condition) {
            super(condition);
            this.trans = trans;
            this.random = new Random();
        }

        Object doCall() throws Exception {
            while (this.condition.get()) {
                String activeSubTransName = ActiveSubTransformationsConcurrencyTest.this.createTransName(this.random.nextInt(100));
                Trans subTrans = this.trans.getActiveSubTransformation(activeSubTransName);
                if (subTrans != null) continue;
                throw new IllegalStateException(String.format("Returned transformation must not be null. Transformation name = %s", activeSubTransName));
            }
            return null;
        }
    }
}

