/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.cluster;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.h2.util.IOUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.pentaho.di.cluster.SlaveConnectionManager;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.encryption.TwoWayPasswordEncoderPluginType;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.utils.TestUtils;

public class SlaveServerTest {
    SlaveServer slaveServer;

    @BeforeClass
    public static void beforeClass() throws KettleException {
        PluginRegistry.addPluginType((PluginTypeInterface)TwoWayPasswordEncoderPluginType.getInstance());
        PluginRegistry.init();
        String passwordEncoderPluginID = Const.NVL((String)EnvUtil.getSystemProperty((String)"KETTLE_PASSWORD_ENCODER_PLUGIN"), (String)"Kettle");
        Encr.init((String)passwordEncoderPluginID);
    }

    @AfterClass
    public static void tearDown() {
        PluginRegistry.getInstance().reset();
    }

    @Before
    public void init() throws IOException {
        SlaveConnectionManager connectionManager = SlaveConnectionManager.getInstance();
        HttpClient httpClient = (HttpClient)Mockito.spy((Object)connectionManager.createHttpClient());
        CloseableHttpResponse closeableHttpResponseMock = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        StatusLine statusLineMock = (StatusLine)Mockito.mock(StatusLine.class);
        ((StatusLine)Mockito.doReturn((Object)404).when((Object)statusLineMock)).getStatusCode();
        ((CloseableHttpResponse)Mockito.doReturn((Object)statusLineMock).when((Object)closeableHttpResponseMock)).getStatusLine();
        HttpEntity httpEntityMock = (HttpEntity)Mockito.mock(HttpEntity.class);
        ((CloseableHttpResponse)Mockito.doReturn((Object)httpEntityMock).when((Object)closeableHttpResponseMock)).getEntity();
        ((HttpClient)Mockito.doReturn((Object)closeableHttpResponseMock).when((Object)httpClient)).execute((HttpUriRequest)Matchers.any(HttpGet.class));
        ((HttpClient)Mockito.doReturn((Object)closeableHttpResponseMock).when((Object)httpClient)).execute((HttpUriRequest)Matchers.any(HttpPost.class));
        ((HttpClient)Mockito.doReturn((Object)closeableHttpResponseMock).when((Object)httpClient)).execute((HttpUriRequest)Matchers.any(HttpPost.class), (HttpContext)Matchers.any(HttpClientContext.class));
        this.slaveServer = (SlaveServer)Mockito.spy((Object)new SlaveServer());
        ((SlaveServer)Mockito.doReturn((Object)httpClient).when((Object)this.slaveServer)).getHttpClient();
        ((SlaveServer)Mockito.doReturn((Object)"response_body").when((Object)this.slaveServer)).getResponseBodyAsString((InputStream)Matchers.any(InputStream.class));
    }

    private HttpResponse mockResponse(int statusCode, String entityText) throws IOException {
        HttpResponse resp = (HttpResponse)Mockito.mock(HttpResponse.class);
        StatusLine status = (StatusLine)Mockito.mock(StatusLine.class);
        Mockito.when((Object)status.getStatusCode()).thenReturn((Object)statusCode);
        Mockito.when((Object)resp.getStatusLine()).thenReturn((Object)status);
        HttpEntity entity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)entity.getContent()).thenReturn((Object)IOUtils.getInputStream((String)entityText));
        Mockito.when((Object)resp.getEntity()).thenReturn((Object)entity);
        return resp;
    }

    @Test(expected=KettleException.class)
    public void testExecService() throws Exception {
        HttpGet httpGetMock = (HttpGet)Mockito.mock(HttpGet.class);
        URI uriMock = new URI("fake");
        ((HttpGet)Mockito.doReturn((Object)uriMock).when((Object)httpGetMock)).getURI();
        ((SlaveServer)Mockito.doReturn((Object)httpGetMock).when((Object)this.slaveServer)).buildExecuteServiceMethod(Matchers.anyString(), Matchers.anyMapOf(String.class, String.class));
        this.slaveServer.setHostname("hostNameStub");
        this.slaveServer.setUsername("userNAmeStub");
        this.slaveServer.execService("wrong_app_name");
        Assert.fail((String)"Incorrect connection details had been used, but no exception was thrown");
    }

    @Test(expected=KettleException.class)
    public void testSendXML() throws Exception {
        this.slaveServer.setHostname("hostNameStub");
        this.slaveServer.setUsername("userNAmeStub");
        HttpPost httpPostMock = (HttpPost)Mockito.mock(HttpPost.class);
        URI uriMock = new URI("fake");
        ((HttpPost)Mockito.doReturn((Object)uriMock).when((Object)httpPostMock)).getURI();
        ((SlaveServer)Mockito.doReturn((Object)httpPostMock).when((Object)this.slaveServer)).buildSendXMLMethod((byte[])Matchers.any(byte[].class), Matchers.anyString());
        this.slaveServer.sendXML("", "");
        Assert.fail((String)"Incorrect connection details had been used, but no exception was thrown");
    }

    @Test(expected=KettleException.class)
    public void testSendExport() throws Exception {
        this.slaveServer.setHostname("hostNameStub");
        this.slaveServer.setUsername("userNAmeStub");
        HttpPost httpPostMock = (HttpPost)Mockito.mock(HttpPost.class);
        URI uriMock = new URI("fake");
        ((HttpPost)Mockito.doReturn((Object)uriMock).when((Object)httpPostMock)).getURI();
        ((SlaveServer)Mockito.doReturn((Object)httpPostMock).when((Object)this.slaveServer)).buildSendExportMethod(Matchers.anyString(), Matchers.anyString(), (InputStream)Matchers.any(InputStream.class));
        File tempFile = File.createTempFile("PDI-", "tmp");
        tempFile.deleteOnExit();
        this.slaveServer.sendExport(tempFile.getAbsolutePath(), "", "");
        Assert.fail((String)"Incorrect connection details had been used, but no exception was thrown");
    }

    @Test
    public void testSendExportOk() throws Exception {
        this.slaveServer.setUsername("uname");
        this.slaveServer.setPassword("passw");
        this.slaveServer.setHostname("hname");
        this.slaveServer.setPort("1111");
        HttpPost httpPostMock = (HttpPost)Mockito.mock(HttpPost.class);
        URI uriMock = new URI("fake");
        String responseContent = "baah";
        Mockito.when((Object)httpPostMock.getURI()).thenReturn((Object)uriMock);
        ((HttpPost)Mockito.doReturn((Object)uriMock).when((Object)httpPostMock)).getURI();
        HttpClient client = (HttpClient)Mockito.mock(HttpClient.class);
        Mockito.when((Object)client.execute((HttpUriRequest)Matchers.any(), (HttpContext)Matchers.any(HttpContext.class))).then((Answer)new Answer<HttpResponse>(){

            public HttpResponse answer(InvocationOnMock invocation) throws Throwable {
                HttpClientContext context = (HttpClientContext)invocation.getArgumentAt(1, HttpClientContext.class);
                Credentials cred = context.getCredentialsProvider().getCredentials(new AuthScope("hname", 1111));
                Assert.assertEquals((Object)"uname", (Object)cred.getUserPrincipal().getName());
                return SlaveServerTest.this.mockResponse(200, "baah");
            }
        });
        Mockito.when((Object)this.slaveServer.getHttpClient()).thenReturn((Object)client);
        Mockito.when((Object)this.slaveServer.getResponseBodyAsString((InputStream)Matchers.any())).thenCallRealMethod();
        ((SlaveServer)Mockito.doReturn((Object)httpPostMock).when((Object)this.slaveServer)).buildSendExportMethod(Matchers.anyString(), Matchers.anyString(), (InputStream)Matchers.any(InputStream.class));
        File tempFile = File.createTempFile("PDI-", "tmp");
        tempFile.deleteOnExit();
        String result = this.slaveServer.sendExport(tempFile.getAbsolutePath(), null, null);
        Assert.assertEquals((Object)"baah", (Object)result);
    }

    @Test
    public void testAddCredentials() throws IOException, ClassNotFoundException {
        String testUser = "test_username";
        this.slaveServer.setUsername(testUser);
        String testPassword = "test_password";
        this.slaveServer.setPassword(testPassword);
        String host = "somehost";
        this.slaveServer.setHostname(host);
        int port = 1000;
        this.slaveServer.setPort("" + port);
        HttpClientContext auth = this.slaveServer.getAuthContext();
        Credentials cred = auth.getCredentialsProvider().getCredentials(new AuthScope(host, port));
        Assert.assertEquals((Object)testUser, (Object)cred.getUserPrincipal().getName());
        Assert.assertEquals((Object)testPassword, (Object)cred.getPassword());
        String user2 = "user2";
        this.slaveServer.setUsername(user2);
        this.slaveServer.setPassword("pass2");
        auth = this.slaveServer.getAuthContext();
        cred = auth.getCredentialsProvider().getCredentials(new AuthScope(host, port));
        Assert.assertEquals((Object)user2, (Object)cred.getUserPrincipal().getName());
    }

    @Test
    public void testAuthCredentialsSchemeWithSSL() {
        this.slaveServer.setUsername("admin");
        this.slaveServer.setPassword("password");
        this.slaveServer.setHostname("localhost");
        this.slaveServer.setPort("8443");
        this.slaveServer.setSslMode(true);
        AuthCache cache = this.slaveServer.getAuthContext().getAuthCache();
        Assert.assertNotNull((Object)cache.get(new HttpHost("localhost", 8443, "https")));
        Assert.assertNull((Object)cache.get(new HttpHost("localhost", 8443, "http")));
    }

    @Test
    public void testAuthCredentialsSchemeWithoutSSL() {
        this.slaveServer.setUsername("admin");
        this.slaveServer.setPassword("password");
        this.slaveServer.setHostname("localhost");
        this.slaveServer.setPort("8080");
        this.slaveServer.setSslMode(false);
        AuthCache cache = this.slaveServer.getAuthContext().getAuthCache();
        Assert.assertNull((Object)cache.get(new HttpHost("localhost", 8080, "https")));
        Assert.assertNotNull((Object)cache.get(new HttpHost("localhost", 8080, "http")));
    }

    @Test
    public void testModifyingName() {
        this.slaveServer.setName("test");
        ArrayList<SlaveServer> list = new ArrayList<SlaveServer>();
        list.add(this.slaveServer);
        SlaveServer slaveServer2 = (SlaveServer)Mockito.spy((Object)new SlaveServer());
        slaveServer2.setName("test");
        slaveServer2.verifyAndModifySlaveServerName(list, null);
        Assert.assertTrue((!this.slaveServer.getName().equals(slaveServer2.getName()) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsHashCodeConsistency() throws Exception {
        SlaveServer slave = new SlaveServer();
        slave.setName("slave");
        TestUtils.checkEqualsHashCodeConsistency(slave, slave);
        SlaveServer slaveSame = new SlaveServer();
        slaveSame.setName("slave");
        Assert.assertTrue((boolean)slave.equals((Object)slaveSame));
        TestUtils.checkEqualsHashCodeConsistency(slave, slaveSame);
        SlaveServer slaveCaps = new SlaveServer();
        slaveCaps.setName("SLAVE");
        TestUtils.checkEqualsHashCodeConsistency(slave, slaveCaps);
        SlaveServer slaveOther = new SlaveServer();
        slaveOther.setName("something else");
        TestUtils.checkEqualsHashCodeConsistency(slave, slaveOther);
    }

    @Test
    public void testGetKettleProperties() throws Exception {
        String encryptedResponse = "3c3f786d6c2076657273696f6e3d22312e302220656e636f64696e673d225554462d38223f3e0a3c21444f43545950452070726f706572746965730a202053595354454d2022687474703a2f2f6a6176612e73756e2e636f6d2f6474642f70726f706572746965732e647464223e0a3c70726f706572746965733e0a2020203c636f6d6d656e743e3c2f636f6d6d656e743e0a2020203c656e747279206b65793d224167696c6542494461746162617365223e4167696c6542493c2f656e7470c7a6a5f445d7808bbb1cbc64d797bc84";
        ((SlaveServer)Mockito.doReturn((Object)encryptedResponse).when((Object)this.slaveServer)).execService("/kettle/properties/?xml=Y");
        this.slaveServer.getKettleProperties().getProperty("AgileBIDatabase");
        Assert.assertEquals((Object)"AgileBI", (Object)this.slaveServer.getKettleProperties().getProperty("AgileBIDatabase"));
    }
}

