/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.cluster;

import java.util.ArrayList;
import java.util.Date;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.www.SlaveServerDetection;

public class ClusterSchemaTest {
    private ClusterSchema clusterSchema;

    @Before
    public void before() {
        this.clusterSchema = (ClusterSchema)Mockito.spy(ClusterSchema.class);
    }

    @Test
    public void testUpdateActivityStatusInGetSlaveServers() throws Exception {
        SlaveServer master = (SlaveServer)Mockito.mock(SlaveServer.class);
        SlaveServer activeSlaveServer = (SlaveServer)Mockito.mock(SlaveServer.class);
        SlaveServer inactiveSlaveServer = (SlaveServer)Mockito.mock(SlaveServer.class);
        SlaveServerDetection masterDetection = (SlaveServerDetection)Mockito.mock(SlaveServerDetection.class);
        SlaveServerDetection activeSlaveServerDetection = (SlaveServerDetection)Mockito.mock(SlaveServerDetection.class);
        SlaveServerDetection inactiveSlaveServerDetection = (SlaveServerDetection)Mockito.mock(SlaveServerDetection.class);
        ArrayList<SlaveServer> slaveServers = new ArrayList<SlaveServer>();
        slaveServers.add(master);
        slaveServers.add(activeSlaveServer);
        slaveServers.add(inactiveSlaveServer);
        ArrayList<SlaveServerDetection> detections = new ArrayList<SlaveServerDetection>();
        detections.add(masterDetection);
        detections.add(activeSlaveServerDetection);
        detections.add(inactiveSlaveServerDetection);
        ((ClusterSchema)Mockito.doReturn((Object)true).when((Object)this.clusterSchema)).isDynamic();
        ((SlaveServer)Mockito.doReturn((Object)true).when((Object)master)).isMaster();
        ((SlaveServer)Mockito.doReturn((Object)false).when((Object)activeSlaveServer)).isMaster();
        ((SlaveServer)Mockito.doReturn((Object)false).when((Object)inactiveSlaveServer)).isMaster();
        ((SlaveServer)Mockito.doReturn(detections).when((Object)master)).getSlaveServerDetections();
        ((SlaveServerDetection)Mockito.doReturn((Object)master).when((Object)masterDetection)).getSlaveServer();
        ((SlaveServerDetection)Mockito.doReturn((Object)activeSlaveServer).when((Object)activeSlaveServerDetection)).getSlaveServer();
        ((SlaveServerDetection)Mockito.doReturn((Object)inactiveSlaveServer).when((Object)inactiveSlaveServerDetection)).getSlaveServer();
        ((SlaveServer)Mockito.doThrow((Throwable)new Exception()).when((Object)inactiveSlaveServer)).getStatus();
        this.clusterSchema.setSlaveServers(slaveServers);
        this.clusterSchema.getSlaveServersFromMasterOrLocal();
        ((SlaveServer)Mockito.verify((Object)master)).getStatus();
        ((SlaveServerDetection)Mockito.verify((Object)masterDetection, (VerificationMode)Mockito.never())).setActive(false);
        ((SlaveServerDetection)Mockito.verify((Object)masterDetection, (VerificationMode)Mockito.never())).setLastInactiveDate((Date)Matchers.anyObject());
        ((SlaveServer)Mockito.verify((Object)activeSlaveServer)).getStatus();
        ((SlaveServerDetection)Mockito.verify((Object)activeSlaveServerDetection, (VerificationMode)Mockito.never())).setActive(false);
        ((SlaveServerDetection)Mockito.verify((Object)activeSlaveServerDetection, (VerificationMode)Mockito.never())).setLastInactiveDate((Date)Matchers.anyObject());
        ((SlaveServer)Mockito.verify((Object)inactiveSlaveServer)).getStatus();
        ((SlaveServerDetection)Mockito.verify((Object)inactiveSlaveServerDetection)).setActive(false);
        ((SlaveServerDetection)Mockito.verify((Object)inactiveSlaveServerDetection)).setLastInactiveDate((Date)Matchers.anyObject());
    }
}

