/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.base;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.matchers.JUnitMatchers;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.shared.SharedObjects;

public abstract class PrivateDatabasesTestTemplate<T extends AbstractMeta> {
    protected void doTest_OnePrivate_TwoShared() throws Exception {
        T meta = this.createMeta();
        DatabaseMeta privateMeta = this.createDatabase("privateMeta");
        meta.addDatabase(privateMeta);
        String xml = this.toXml(meta);
        DatabaseMeta meta1 = this.createDatabase("meta1");
        meta1.setShared(true);
        DatabaseMeta meta2 = this.createDatabase("meta2");
        meta2.setShared(true);
        SharedObjects fakeSharedObjects = this.createFakeSharedObjects(meta1, meta2);
        T loaded = this.fromXml(xml, fakeSharedObjects);
        List<String> loadedDbs = Arrays.asList(loaded.getDatabaseNames());
        Assert.assertEquals((long)3L, (long)loadedDbs.size());
        Assert.assertThat(loadedDbs, (Matcher)JUnitMatchers.hasItems((Object[])new String[]{"meta1", "meta2", "privateMeta"}));
        Set privateDatabases = loaded.getPrivateDatabases();
        Assert.assertNotNull((Object)privateDatabases);
        Assert.assertEquals((long)1L, (long)privateDatabases.size());
        Assert.assertTrue((boolean)privateDatabases.contains("privateMeta"));
    }

    protected void doTest_NoPrivate() throws Exception {
        T meta = this.createMeta();
        String xml = this.toXml(meta);
        SharedObjects fakeSharedObjects = this.createFakeSharedObjects(new DatabaseMeta[0]);
        T loaded = this.fromXml(xml, fakeSharedObjects);
        Set privateDatabases = loaded.getPrivateDatabases();
        Assert.assertNotNull((Object)privateDatabases);
        Assert.assertTrue((boolean)privateDatabases.isEmpty());
    }

    protected void doTest_OnePrivate_NoShared() throws Exception {
        T meta = this.createMeta();
        DatabaseMeta privateMeta = this.createDatabase("privateMeta");
        meta.addDatabase(privateMeta);
        String xml = this.toXml(meta);
        SharedObjects fakeSharedObjects = this.createFakeSharedObjects(new DatabaseMeta[0]);
        T loaded = this.fromXml(xml, fakeSharedObjects);
        List<String> loadedDbs = Arrays.asList(loaded.getDatabaseNames());
        Assert.assertTrue((boolean)loadedDbs.contains("privateMeta"));
        Set privateDatabases = loaded.getPrivateDatabases();
        Assert.assertNotNull((Object)privateDatabases);
        Assert.assertEquals((long)1L, (long)privateDatabases.size());
        Assert.assertTrue((boolean)privateDatabases.contains(privateMeta.getName()));
    }

    protected DatabaseMeta createDatabase(String name) {
        DatabaseMeta db = new DatabaseMeta();
        db.setName(name);
        db.getDatabaseInterface().setDatabaseName(name);
        return db;
    }

    protected SharedObjects createFakeSharedObjects(DatabaseMeta ... shared) throws Exception {
        SharedObjects fake = new SharedObjects();
        Map map = fake.getObjectsMap();
        map.clear();
        if (shared != null) {
            for (DatabaseMeta meta : shared) {
                map.put(new Object(), meta);
            }
        }
        return fake;
    }

    protected Answer<SharedObjects> createInjectingAnswer(final T meta, final SharedObjects fakeSharedObjects) throws Exception {
        return new Answer<SharedObjects>(){

            public SharedObjects answer(InvocationOnMock invocation) throws Throwable {
                for (SharedObjectInterface value : fakeSharedObjects.getObjectsMap().values()) {
                    DatabaseMeta db = (DatabaseMeta)value;
                    meta.addOrReplaceDatabase(db);
                }
                return fakeSharedObjects;
            }
        };
    }

    protected abstract T createMeta();

    protected abstract T fromXml(String var1, SharedObjects var2) throws Exception;

    protected abstract String toXml(T var1) throws Exception;
}

