/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.base;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mockito.Mockito;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.loadsave.getter.Getter;
import org.pentaho.di.trans.steps.loadsave.initializer.InitializerInterface;
import org.pentaho.di.trans.steps.loadsave.setter.Setter;
import org.pentaho.di.trans.steps.loadsave.validator.DefaultFieldLoadSaveValidatorFactory;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidatorFactory;
import org.pentaho.di.trans.steps.named.cluster.NamedClusterEmbedManager;
import org.pentaho.test.util.JavaBeanManipulator;

public abstract class LoadSaveBase<T> {
    final Class<T> clazz;
    protected final List<String> xmlAttributes;
    protected final List<String> repoAttributes;
    protected final JavaBeanManipulator<T> manipulator;
    protected final FieldLoadSaveValidatorFactory fieldLoadSaveValidatorFactory;
    protected final List<DatabaseMeta> databases;
    protected final InitializerInterface<T> initializer;

    public LoadSaveBase(Class<T> clazz, List<String> commonAttributes, List<String> xmlAttributes, List<String> repoAttributes, Map<String, String> getterMap, Map<String, String> setterMap, Map<String, FieldLoadSaveValidator<?>> fieldLoadSaveValidatorAttributeMap, Map<String, FieldLoadSaveValidator<?>> fieldLoadSaveValidatorTypeMap, InitializerInterface<T> initializer) {
        this.clazz = clazz;
        this.xmlAttributes = LoadSaveBase.concat(commonAttributes, xmlAttributes);
        this.repoAttributes = LoadSaveBase.concat(commonAttributes, repoAttributes);
        this.manipulator = new JavaBeanManipulator<T>(clazz, LoadSaveBase.concat(this.xmlAttributes, repoAttributes), getterMap, setterMap);
        this.initializer = initializer;
        HashMap fieldLoadSaveValidatorMethodMap = new HashMap(fieldLoadSaveValidatorAttributeMap.size());
        for (Map.Entry<String, FieldLoadSaveValidator<?>> entry : fieldLoadSaveValidatorAttributeMap.entrySet()) {
            fieldLoadSaveValidatorMethodMap.put(this.manipulator.getGetter(entry.getKey()), entry.getValue());
        }
        this.fieldLoadSaveValidatorFactory = new DefaultFieldLoadSaveValidatorFactory(fieldLoadSaveValidatorMethodMap, fieldLoadSaveValidatorTypeMap);
        this.databases = new ArrayList<DatabaseMeta>();
    }

    public LoadSaveBase(Class<T> clazz, List<String> commonAttributes, List<String> xmlAttributes, List<String> repoAttributes, Map<String, String> getterMap, Map<String, String> setterMap, Map<String, FieldLoadSaveValidator<?>> fieldLoadSaveValidatorAttributeMap, Map<String, FieldLoadSaveValidator<?>> fieldLoadSaveValidatorTypeMap) {
        this(clazz, commonAttributes, xmlAttributes, repoAttributes, getterMap, setterMap, fieldLoadSaveValidatorAttributeMap, fieldLoadSaveValidatorTypeMap, null);
    }

    public LoadSaveBase(Class<T> clazz, List<String> commonAttributes) {
        this(clazz, commonAttributes, new ArrayList<String>(), new ArrayList<String>(), new HashMap<String, String>(), new HashMap<String, String>(), new HashMap(), new HashMap());
    }

    public T createMeta() {
        try {
            T meta = this.clazz.newInstance();
            if (meta instanceof BaseStepMeta) {
                StepMeta mockParentStepMeta = (StepMeta)Mockito.mock(StepMeta.class);
                ((BaseStepMeta)meta).setParentStepMeta(mockParentStepMeta);
                TransMeta mockTransMeta = (TransMeta)Mockito.mock(TransMeta.class);
                NamedClusterEmbedManager embedManager = (NamedClusterEmbedManager)Mockito.mock(NamedClusterEmbedManager.class);
                Mockito.when((Object)mockParentStepMeta.getParentTransMeta()).thenReturn((Object)mockTransMeta);
                Mockito.when((Object)mockTransMeta.getNamedClusterEmbedManager()).thenReturn((Object)embedManager);
            }
            return meta;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create meta of class " + this.clazz.getCanonicalName(), e);
        }
    }

    protected Map<String, FieldLoadSaveValidator<?>> createValidatorMapAndInvokeSetters(List<String> attributes, T metaToSave) {
        HashMap validatorMap = new HashMap();
        this.databases.clear();
        for (String attribute : attributes) {
            Getter<?> getter = this.manipulator.getGetter(attribute);
            Setter<?> setter = this.manipulator.getSetter(attribute);
            FieldLoadSaveValidator<?> validator = this.fieldLoadSaveValidatorFactory.createValidator(getter);
            try {
                Object testValue = validator.getTestObject();
                setter.set(metaToSave, testValue);
                if (testValue instanceof DatabaseMeta) {
                    this.addDatabase((DatabaseMeta)testValue);
                } else if (testValue instanceof DatabaseMeta[]) {
                    this.addDatabase((DatabaseMeta[])testValue);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to invoke setter for " + attribute, e);
            }
            validatorMap.put(attribute, validator);
        }
        return validatorMap;
    }

    protected void validateLoadedMeta(List<String> attributes, Map<String, FieldLoadSaveValidator<?>> validatorMap, T metaSaved, T metaLoaded) {
        for (String attribute : attributes) {
            try {
                Getter<?> getterMethod = this.manipulator.getGetter(attribute);
                Object originalValue = getterMethod.get(metaSaved);
                Object value = getterMethod.get(metaLoaded);
                FieldLoadSaveValidator<?> validator = validatorMap.get(attribute);
                Method[] validatorMethods = validator.getClass().getMethods();
                Method validatorMethod = null;
                for (Method method : validatorMethods) {
                    Class<?>[] types;
                    if (!"validateTestObject".equals(method.getName()) || (types = method.getParameterTypes()).length != 2 || types[1] != Object.class || originalValue != null && !types[0].isAssignableFrom(originalValue.getClass())) continue;
                    validatorMethod = method;
                    break;
                }
                if (validatorMethod == null) {
                    throw new RuntimeException("Couldn't find proper validateTestObject method on " + validator.getClass().getCanonicalName());
                }
                if (((Boolean)validatorMethod.invoke(validator, originalValue, value)).booleanValue()) continue;
                throw new KettleException("Attribute " + attribute + " started with value " + originalValue + " ended with value " + value);
            }
            catch (Exception e) {
                throw new RuntimeException("Error validating " + attribute, e);
            }
        }
    }

    private static <E> List<E> concat(List<E> list1, List<E> list2) {
        ArrayList<E> result = new ArrayList<E>(list1.size() + list2.size());
        result.addAll(list1);
        result.addAll(list2);
        return result;
    }

    protected void addDatabase(DatabaseMeta db) {
        if (!this.databases.contains(db)) {
            this.databases.add(db);
        }
    }

    protected void addDatabase(DatabaseMeta[] db) {
        if (db != null) {
            for (DatabaseMeta meta : db) {
                this.addDatabase(meta);
            }
        }
    }
}

