package cn.benma666.kettle.steps.easyexpand;

import cn.benma666.myutils.StringUtil;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.*;
import org.w3c.dom.Node;

import java.util.List;
import java.util.Map;

/**
* 元数据 <br/>
* date: 2016年8月18日 <br/>
* @author jingma
* @version 
*/
@Step(
		id = "MyEasyExpand",
		name = "KettleUtil.name",
		description = "KettleUtil.description",
		image = "cn/benma666/kettle/steps/easyexpand/resources/EasyExpend.svg",
		categoryDescription = "i18n:org.pentaho.di.trans.step:BaseStep.Category.Utility",
		i18nPackageName = "cn.benma666.kettle.steps.easyexpand",
		documentationUrl = "KettleUtil.DocumentationURL",
		casesUrl = "KettleUtil.CasesURL",
		forumUrl = "KettleUtil.ForumURL"
)
public class EasyExpandMeta extends BaseStepMeta implements StepMetaInterface {

	private static Class<?> PKG = EasyExpandMeta.class; // for i18n purposes
    /**
    * 类名称
    */
    private String className = "cn.benma666.kettle.easyexpand.EasyExpandDemo";
	/**
	* 具体配置信息
	*/
	private String configInfo = "{}";

	public EasyExpandMeta() {
		super(); 
	}
    /**
     * @return className 
     */
    public String getClassName() {
        return className;
    }
    /**
     * @param className the className to set
     */
    public void setClassName(String className) {
        this.className = className;
    }
    /**
     * @return configInfo 
     */
    public String getConfigInfo() {
        return configInfo;
    }

    /**
     * @param configInfo the configInfo to set
     */
    public void setConfigInfo(String configInfo) {
        this.configInfo = configInfo;
    }

    public String getXML() throws KettleValueException {
		String retval = "";
		retval += "		<classname>" + getClassName() + "</classname>" + Const.CR;
        retval += "     <configinfo>" + getConfigInfo() + "</configinfo>" + Const.CR;
		return retval;
	}

    public void getFields(RowMetaInterface r, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) {
		if(StringUtil.isNotBlank(className)){
		    try {
		        //实例化配置的类，获取输出字段
		        EasyExpandRunBase kui = (EasyExpandRunBase) Class.forName(space.environmentSubstitute(className)).newInstance();
		        kui.setKu(null);
		        kui.setMeta(this,space);
		        kui.getFields(r, origin, info, nextStep, space);
            } catch (Exception e) {
                logError("获取输出字段失败", e);
            }
		}
	}

    public String getDefaultConfigInfo(TransMeta transMeta, String stepName, VariableSpace space) throws Exception {
        if(StringUtil.isNotBlank(getClassName())){
            //实例化配置的类，获取输出字段
            EasyExpandRunBase kui = (EasyExpandRunBase) Class.forName(space.environmentSubstitute(getClassName())).newInstance();
            kui.setKu(null);
            kui.setMeta(this,space);
            return kui.getDefaultConfigInfo(transMeta,stepName);
        }
        return null;
    }
	public Object clone() {
		Object retval = super.clone();
		return retval;
	}

	public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {

		try {
			setClassName(XMLHandler.getNodeValue(XMLHandler.getSubNode(stepnode, "classname")));
            setConfigInfo(XMLHandler.getNodeValue(XMLHandler.getSubNode(stepnode, "configinfo")));
		} catch (Exception e) {
			throw new KettleXMLException("Template Plugin Unable to read step info from XML node", e);
		}

	}

	public void setDefault() {
        className = "cn.benma666.kettle.easyexpand.EasyExpandDemo";
		configInfo = "{}";
	}

	public void check(List<CheckResultInterface> remarks, TransMeta transmeta, StepMeta stepMeta, RowMetaInterface prev, String input[], String output[], RowMetaInterface info) {
		CheckResult cr;

		// See if we have input streams leading to this step!
		if (input.length > 0) {
			cr = new CheckResult(CheckResult.TYPE_RESULT_OK, "Step is receiving info from other steps.", stepMeta);
			remarks.add(cr);
		} else {
			cr = new CheckResult(CheckResult.TYPE_RESULT_ERROR, "No input received from other steps!", stepMeta);
			remarks.add(cr);
		}	
    	
	}

	public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans disp) {
		return new EasyExpand(stepMeta, stepDataInterface, cnr, transMeta, disp);
	}

	public StepDataInterface getStepData() {
		return new EasyExpandData();
	}

	public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
		try
		{
            className  = rep.getStepAttributeString(id_step, "classname"); //$NON-NLS-1$
			configInfo  = rep.getStepAttributeString(id_step, "configinfo"); //$NON-NLS-1$
		}
		catch(Exception e)
		{
			throw new KettleException(BaseMessages.getString(PKG, "TemplateStep.Exception.UnexpectedErrorInReadingStepInfo"), e);
		}
	}

	public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException
	{
		try
		{
            rep.saveStepAttribute(id_transformation, id_step, "classname", className); //$NON-NLS-1$
			rep.saveStepAttribute(id_transformation, id_step, "configinfo", configInfo); //$NON-NLS-1$
		}
		catch(Exception e)
		{
			throw new KettleException(BaseMessages.getString(PKG, "TemplateStep.Exception.UnableToSaveStepInfoToRepository")+id_step, e); 
		}
	}
}
