package cn.benma666.kettle.steps.easyexpand;

import cn.benma666.exception.MyException;
import cn.benma666.myutils.StringUtil;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.*;

import java.util.Arrays;

/**
* Kettle工具类 <br/>
* date: 2016年6月20日 <br/>
* @author jingma
* @version 
*/
public class EasyExpand extends BaseStep implements StepInterface {

	private EasyExpandData data;
	private EasyExpandMeta meta;
	private EasyExpandRunBase kui;
	
	public EasyExpand(StepMeta s, StepDataInterface stepDataInterface, int c, TransMeta t, Trans dis) {
		super(s, stepDataInterface, c, t, dis);
	}

	public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
		meta = (EasyExpandMeta) smi;
		data = (EasyExpandData) sdi;
		if(StringUtil.isNotBlank(meta.getClassName())){
            try {
                //实例化配置的类
                if(first){
                    kui = (EasyExpandRunBase) Class.forName(
                            environmentSubstitute(meta.getClassName())).newInstance();
                    kui.setKu(this);
                    kui.setMeta(meta,this);
                }
                kui.setData(data);
                return kui.run();
            } catch (Exception e) {
                setErrors(getErrors()+1);
                Object[] ir = null;
                if(kui==null){
                    ir = getRow();
                }else{
                    ir = kui.getInputRow();
                }
                throw new MyException("运行失败,"+meta.getClassName()+","+Arrays.toString(ir)+","
                        +environmentSubstitute(meta.getConfigInfo()), e);
            }
		}else{
	        return defaultRun();
		}

	}

    /**
    * 默认运行方法 <br/>
    * @author jingma
    * @return
    * @throws KettleException
    * @throws KettleStepException
    */
    public boolean defaultRun() throws KettleException, KettleStepException {
        Object[] r = getRow(); // get row, blocks when needed!
		if (r == null) // no more input to be expected...
		{
			setOutputDone();
			return false;
		}

		if (first) {
			first = false;

			data.outputRowMeta = (RowMetaInterface) getInputRowMeta().clone();
			meta.getFields(data.outputRowMeta, getStepname(), null, null, this);

			logBasic("template step initialized successfully");

		}
		
		Object[] outputRow = RowDataUtil.createResizedCopy( r, data.outputRowMeta.size() );

		putRow(data.outputRowMeta, outputRow); // copy row to possible alternate rowset(s)

		if (checkFeedback(getLinesRead())) {
			logBasic("Linenr " + getLinesRead()); // Some basic logging
		}

		return true;
    }

	public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
		meta = (EasyExpandMeta) smi;
		data = (EasyExpandData) sdi;

		return super.init(smi, sdi);
	}

	public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
		meta = (EasyExpandMeta) smi;
		data = (EasyExpandData) sdi;

		super.dispose(smi, sdi);
	}
  /*
   * (non-Javadoc)
   *
   * @see org.pentaho.di.trans.step.StepInterface#stopAll()
   */
  public void stopAll() {
      kui.stopAll();
      super.stopAll();
  }
}
