/*! ******************************************************************************
 *
 * Pentaho Data Integration
 *
 * Copyright (C) 2002-2013 by Pentaho : http://www.pentaho.com
 *
 *******************************************************************************
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ******************************************************************************/

package cn.benma666.kettle.jobentry.easyexpand;

import cn.benma666.myutils.StringUtil;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.annotations.JobEntry;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

import java.lang.reflect.InvocationTargetException;
import java.util.List;

import static org.pentaho.di.job.entry.validator.AndValidator.putValidators;
import static org.pentaho.di.job.entry.validator.JobEntryValidatorUtils.andValidator;
import static org.pentaho.di.job.entry.validator.JobEntryValidatorUtils.notBlankValidator;

/**
* kettle util作业组件 <br/>
* date: 2016年8月18日 <br/>
* @author jingma
* @version
*/
@JobEntry(
        id = "MyJobEntryEasyExpand",
        name = "JobEntryKettleUtil.name",
        description = "JobEntryKettleUtil.description",
        image = "cn/benma666/kettle/jobentry/easyexpand/resources/EasyExpend.svg",
        categoryDescription = "i18n:org.pentaho.di.job:JobCategory.Category.General",
        i18nPackageName = "cn.benma666.kettle.jobentry.easyexpand",
        documentationUrl = "JobEntryKettleUtil.DocumentationURL",
        casesUrl = "JobEntryKettleUtil.CasesURL",
        forumUrl = "JobEntryKettleUtil.ForumURL"
)
public class JobEntryEasyExpand extends JobEntryBase implements Cloneable,
        JobEntryInterface {
    private static Class<?> PKG = JobEntryEasyExpand.class; // for i18n
                                                            // purposes, needed
                                                            // by Translator2!!
    private String className = "cn.benma666.kettle.easyexpand.JobEntryEasyExpandDemo";
    private String configInfo = "{}";

    public JobEntryEasyExpand() {
        super("", "");
    }

    public Object clone() {
        JobEntryEasyExpand je = (JobEntryEasyExpand) super.clone();
        return je;
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer();

        retval.append(super.getXML());
        retval.append("      ").append(
                XMLHandler.addTagValue("configInfo", configInfo));
        retval.append("      ").append(
                XMLHandler.addTagValue("className", className));

        return retval.toString();
    }

    public void loadXML(Node entrynode, List<DatabaseMeta> databases,
            List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore)
            throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            configInfo = XMLHandler.getTagValue(entrynode, "configInfo");
            className = XMLHandler.getTagValue(entrynode, "className");
        } catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG,
                    "JobEntryKettleUtil.UnableToLoadFromXml"), e);
        }
    }

    public void loadRep(Repository rep, IMetaStore metaStore,
            ObjectId id_jobentry, List<DatabaseMeta> databases,
            List<SlaveServer> slaveServers) throws KettleException {
        try {
            configInfo = rep.getJobEntryAttributeString(id_jobentry,
                    "configInfo");
            className = rep
                    .getJobEntryAttributeString(id_jobentry, "className");
        } catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG,
                    "JobEntryKettleUtil.UnableToLoadFromRepo",
                    String.valueOf(id_jobentry)), dbe);
        }
    }

    // Save the attributes of this job entry
    //
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job)
            throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, getObjectId(), "configInfo",
                    configInfo);
            rep.saveJobEntryAttribute(id_job, getObjectId(), "className",
                    className);
        } catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG,
                    "JobEntryKettleUtil.UnableToSaveToRepo",
                    String.valueOf(id_job)), dbe);
        }
    }

    /**
     * @return className
     */
    public String getClassName() {
        return className;
    }

    /**
     * @param className
     *            the className to set
     */
    public void setClassName(String className) {
        this.className = className;
    }

    /**
     * @return configInfo
     */
    public String getConfigInfo() {
        return configInfo;
    }

    /**
     * @param configInfo
     *            the configInfo to set
     */
    public void setConfigInfo(String configInfo) {
        this.configInfo = configInfo;
    }

    /**
     * Execute this job entry and return the result. In this case it means, just
     * set the result boolean in the Result class.
     *
     * @param prev_result
     *            The result of the previous execution
     * @return The Result of the execution.
     */
    public Result execute(Result prev_result, int nr) {
        boolean result = true;
        if(StringUtil.isNotBlank(className)){
            try {
                JobEntryEasyExpandRunBase kui = getJobEntryEasyExpandRunBase();
                result = kui.run();
            } catch (Exception e) {
                prev_result.setNrErrors(1);
                result = false;
                logError("运行失败,"+className+","+environmentSubstitute(configInfo), e);
            }
        }
        prev_result.setResult(result);
        return prev_result;
    }

    private JobEntryEasyExpandRunBase getJobEntryEasyExpandRunBase() throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String cn = environmentSubstitute(className);
        Class<?> jeeerb = Class.forName(cn);
        //实例化配置的类
        JobEntryEasyExpandRunBase kui = (JobEntryEasyExpandRunBase) jeeerb.getConstructor().newInstance();
        kui.setJeku(this);
        return kui;
    }

    /**
    * 获取格式化后的默认JSON配置参数，供使用者方便快捷的修改配置 <br/>
    * @author jingma
    */
    public String getDefaultConfigInfo() throws Exception{
        if(StringUtil.isNotBlank(getClassName())){
            //实例化配置的类，获取输出字段
            JobEntryEasyExpandRunBase kui = getJobEntryEasyExpandRunBase();
            return kui.getDefaultConfigInfo();
        }
        return null;
    }

    public boolean evaluates() {
      return true;
    }

    public boolean isUnconditional() {
      return false;
    }

    public void check( List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space,
      Repository repository, IMetaStore metaStore ) {
      andValidator().validate( this, "KettleUtil", remarks, putValidators( notBlankValidator() ) );
    }
}
