/*
 * Decompiled with CFR 0.152.
 */
package cn.belier.qiniu.autoconfigure;

import cn.belier.qiniu.autoconfigure.QiniuProperties;
import cn.belier.qiniu.core.BucketInfoManager;
import cn.belier.qiniu.core.QiniuUpload;
import com.qiniu.cdn.CdnManager;
import com.qiniu.common.Zone;
import com.qiniu.processing.OperationManager;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@org.springframework.context.annotation.Configuration
@EnableConfigurationProperties(value={QiniuProperties.class})
public class QiniuAutoConfiguration {
    private final QiniuProperties qiniuProperties;

    @Autowired
    public QiniuAutoConfiguration(QiniuProperties qiniuProperties) {
        this.qiniuProperties = qiniuProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public Configuration configuration() {
        return new Configuration(Zone.autoZone());
    }

    @Bean
    @ConditionalOnMissingBean
    public Auth auth() {
        return Auth.create((String)this.qiniuProperties.getAccessKey(), (String)this.qiniuProperties.getSecretKey());
    }

    @Bean
    @ConditionalOnMissingBean
    public CdnManager cdnManager(Auth auth) {
        return new CdnManager(auth);
    }

    @Bean
    @ConditionalOnMissingBean
    public BucketManager bucketManager(Auth auth, Configuration configuration) {
        return new BucketManager(auth, configuration);
    }

    @Bean
    @ConditionalOnMissingBean
    public OperationManager operationManager(Auth auth, Configuration configuration) {
        return new OperationManager(auth, configuration);
    }

    @Bean
    @ConditionalOnMissingBean
    public UploadManager uploadManager(Configuration configuration) {
        return new UploadManager(configuration);
    }

    @Bean
    @ConditionalOnMissingBean
    public BucketInfoManager bucketInfoManager() {
        return new BucketInfoManager(this.qiniuProperties.getBuckets());
    }

    @Bean
    @ConditionalOnMissingBean
    public QiniuUpload qiniuUpload(Auth auth, BucketInfoManager bucketInfoManager, UploadManager uploadManager) {
        return new QiniuUpload(auth, bucketInfoManager, uploadManager);
    }
}

