/*
 * Decompiled with CFR 0.152.
 */
package cn.belier.jxls.cahce;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StreamUtils;

public class TemplateCache {
    private static final Logger log = LoggerFactory.getLogger(TemplateCache.class);
    public static final int DEFAULT_CACHE_LIMIT = 1024;
    private volatile int cacheLimit = 1024;
    private boolean cacheUnresolved = true;
    private static final byte[] EMPTY_TEMPLATE = new byte[0];
    private final Map<Object, byte[]> templateAccessCache = new ConcurrentHashMap<Object, byte[]>(1024);
    private final Map<Object, byte[]> templateCreationCache = new LinkedHashMap<Object, byte[]>(1024, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Object, byte[]> eldest) {
            if (this.size() > TemplateCache.this.getCacheLimit()) {
                TemplateCache.this.templateAccessCache.remove(eldest.getKey());
                return true;
            }
            return false;
        }
    };
    private PathMatchingResourcePatternResolver patternResolver = new PathMatchingResourcePatternResolver();

    public boolean isCache() {
        return this.cacheLimit > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getTemplate(String templatePath) {
        if (!this.isCache()) {
            return this.loadTemplate(templatePath);
        }
        byte[] template = this.templateAccessCache.get(templatePath);
        if (template == null) {
            Map<Object, byte[]> map = this.templateCreationCache;
            synchronized (map) {
                template = this.templateCreationCache.get(templatePath);
                if (template == null) {
                    template = this.loadTemplate(templatePath);
                    if (template == null && this.cacheUnresolved) {
                        template = EMPTY_TEMPLATE;
                    }
                    if (template != null) {
                        this.templateAccessCache.put(templatePath, template);
                        this.templateCreationCache.put(templatePath, template);
                        if (log.isTraceEnabled()) {
                            log.trace("\u7f13\u5b58\u6a21\u677f [" + templatePath + "]");
                        }
                    }
                }
            }
        }
        return (byte[])(template != EMPTY_TEMPLATE ? template : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] loadTemplate(String templatePath) {
        try {
            InputStream inputStream = templatePath.startsWith("classpath:") ? this.patternResolver.getResource(templatePath).getInputStream() : new FileInputStream(templatePath);
            try {
                if (inputStream == null) return null;
                byte[] byArray = StreamUtils.copyToByteArray((InputStream)inputStream);
                return byArray;
            }
            finally {
                if (Collections.singletonList(inputStream).get(0) != null) {
                    inputStream.close();
                }
            }
        }
        catch (IOException e) {
            if (!log.isWarnEnabled()) return null;
            log.warn("\u627e\u4e0d\u5230\u6a21\u677f\uff1a" + templatePath, (Throwable)e);
        }
        return null;
    }

    public int getCacheLimit() {
        return this.cacheLimit;
    }

    public void setCacheLimit(int cacheLimit) {
        this.cacheLimit = cacheLimit;
    }

    public boolean isCacheUnresolved() {
        return this.cacheUnresolved;
    }

    public void setCacheUnresolved(boolean cacheUnresolved) {
        this.cacheUnresolved = cacheUnresolved;
    }
}

