/*
 * Decompiled with CFR 0.152.
 */
package cn.belier.jxls.view;

import cn.belier.jxls.config.JxlsConfig;
import cn.belier.jxls.encoder.ContentDispositionHandler;
import cn.belier.jxls.filename.FilenameGenerate;
import cn.belier.jxls.filename.JxlsFilenameUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.jexl2.JexlEngine;
import org.jxls.common.Context;
import org.jxls.expression.JexlExpressionEvaluator;
import org.jxls.transform.Transformer;
import org.jxls.util.JxlsHelper;
import org.jxls.util.TransformerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.view.AbstractTemplateView;

public class JxlsView
extends AbstractTemplateView {
    private PathMatchingResourcePatternResolver patternResolver = new PathMatchingResourcePatternResolver();
    private ContentDispositionHandler contentDispositionHandler;
    private JxlsConfig config;
    private FilenameGenerate filenameGenerate;
    private JxlsHelper jxlsHelper;

    protected void initServletContext(ServletContext servletContext) {
        this.config = (JxlsConfig)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.obtainApplicationContext(), JxlsConfig.class, (boolean)true, (boolean)false);
        this.jxlsHelper = (JxlsHelper)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.obtainApplicationContext(), JxlsHelper.class, (boolean)true, (boolean)false);
        this.contentDispositionHandler = (ContentDispositionHandler)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.obtainApplicationContext(), ContentDispositionHandler.class, (boolean)true, (boolean)false);
        this.filenameGenerate = (FilenameGenerate)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.obtainApplicationContext(), FilenameGenerate.class, (boolean)true, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderMergedTemplateModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setStatus(HttpStatus.CREATED.value());
        Context context = new Context(model);
        String contentDisposition = this.contentDispositionHandler.getContentDisposition(request, this.getFilename(context));
        response.setHeader("Content-Disposition", contentDisposition);
        InputStream template = this.getTemplate();
        try {
            Transformer transformer = TransformerFactory.createTransformer((InputStream)template, (OutputStream)response.getOutputStream());
            JexlExpressionEvaluator expressionEvaluator = (JexlExpressionEvaluator)transformer.getTransformationConfig().getExpressionEvaluator();
            JexlEngine jexlEngine = expressionEvaluator.getJexlEngine();
            jexlEngine.setFunctions(this.config.getFunctions());
            jexlEngine.setSilent(this.config.isSilent());
            this.jxlsHelper.processTemplate(context, transformer);
        }
        finally {
            if (Collections.singletonList(template).get(0) != null) {
                template.close();
            }
        }
    }

    private String getFilename(Context context) {
        String filename = JxlsFilenameUtils.getFilename(context);
        String extension = this.getUrl().substring(this.getUrl().lastIndexOf("."));
        if (StringUtils.isEmpty((Object)filename)) {
            filename = this.filenameGenerate.generate();
        }
        return filename + extension;
    }

    private InputStream getTemplate() throws IOException {
        for (String path : this.config.getTemplateLoaderPath()) {
            InputStream inputStream;
            String templatePath = path + this.getUrl();
            InputStream inputStream2 = inputStream = templatePath.startsWith("classpath:") ? this.patternResolver.getResource(templatePath).getInputStream() : new FileInputStream(templatePath);
            if (inputStream == null) continue;
            return inputStream;
        }
        return null;
    }
}

