/*
 * Decompiled with CFR 0.152.
 */
package cn.belier.jxls.function;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class DateFunction {
    public static final String NAME = "date";
    public static final String DATE = "yyyy-MM-dd";
    public static final String TIME = "HH:mm:ss";
    public static final String DATE_TIME = "yyyy-MM-dd HH:mm:ss";
    private String date = "yyyy-MM-dd";
    private String datetime = "yyyy-MM-dd HH:mm:ss";
    private String time = "HH:mm:ss";
    private Map<String, DateTimeFormatter> dateTimeFormatterCache = new ConcurrentHashMap<String, DateTimeFormatter>();

    public static DateFunction of() {
        return new DateFunction();
    }

    public String format(LocalDateTime localDateTime, String format) {
        if (localDateTime == null || StringUtils.isBlank((CharSequence)format)) {
            return "";
        }
        return localDateTime.format(this.getDateTimeFormatter(format));
    }

    public String format(LocalDate localDate, String format) {
        if (localDate == null || StringUtils.isBlank((CharSequence)format)) {
            return "";
        }
        return localDate.format(this.getDateTimeFormatter(format));
    }

    public String format(LocalTime localTime, String format) {
        if (localTime == null || StringUtils.isBlank((CharSequence)format)) {
            return "";
        }
        return localTime.format(this.getDateTimeFormatter(format));
    }

    public String format(Date date, String format) {
        if (date == null || StringUtils.isBlank((CharSequence)format)) {
            return "";
        }
        return new SimpleDateFormat(format).format(date);
    }

    public String datetime(LocalDateTime localDateTime) {
        return this.format(localDateTime, this.datetime);
    }

    public String datetime(Date date) {
        return this.format(date, this.datetime);
    }

    public String date(LocalDateTime localDateTime) {
        return this.format(localDateTime, this.date);
    }

    public String date(LocalDate localDate) {
        return this.format(localDate, this.date);
    }

    public String date(Date date) {
        return this.format(date, this.date);
    }

    public String time(LocalTime localTime) {
        return this.format(localTime, this.time);
    }

    public String time(LocalDate localDate) {
        return this.format(localDate, this.time);
    }

    public String time(LocalDateTime localDateTime) {
        return this.format(localDateTime, this.time);
    }

    public String time(Date date) {
        return this.format(date, this.time);
    }

    private DateTimeFormatter getDateTimeFormatter(String format) {
        return this.dateTimeFormatterCache.computeIfAbsent(format, key -> DateTimeFormatter.ofPattern(format));
    }

    public String getDate() {
        return this.date;
    }

    public String getDatetime() {
        return this.datetime;
    }

    public String getTime() {
        return this.time;
    }

    public Map<String, DateTimeFormatter> getDateTimeFormatterCache() {
        return this.dateTimeFormatterCache;
    }

    public DateFunction setDate(String date) {
        this.date = date;
        return this;
    }

    public DateFunction setDatetime(String datetime) {
        this.datetime = datetime;
        return this;
    }

    public DateFunction setTime(String time) {
        this.time = time;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DateFunction)) {
            return false;
        }
        DateFunction other = (DateFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$date = this.getDate();
        String other$date = other.getDate();
        if (this$date == null ? other$date != null : !this$date.equals(other$date)) {
            return false;
        }
        String this$datetime = this.getDatetime();
        String other$datetime = other.getDatetime();
        if (this$datetime == null ? other$datetime != null : !this$datetime.equals(other$datetime)) {
            return false;
        }
        String this$time = this.getTime();
        String other$time = other.getTime();
        if (this$time == null ? other$time != null : !this$time.equals(other$time)) {
            return false;
        }
        Map<String, DateTimeFormatter> this$dateTimeFormatterCache = this.getDateTimeFormatterCache();
        Map<String, DateTimeFormatter> other$dateTimeFormatterCache = other.getDateTimeFormatterCache();
        return !(this$dateTimeFormatterCache == null ? other$dateTimeFormatterCache != null : !((Object)this$dateTimeFormatterCache).equals(other$dateTimeFormatterCache));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DateFunction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : $date.hashCode());
        String $datetime = this.getDatetime();
        result = result * 59 + ($datetime == null ? 43 : $datetime.hashCode());
        String $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : $time.hashCode());
        Map<String, DateTimeFormatter> $dateTimeFormatterCache = this.getDateTimeFormatterCache();
        result = result * 59 + ($dateTimeFormatterCache == null ? 43 : ((Object)$dateTimeFormatterCache).hashCode());
        return result;
    }

    public String toString() {
        return "DateFunction(date=" + this.getDate() + ", datetime=" + this.getDatetime() + ", time=" + this.getTime() + ", dateTimeFormatterCache=" + this.getDateTimeFormatterCache() + ")";
    }
}

