/*
 * Decompiled with CFR 0.152.
 */
package cn.belier.jxls.config;

import cn.belier.jxls.function.JxlsFunction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;

public class JxlsConfig {
    private String[] templateLoaderPath;
    private boolean silent = false;
    private boolean cache = false;
    private Map<String, Object> functions = new HashMap<String, Object>();

    public JxlsConfig addFunction(String name, Object fun) {
        this.functions.put(name, fun);
        return this;
    }

    public JxlsConfig addFunction(JxlsFunction jxlsFunction) {
        this.functions.put(jxlsFunction.getName(), jxlsFunction.getFun());
        return this;
    }

    public JxlsConfig addFunctions(Map<String, Object> functions) {
        this.functions.putAll(functions);
        return this;
    }

    public JxlsConfig addFunctions(List<JxlsFunction> jxlsFunctions) {
        if (CollectionUtils.isNotEmpty(jxlsFunctions)) {
            jxlsFunctions.forEach(this::addFunction);
        }
        return this;
    }

    public String[] getTemplateLoaderPath() {
        return this.templateLoaderPath;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public boolean isCache() {
        return this.cache;
    }

    public Map<String, Object> getFunctions() {
        return this.functions;
    }

    public JxlsConfig setTemplateLoaderPath(String[] templateLoaderPath) {
        this.templateLoaderPath = templateLoaderPath;
        return this;
    }

    public JxlsConfig setSilent(boolean silent) {
        this.silent = silent;
        return this;
    }

    public JxlsConfig setCache(boolean cache) {
        this.cache = cache;
        return this;
    }
}

