/*
 * Decompiled with CFR 0.152.
 */
package cn.belier.jxls.autoconfigure;

import org.springframework.boot.autoconfigure.template.AbstractTemplateViewResolverProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.MimeType;

@ConfigurationProperties(value="spring.jxls")
public class JxlsProperties
extends AbstractTemplateViewResolverProperties {
    protected static final String DEFAULT_SUFFIX = ".xlsx";
    private static final String DEFAULT_TEMPLATE_LOADER_PATH = "classpath:/templates/";
    private static final String DEFAULT_PREFIX = "";
    private String[] templateLoaderPath = new String[]{"classpath:/templates/"};
    private boolean useFastFormulaProcessor = false;
    private boolean processFormulas = true;
    private boolean hideTemplateSheet = false;
    private boolean deleteTemplateSheet = true;
    private FunctionConfig function = new FunctionConfig();
    private boolean silent = true;

    public JxlsProperties() {
        super(DEFAULT_PREFIX, DEFAULT_SUFFIX);
        this.setContentType(MimeType.valueOf((String)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"));
    }

    public String[] getTemplateLoaderPath() {
        return this.templateLoaderPath;
    }

    public boolean isUseFastFormulaProcessor() {
        return this.useFastFormulaProcessor;
    }

    public boolean isProcessFormulas() {
        return this.processFormulas;
    }

    public boolean isHideTemplateSheet() {
        return this.hideTemplateSheet;
    }

    public boolean isDeleteTemplateSheet() {
        return this.deleteTemplateSheet;
    }

    public FunctionConfig getFunction() {
        return this.function;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setTemplateLoaderPath(String[] templateLoaderPath) {
        this.templateLoaderPath = templateLoaderPath;
    }

    public void setUseFastFormulaProcessor(boolean useFastFormulaProcessor) {
        this.useFastFormulaProcessor = useFastFormulaProcessor;
    }

    public void setProcessFormulas(boolean processFormulas) {
        this.processFormulas = processFormulas;
    }

    public void setHideTemplateSheet(boolean hideTemplateSheet) {
        this.hideTemplateSheet = hideTemplateSheet;
    }

    public void setDeleteTemplateSheet(boolean deleteTemplateSheet) {
        this.deleteTemplateSheet = deleteTemplateSheet;
    }

    public void setFunction(FunctionConfig function) {
        this.function = function;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public static class DateFunctionConfig {
        private boolean enabled = true;
        private String name = "date";
        private String date = "yyyy-MM-dd";
        private String datetime = "yyyy-MM-dd HH:mm:ss";
        private String time = "HH:mm:ss";

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getName() {
            return this.name;
        }

        public String getDate() {
            return this.date;
        }

        public String getDatetime() {
            return this.datetime;
        }

        public String getTime() {
            return this.time;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public void setDatetime(String datetime) {
            this.datetime = datetime;
        }

        public void setTime(String time) {
            this.time = time;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DateFunctionConfig)) {
                return false;
            }
            DateFunctionConfig other = (DateFunctionConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$date = this.getDate();
            String other$date = other.getDate();
            if (this$date == null ? other$date != null : !this$date.equals(other$date)) {
                return false;
            }
            String this$datetime = this.getDatetime();
            String other$datetime = other.getDatetime();
            if (this$datetime == null ? other$datetime != null : !this$datetime.equals(other$datetime)) {
                return false;
            }
            String this$time = this.getTime();
            String other$time = other.getTime();
            return !(this$time == null ? other$time != null : !this$time.equals(other$time));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DateFunctionConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $date = this.getDate();
            result = result * 59 + ($date == null ? 43 : $date.hashCode());
            String $datetime = this.getDatetime();
            result = result * 59 + ($datetime == null ? 43 : $datetime.hashCode());
            String $time = this.getTime();
            result = result * 59 + ($time == null ? 43 : $time.hashCode());
            return result;
        }

        public String toString() {
            return "JxlsProperties.DateFunctionConfig(enabled=" + this.isEnabled() + ", name=" + this.getName() + ", date=" + this.getDate() + ", datetime=" + this.getDatetime() + ", time=" + this.getTime() + ")";
        }
    }

    public static class FunctionConfig {
        private DateFunctionConfig date = new DateFunctionConfig();

        public DateFunctionConfig getDate() {
            return this.date;
        }

        public void setDate(DateFunctionConfig date) {
            this.date = date;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FunctionConfig)) {
                return false;
            }
            FunctionConfig other = (FunctionConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            DateFunctionConfig this$date = this.getDate();
            DateFunctionConfig other$date = other.getDate();
            return !(this$date == null ? other$date != null : !((Object)this$date).equals(other$date));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FunctionConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DateFunctionConfig $date = this.getDate();
            result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
            return result;
        }

        public String toString() {
            return "JxlsProperties.FunctionConfig(date=" + this.getDate() + ")";
        }
    }
}

