/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.wechat.work;

import bee.cloud.service.wechat.proxy.Client;
import bee.cloud.service.wechat.proxy.Clients;
import bee.tool.string.Bson;
import bee.tool.string.Format;
import java.util.Map;

public class ScanWork {
    private static final String DATA_TEMP = "{\"expire_seconds\":%d,\"action_name\": \"QR_STR_SCENE\",\"action_info\":{\"scene\":{\"scene_str\":\"%s\"}}}";

    public static Map<String, String> createScan(Client client, String sceneStr, int expireSeconds) {
        String out = client.excute(Clients.getWeapi("qrcode/create"), String.format(DATA_TEMP, expireSeconds, sceneStr));
        Bson bson = Bson.init((String)out);
        return bson.toMap();
    }

    public static String createScanToTicket(Client client, String sceneStr, int expireSeconds) {
        Map<String, String> map = ScanWork.createScan(client, sceneStr, expireSeconds);
        if (map != null) {
            return map.get("ticket");
        }
        return null;
    }

    public static String createScanToImageUrl(Client client, String sceneStr, int expireSeconds) {
        String ticket = ScanWork.createScanToTicket(client, sceneStr, expireSeconds);
        if (Format.isEmpty((String)ticket)) {
            return null;
        }
        return "https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=" + ticket;
    }
}

