/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.wechat.work;

import bee.cloud.service.wechat.proxy.message.receive.Receive;
import bee.cloud.service.wechat.proxy.message.receive.ReceiveEvent;
import bee.cloud.service.wechat.proxy.message.receive.event.Location;
import bee.cloud.service.wechat.proxy.message.receive.event.MenuClick;
import bee.cloud.service.wechat.proxy.message.receive.event.MenuView;
import bee.cloud.service.wechat.proxy.message.receive.event.Scan;
import bee.cloud.service.wechat.proxy.message.receive.event.Subscribe;
import bee.cloud.service.wechat.proxy.message.receive.event.UnSubscribe;
import bee.cloud.service.wechat.proxy.message.reply.Reply;
import bee.cloud.service.wechat.proxy.message.send.SImage;
import bee.cloud.service.wechat.proxy.message.send.SMessage;
import bee.cloud.service.wechat.proxy.message.send.SMpnews;
import bee.cloud.service.wechat.proxy.message.send.SMsgmenu;
import bee.cloud.service.wechat.proxy.message.send.SMusic;
import bee.cloud.service.wechat.proxy.message.send.SNews;
import bee.cloud.service.wechat.proxy.message.send.SText;
import bee.cloud.service.wechat.proxy.message.send.SVideo;
import bee.cloud.service.wechat.proxy.message.send.SVoice;
import bee.tool.string.Bson;
import bee.tool.string.Format;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MsgWork {
    @Autowired
    private ReceiveEvent event;

    public Reply parse(Receive receive) {
        if (receive instanceof Subscribe) {
            return this.event.subscribe((Subscribe)receive);
        }
        if (receive instanceof UnSubscribe) {
            return this.event.unSubscribe((UnSubscribe)receive);
        }
        if (receive instanceof MenuClick) {
            return this.event.menuClick((MenuClick)receive);
        }
        if (receive instanceof MenuView) {
            return this.event.menuView((MenuView)receive);
        }
        if (receive instanceof Scan) {
            return this.event.scan((Scan)receive);
        }
        if (receive instanceof Location) {
            return this.event.location((Location)receive);
        }
        return this.event.receive(receive);
    }

    public SMessage parse(SBean sbean) {
        if ("image".equals(sbean.getMsgtype())) {
            SImage simage = new SImage();
            simage.setMediaId(sbean.bson.toText("media_id"));
            return simage;
        }
        if ("mpnews".equals(sbean.getMsgtype())) {
            SMpnews smpnews = new SMpnews();
            smpnews.setMediaId(sbean.bson.toText("media_id"));
            return smpnews;
        }
        if ("msgmenu".equals(sbean.getMsgtype())) {
            SMsgmenu smsgmenu = new SMsgmenu();
            smsgmenu.setHeadContent(sbean.bson.toText("head_content"));
            smsgmenu.setTailContent(sbean.bson.toText("tail_content"));
            return smsgmenu;
        }
        if ("music".equals(sbean.getMsgtype())) {
            SMusic smusic = new SMusic();
            smusic.setDescription(sbean.bson.toText("description"));
            smusic.setHqmusicurl(sbean.bson.toText("hqmusicurl"));
            smusic.setMusicurl(sbean.bson.toText("musicurl"));
            smusic.setThumbMmediaId(sbean.bson.toText("thumb_media_id"));
            smusic.setTitle(sbean.bson.toText("title"));
            return smusic;
        }
        if ("news".equals(sbean.getMsgtype())) {
            SNews snews = new SNews();
            snews.setDescription(sbean.bson.toText("description"));
            snews.setPicurl(sbean.bson.toText("picurl"));
            snews.setTitle(sbean.bson.toText("title"));
            snews.setUrl(sbean.bson.toText("url"));
            return snews;
        }
        if ("video".equals(sbean.getMsgtype())) {
            SVideo svideo = new SVideo();
            svideo.setDescription(sbean.bson.toText("description"));
            svideo.setTitle(sbean.bson.toText("title"));
            svideo.setMediaId(sbean.bson.toText("media_id"));
            svideo.setThumbMmediaId(sbean.bson.toText("thumb_media_id"));
            return svideo;
        }
        if ("voice".equals(sbean.getMsgtype())) {
            SVoice svoice = new SVoice();
            svoice.setMediaId(sbean.bson.toText("media_id"));
            return svoice;
        }
        SText stext = new SText();
        stext.setContent(sbean.bson.toText("content"));
        return stext;
    }

    public static class SBean {
        private String msgtype;
        private String[] tousers;
        private Bson bson;

        public SBean(String data) {
            this.bson = Bson.init((String)data);
            this.msgtype = this.bson.toText("msgtype");
            if (Format.isEmpty((String)this.msgtype)) {
                this.msgtype = "text";
            }
            this.tousers = this.bson.toArray("openid");
        }

        public String getMsgtype() {
            return this.msgtype;
        }

        public String[] getTousers() {
            return this.tousers;
        }
    }
}

