/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.wechat.service;

import bee.cloud.service.wechat.bean.MessageTemplate;
import bee.cloud.service.wechat.bean.Openids;
import bee.cloud.service.wechat.proxy.message.receive.Receive;
import bee.cloud.service.wechat.proxy.message.receive.ReceiveEvent;
import bee.cloud.service.wechat.proxy.message.receive.event.Location;
import bee.cloud.service.wechat.proxy.message.receive.event.MenuClick;
import bee.cloud.service.wechat.proxy.message.receive.event.MenuView;
import bee.cloud.service.wechat.proxy.message.receive.event.Scan;
import bee.cloud.service.wechat.proxy.message.receive.event.Subscribe;
import bee.cloud.service.wechat.proxy.message.receive.event.UnSubscribe;
import bee.cloud.service.wechat.proxy.message.receive.general.GText;
import bee.cloud.service.wechat.proxy.message.reply.RText;
import bee.cloud.service.wechat.proxy.message.reply.Reply;
import bee.cloud.service.wechat.service.ReplyMsg;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReceiveEventService
implements ReceiveEvent {
    @Autowired(required=false)
    private ReplyMsg msg;

    @Override
    public Reply menuClick(MenuClick event) {
        Reply r = null;
        if (this.msg != null && (r = this.msg.event(event)) != null) {
            r.setOpenid(event.getOpenid());
            r.setOriginalid(event.getOriginalid());
        }
        return r;
    }

    @Override
    public Reply menuView(MenuView event) {
        Reply r = null;
        if (this.msg != null && (r = this.msg.event(event)) != null) {
            r.setOpenid(event.getOpenid());
            r.setOriginalid(event.getOriginalid());
        }
        return r;
    }

    @Override
    public Reply location(Location event) {
        Reply r = null;
        if (this.msg != null && (r = this.msg.event(event)) != null) {
            r.setOpenid(event.getOpenid());
            r.setOriginalid(event.getOriginalid());
        }
        return r;
    }

    @Override
    public Reply scan(Scan event) {
        Reply r = null;
        if (this.msg != null && (r = this.msg.event(event)) != null) {
            r.setOpenid(event.getOpenid());
            r.setOriginalid(event.getOriginalid());
        }
        return r;
    }

    @Override
    public Reply subscribe(Subscribe event) {
        Reply r = null;
        if (this.msg != null && (r = this.msg.event(event)) != null) {
            r.setOpenid(event.getOpenid());
            r.setOriginalid(event.getOriginalid());
        }
        if (r == null) {
            RText rtext = new RText();
            rtext.setOpenid(event.getOpenid());
            rtext.setOriginalid(event.getOriginalid());
            rtext.setContent(event.getClient().getServiceno().getWelcome());
            r = rtext;
        }
        try {
            Openids openids = new Openids();
            openids.setOriginalid(event.getOriginalid());
            openids.setOpenid(event.getOpenid());
            openids.setSubscribeTime(new Date(System.currentTimeMillis()));
            openids.insert();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return r;
    }

    @Override
    public Reply unSubscribe(UnSubscribe event) {
        Reply r = null;
        if (this.msg != null && (r = this.msg.event(event)) != null) {
            r.setOpenid(event.getOpenid());
            r.setOriginalid(event.getOriginalid());
        }
        try {
            Openids openids = new Openids();
            openids.setOriginalid(event.getOriginalid());
            openids.setOpenid(event.getOpenid());
            openids.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return r;
    }

    @Override
    public Reply receive(Receive receive) {
        Reply r = null;
        if (this.msg != null) {
            r = this.msg.reply(receive);
        }
        if (r != null) {
            r.setOpenid(receive.getOpenid());
            r.setOriginalid(receive.getOriginalid());
            return r;
        }
        if (receive instanceof GText) {
            MessageTemplate mt = new MessageTemplate();
            mt.setOriginalid(receive.getOriginalid());
            mt.setKeyword(((GText)receive).getContent());
            if (mt.load(new String[0])) {
                RText rtext = new RText();
                rtext.setOpenid(receive.getOpenid());
                rtext.setOriginalid(receive.getOriginalid());
                rtext.setContent(mt.getContent());
                return rtext;
            }
        }
        RText rtext = new RText();
        rtext.setOpenid(receive.getOpenid());
        rtext.setOriginalid(receive.getOriginalid());
        rtext.setContent("\u6536\u5230\u6d88\u606f\uff1a" + ((GText)receive).getContent());
        return rtext;
    }
}

