/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.wechat.proxy.work.entity;

import bee.cloud.engine.db.core.CBase;
import bee.cloud.service.wechat.proxy.WCache;
import bee.tool.string.Format;
import java.util.HashMap;
import java.util.Map;

public class ReplyMsg {
    private static String REPLY_MSG_CACHE_KEY = "reply_msg:originalid:keyword";
    private long replyMsgId;
    private String originalid;
    private String keyword;
    private String msgType;
    private String content;
    private int valid;

    public void copy(CBase tb) {
        if (tb == null) {
            return;
        }
        this.setReplyMsgId(tb.getValueByLong("reply_msg_id"));
        this.setOriginalid(tb.getValueByString("originalid"));
        this.setKeyword(tb.getValueByString("keyword"));
        this.setMsgType(tb.getValueByString("msg_type"));
        this.setContent(tb.getValueByString("content"));
        this.setValid(tb.getValueByInt("valid"));
    }

    public void copy(Map<String, String> map) {
        if (map == null) {
            return;
        }
        this.replyMsgId = Format.objToLong((Object)map.get("reply_msg_id"));
        this.originalid = map.get("originalid");
        this.keyword = map.get("keyword");
        this.msgType = map.get("msg_type");
        this.content = map.get("content");
        this.valid = Format.strToInt((String)map.get("valid"));
    }

    public void copy(ReplyMsg rmsg) {
        if (rmsg == null) {
            return;
        }
        this.replyMsgId = rmsg.getReplyMsgId();
        this.originalid = rmsg.getOriginalid();
        this.keyword = rmsg.getKeyword();
        this.msgType = rmsg.getMsgType();
        this.content = rmsg.getContent();
        this.valid = rmsg.getValid();
    }

    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("reply_msg_id", "" + this.getReplyMsgId());
        map.put("originalid", this.getOriginalid());
        map.put("keyword", this.getKeyword());
        map.put("msg_type", this.getMsgType());
        map.put("content", this.getContent());
        map.put("valid", "" + this.getValid());
        return map;
    }

    public void cache() {
        String ckey = this.getCacheKey();
        WCache.cache.hset(ckey, this.toMap());
        WCache.cache.expire(ckey, 2592000L);
    }

    public static ReplyMsg cache(String originalid, String keyword) {
        String ckey = ReplyMsg.getCacheKey(originalid, keyword);
        Map map = WCache.cache.hgetAll(ckey);
        if (map == null) {
            return null;
        }
        WCache.cache.expire(ckey, 2592000L);
        ReplyMsg rmsg = new ReplyMsg();
        rmsg.copy(map);
        return rmsg;
    }

    public String getCacheKey() {
        return REPLY_MSG_CACHE_KEY.replace("originalid", this.getOriginalid()).replace("keyword", this.getKeyword());
    }

    public static String getCacheKey(String originalid, String keyword) {
        return REPLY_MSG_CACHE_KEY.replace("originalid", originalid).replace("keyword", keyword);
    }

    public long getReplyMsgId() {
        return this.replyMsgId;
    }

    public void setReplyMsgId(long replyMsgId) {
        this.replyMsgId = replyMsgId;
    }

    public String getOriginalid() {
        return this.originalid;
    }

    public void setOriginalid(String originalid) {
        this.originalid = originalid;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public int getValid() {
        return this.valid;
    }

    public void setValid(int valid) {
        this.valid = valid;
    }

    public String toString() {
        return "ReplyMsg";
    }
}

