/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.wechat.proxy.util;

import bee.cloud.core.Required;
import bee.cloud.engine.db.annotation.DateFormat;
import bee.cloud.engine.db.annotation.Ignore;
import bee.tool.Tool;
import bee.tool.string.Format;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public abstract class BeanToMap {
    public Map<String, String> toMap() {
        return this.toMap(true);
    }

    public Map<String, String> toMap(boolean isKeyToUnderlineName) {
        TreeMap<String, String> map = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        map.putAll(this.fieldToValues(isKeyToUnderlineName));
        return map;
    }

    private Map<String, String> fieldToValues(boolean isKeyToUnderlineName) {
        HashMap<String, String> values = new HashMap<String, String>();
        Map fields = Tool.getDeclaredFields(this.getClass());
        fields.forEach((k, field) -> {
            if (field.isAnnotationPresent(Ignore.class)) {
                return;
            }
            Object value = Tool.getDeclaredField((Object)this, (Field)field);
            if (field.isAnnotationPresent(Required.class)) {
                Objects.requireNonNull(value, "\u5c5e\u6027\u3010" + field.getName() + "\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (Format.isEmpty((Object)value)) {
                return;
            }
            if (value instanceof Date && field.isAnnotationPresent(DateFormat.class)) {
                value = Tool.Dater.instence((Date)((Date)value)).format(field.getAnnotation(DateFormat.class).value());
            }
            String name = isKeyToUnderlineName ? Tool.toUnderlineName((String)k) : k;
            values.put(name, value.toString().trim());
        });
        return values;
    }
}

