/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.wechat.proxy.pay.param;

import bee.cloud.core.Bee;
import bee.cloud.core.Required;
import bee.cloud.core.db.RequestParam;
import bee.cloud.engine.db.annotation.Ignore;
import bee.cloud.service.wechat.controller.WechatPay;
import bee.cloud.service.wechat.proxy.pay.PayData;
import bee.cloud.service.wechat.proxy.pay.PayService;
import bee.cloud.service.wechat.proxy.pay.param.OrderInfo;
import bee.cloud.service.wechat.proxy.util.BeanToMap;
import bee.tool.Tool;
import com.github.wxpay.sdk.WXPayUtil;
import org.springframework.web.bind.annotation.RequestMapping;

public class UnifiedOrder
extends BeanToMap {
    @Required
    private String appid;
    @Required
    private String mchId;
    @Required
    private String openid;
    @Required
    private String nonceStr = WXPayUtil.generateNonceStr();
    @Required
    private String signType = "MD5";
    private String spbillCreateIp = Tool.getLocalIP().split(",")[0];
    @Required
    private String notifyUrl;
    private String tradeType = "JSAPI";
    @Ignore
    private OrderInfo orderInfo;

    public UnifiedOrder(String openid, OrderInfo orderInfo) {
        this.openid = openid;
        this.orderInfo = orderInfo;
        RequestParam param = Bee.getRequestParam();
        if (param != null) {
            this.notifyUrl = "https://" + param.header.get("x-forwarded-host") + param.header.get("x-forwarded-prefix") + WechatPay.class.getAnnotation(RequestMapping.class).value()[0] + "/notice/{paytype}/{out_trade_no}".replace("{paytype}", PayService.PayType.unifiedorder.name()).replace("{out_trade_no}", orderInfo.getOutTradeNo());
        }
    }

    public PayData toPayData() {
        PayData data = new PayData();
        data.putAll(super.toMap());
        data.putAll(this.orderInfo.toMap());
        return data;
    }

    public String getNonceStr() {
        return this.nonceStr;
    }

    public String getAppid() {
        return this.appid;
    }

    public String getMchId() {
        return this.mchId;
    }

    public String getOpenid() {
        return this.openid;
    }

    public String getSignType() {
        return this.signType;
    }

    public String getSpbillCreateIp() {
        return this.spbillCreateIp;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public String getTradeType() {
        return this.tradeType;
    }

    public OrderInfo getOrderInfo() {
        return this.orderInfo;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public void setOpenid(String openid) {
        this.openid = openid;
    }

    public void setNonceStr(String nonceStr) {
        this.nonceStr = nonceStr;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }

    public void setSpbillCreateIp(String spbillCreateIp) {
        this.spbillCreateIp = spbillCreateIp;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public void setTradeType(String tradeType) {
        this.tradeType = tradeType;
    }

    public void setOrderInfo(OrderInfo orderInfo) {
        this.orderInfo = orderInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnifiedOrder)) {
            return false;
        }
        UnifiedOrder other = (UnifiedOrder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$appid = this.getAppid();
        String other$appid = other.getAppid();
        if (this$appid == null ? other$appid != null : !this$appid.equals(other$appid)) {
            return false;
        }
        String this$mchId = this.getMchId();
        String other$mchId = other.getMchId();
        if (this$mchId == null ? other$mchId != null : !this$mchId.equals(other$mchId)) {
            return false;
        }
        String this$openid = this.getOpenid();
        String other$openid = other.getOpenid();
        if (this$openid == null ? other$openid != null : !this$openid.equals(other$openid)) {
            return false;
        }
        String this$nonceStr = this.getNonceStr();
        String other$nonceStr = other.getNonceStr();
        if (this$nonceStr == null ? other$nonceStr != null : !this$nonceStr.equals(other$nonceStr)) {
            return false;
        }
        String this$signType = this.getSignType();
        String other$signType = other.getSignType();
        if (this$signType == null ? other$signType != null : !this$signType.equals(other$signType)) {
            return false;
        }
        String this$spbillCreateIp = this.getSpbillCreateIp();
        String other$spbillCreateIp = other.getSpbillCreateIp();
        if (this$spbillCreateIp == null ? other$spbillCreateIp != null : !this$spbillCreateIp.equals(other$spbillCreateIp)) {
            return false;
        }
        String this$notifyUrl = this.getNotifyUrl();
        String other$notifyUrl = other.getNotifyUrl();
        if (this$notifyUrl == null ? other$notifyUrl != null : !this$notifyUrl.equals(other$notifyUrl)) {
            return false;
        }
        String this$tradeType = this.getTradeType();
        String other$tradeType = other.getTradeType();
        if (this$tradeType == null ? other$tradeType != null : !this$tradeType.equals(other$tradeType)) {
            return false;
        }
        OrderInfo this$orderInfo = this.getOrderInfo();
        OrderInfo other$orderInfo = other.getOrderInfo();
        return !(this$orderInfo == null ? other$orderInfo != null : !((Object)this$orderInfo).equals(other$orderInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UnifiedOrder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $appid = this.getAppid();
        result = result * 59 + ($appid == null ? 43 : $appid.hashCode());
        String $mchId = this.getMchId();
        result = result * 59 + ($mchId == null ? 43 : $mchId.hashCode());
        String $openid = this.getOpenid();
        result = result * 59 + ($openid == null ? 43 : $openid.hashCode());
        String $nonceStr = this.getNonceStr();
        result = result * 59 + ($nonceStr == null ? 43 : $nonceStr.hashCode());
        String $signType = this.getSignType();
        result = result * 59 + ($signType == null ? 43 : $signType.hashCode());
        String $spbillCreateIp = this.getSpbillCreateIp();
        result = result * 59 + ($spbillCreateIp == null ? 43 : $spbillCreateIp.hashCode());
        String $notifyUrl = this.getNotifyUrl();
        result = result * 59 + ($notifyUrl == null ? 43 : $notifyUrl.hashCode());
        String $tradeType = this.getTradeType();
        result = result * 59 + ($tradeType == null ? 43 : $tradeType.hashCode());
        OrderInfo $orderInfo = this.getOrderInfo();
        result = result * 59 + ($orderInfo == null ? 43 : ((Object)$orderInfo).hashCode());
        return result;
    }

    public String toString() {
        return "UnifiedOrder(appid=" + this.getAppid() + ", mchId=" + this.getMchId() + ", openid=" + this.getOpenid() + ", nonceStr=" + this.getNonceStr() + ", signType=" + this.getSignType() + ", spbillCreateIp=" + this.getSpbillCreateIp() + ", notifyUrl=" + this.getNotifyUrl() + ", tradeType=" + this.getTradeType() + ", orderInfo=" + this.getOrderInfo() + ")";
    }
}

