/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.wechat.proxy.pay.param;

import bee.cloud.service.wechat.proxy.Client;
import bee.cloud.service.wechat.proxy.Clients;
import bee.cloud.service.wechat.proxy.pay.PayData;
import bee.tool.Tool;
import bee.tool.err.BeeException;

public abstract class PayParam
extends PayData {
    private static final long serialVersionUID = -8758778431805236527L;

    public PayParam() {
        super.put("nonce_str", Tool.getUUID());
    }

    public <T extends PayParam> T setAppid(String appid) {
        super.put("appid", appid);
        Client client = Clients.getClient(appid);
        if (client == null) {
            throw new BeeException("APPID[%s]\u4e0d\u5b58\u5728\u3002", new Object[]{appid});
        }
        super.put("mch_id", client.getServiceno().getMchId());
        return (T)this;
    }

    public String getAppid() {
        return (String)this.get("appid");
    }

    public String getMchId() {
        return (String)this.get("mch_id");
    }

    public <T extends PayParam> T setOutTradeNo(String out_trade_no) {
        super.put("out_trade_no", out_trade_no);
        return (T)this;
    }

    public String getOutTradeNo() {
        return (String)this.get("out_trade_no");
    }
}

