/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.wechat.proxy.pay;

import bee.cloud.core.db.Holder;
import bee.cloud.core.db.RequestParam;
import bee.cloud.service.wechat.proxy.Clients;
import bee.cloud.service.wechat.proxy.pay.Notice;
import bee.cloud.service.wechat.proxy.pay.PayData;
import bee.cloud.service.wechat.proxy.pay.PayResult;
import bee.cloud.service.wechat.proxy.pay.PayService;
import bee.cloud.service.wechat.proxy.pay.WechatConfig;
import bee.cloud.service.wechat.proxy.pay.param.OrderInfo;
import bee.cloud.service.wechat.proxy.pay.param.RefundParam;
import bee.cloud.service.wechat.proxy.pay.param.UnifiedOrder;
import bee.tool.Tool;
import bee.tool.err.BeeException;
import com.github.wxpay.sdk.WXPay;
import com.github.wxpay.sdk.WXPayConfig;
import java.util.Map;

public class WePay {
    protected String appid;
    protected WXPayConfig config;
    protected WXPay wxpay;
    protected PayService service;
    public static final String SUCCESS = "SUCCESS";

    public WePay(String appid) {
        this.appid = appid;
        this.config = new WechatConfig(Clients.getClient(appid).getServiceno());
        this.wxpay = new WXPay(this.config);
        this.service = (PayService)Holder.self().getBean(PayService.class, new Object[0]);
    }

    public PayData unifiedOrder(String openid, OrderInfo orderInfo) {
        UnifiedOrder unifiedOrder = new UnifiedOrder(openid, orderInfo);
        unifiedOrder.setAppid(this.config.getAppID());
        unifiedOrder.setMchId(this.config.getMchID());
        PayData data = unifiedOrder.toPayData();
        data.put("sign", data.getSign(this.config.getKey()));
        try {
            Map result = this.wxpay.unifiedOrder((Map)data);
            if (SUCCESS.equals(result.get("return_code"))) {
                PayResult payResult = new PayResult(this.config, unifiedOrder.getOrderInfo(), openid);
                payResult.isSuccess = true;
                payResult.msg = Tool.Value.toSingle((String[])new String[]{(String)result.get("return_msg"), (String)result.get("err_code_des")});
                payResult.errCode = (String)result.get("err_code");
                payResult.prepayId = (String)result.get("prepay_id");
                this.service.prepaidDone(payResult);
            }
            PayData map = new PayData();
            map.put("appId", (String)result.get("appid"));
            map.put("package", "prepay_id=" + (String)result.get("prepay_id"));
            map.put("nonceStr", (String)result.get("nonce_str"));
            map.put("timeStamp", String.valueOf(System.currentTimeMillis() / 1000L));
            map.put("signType", "MD5");
            map.put("paySign", map.getSign(this.config.getKey()));
            map.putAll(result);
            if (unifiedOrder.getOrderInfo().getAttach() != null) {
                map.put("extdata", Tool.Json.objToJsonString(unifiedOrder.getOrderInfo().getAttach()));
            }
            return map;
        }
        catch (Exception e) {
            Tool.Log.error((String)("\u652f\u4ed8\u5931\u8d25\uff1a" + e));
            throw new BeeException((Throwable)e, "\u652f\u4ed8\u5931\u8d25\uff01");
        }
    }

    public Map<String, String> queryOrder(String outTradeNo) {
        PayData data = new PayData();
        data.put("appid", this.appid);
        data.put("mch_id", this.config.getMchID());
        data.put("out_trade_no", outTradeNo);
        data.put("nonce_str", Tool.getUUID());
        data.put("sign_type", "MD5");
        data.put("sign", data.getSign(this.config.getKey()));
        try {
            Map orderQuery = this.wxpay.orderQuery((Map)data);
            return orderQuery;
        }
        catch (Exception e) {
            Tool.Log.error((Throwable)e);
            throw new BeeException("\u8ba2\u5355\u67e5\u8be2\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a%s", new Object[]{e.getMessage()});
        }
    }

    public Map<String, String> closeOrder(String outTradeNo) {
        PayData data = new PayData();
        data.put("appid", this.appid);
        data.put("mch_id", this.config.getMchID());
        data.put("out_trade_no", outTradeNo);
        data.put("nonce_str", Tool.getUUID());
        data.put("sign_type", "MD5");
        data.put("sign", data.getSign(this.config.getKey()));
        try {
            Map result = this.wxpay.closeOrder((Map)data);
            if (SUCCESS.equals(result.get("return_code"))) {
                this.service.closeOrder(outTradeNo, result);
            }
            return result;
        }
        catch (Exception e) {
            Tool.Log.error((Throwable)e);
            throw new BeeException("\u8ba2\u5355\u5173\u95ed\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a%s", new Object[]{e.getMessage()});
        }
    }

    public Map<String, String> refund(String outTradeNo) {
        RefundParam refundParam = this.service.getRefundParam(outTradeNo);
        refundParam.setOutTradeNo(outTradeNo);
        if (Tool.Format.isEmptys((String[])new String[]{refundParam.getAppid(), refundParam.getMchId()})) {
            Tool.Log.error((String)"APPID\u4e0emch_id\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            throw new BeeException("\u53c2\u6570\u4e0d\u5168\u3002");
        }
        this.appid = refundParam.getAppid();
        this.config = new WechatConfig(Clients.getClient(this.appid).getServiceno());
        this.wxpay = new WXPay(this.config);
        refundParam.put("sign", refundParam.getSign(this.config.getKey()));
        try {
            Map refund = this.wxpay.refund((Map)refundParam);
            if (SUCCESS.equals(refund.get("return_code"))) {
                this.service.refundDone(outTradeNo, refund);
            }
            return refund;
        }
        catch (Exception e) {
            Tool.Log.error((Throwable)e);
            throw new BeeException("\u7533\u8bf7\u9000\u6b3e\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a%s", new Object[]{e.getMessage()});
        }
    }

    public Map<String, String> queryRefund(String outTradeNo) {
        PayData data = new PayData();
        data.put("appid", this.appid);
        data.put("mch_id", this.config.getMchID());
        data.put("out_trade_no", outTradeNo);
        data.put("nonce_str", Tool.getUUID());
        data.put("sign_type", "MD5");
        data.put("sign", data.getSign(this.config.getKey()));
        try {
            Map orderQuery = this.wxpay.refundQuery((Map)data);
            return orderQuery;
        }
        catch (Exception e) {
            Tool.Log.error((Throwable)e);
            throw new BeeException("\u9000\u6b3e\u8ba2\u5355\u67e5\u8be2\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a%s", new Object[]{e.getMessage()});
        }
    }

    public Notice successNotice(RequestParam param) {
        try {
            Map notifyMap = param.toMap();
            if (this.wxpay.isPayResultNotifySignatureValid(notifyMap) && SUCCESS.equals(notifyMap.get("return_code"))) {
                Tool.Log.info((String)"\u5fae\u4fe1\u624b\u673a\u652f\u4ed8\u56de\u8c03\u6210\u529f\u8ba2\u5355\u53f7:{}", (Object[])new Object[]{param.uri.get("out_trade_no")});
                if (PayService.PayType.unifiedorder.name().equals(param.uri.get("paytype"))) {
                    this.service.paySuccess(param.uri.get("out_trade_no"), notifyMap);
                    return new Notice();
                }
                if (PayService.PayType.refund.name().equals(param.uri.get("paytype"))) {
                    this.service.refundSuccess(param.uri.get("out_trade_no"), notifyMap);
                    return new Notice();
                }
                throw new BeeException("\u9000\u6b3e\u5f02\u5e38\u3010\u975e\u6cd5\u8bbf\u95ee\u3011").setCode(610);
            }
            Tool.Log.error((String)"\u8ba2\u5355\u4fe1\u606f\uff1a{}", (Object[])new Object[]{notifyMap});
            Notice notice = new Notice();
            notice.setSuccess(false);
            notice.setMsg("\u7b7e\u540d\u5931\u8d25\uff01");
            return notice;
        }
        catch (Exception e) {
            Tool.Log.error((String)"\u624b\u673a\u652f\u4ed8\u56de\u8c03\u901a\u77e5\u5931\u8d25", (Throwable)e);
            Notice notice = new Notice();
            notice.setSuccess(false);
            notice.setMsg("\u62a5\u6587\u4e3a\u7a7a");
            return notice;
        }
    }

    public String getAppid() {
        return this.appid;
    }

    public WXPayConfig getConfig() {
        return this.config;
    }

    public WXPay getWxpay() {
        return this.wxpay;
    }
}

