/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.wechat.proxy.message.receive;

import bee.cloud.service.wechat.proxy.Client;
import bee.cloud.service.wechat.proxy.Clients;
import bee.cloud.service.wechat.proxy.message.receive.event.Event;
import bee.cloud.service.wechat.proxy.message.receive.event.Location;
import bee.cloud.service.wechat.proxy.message.receive.event.MenuClick;
import bee.cloud.service.wechat.proxy.message.receive.event.MenuView;
import bee.cloud.service.wechat.proxy.message.receive.event.Scan;
import bee.cloud.service.wechat.proxy.message.receive.event.Subscribe;
import bee.cloud.service.wechat.proxy.message.receive.event.UnSubscribe;
import bee.cloud.service.wechat.proxy.message.receive.general.GImage;
import bee.cloud.service.wechat.proxy.message.receive.general.GLink;
import bee.cloud.service.wechat.proxy.message.receive.general.GLocation;
import bee.cloud.service.wechat.proxy.message.receive.general.GShortVideo;
import bee.cloud.service.wechat.proxy.message.receive.general.GText;
import bee.cloud.service.wechat.proxy.message.receive.general.GVideo;
import bee.cloud.service.wechat.proxy.message.receive.general.GVoice;
import bee.cloud.service.wechat.proxy.message.receive.general.General;
import bee.tool.log.Log;
import bee.tool.string.Format;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.Method;
import java.util.Map;

public abstract class Receive {
    protected static final String BODY = "#Body#";
    private static String base;
    private String openid;
    private String originalid;
    private long CreateTime;
    private String MsgId;
    private Map<String, String> map;

    static {
        StringBuffer sb = new StringBuffer();
        sb.append("<xml>");
        sb.append("<ToUserName><![CDATA[#ToUserName#]]></ToUserName>");
        sb.append("<FromUserName><![CDATA[#FromUserName#]]></FromUserName>");
        sb.append("<CreateTime>#CreateTime#</CreateTime>");
        sb.append("<MsgType><![CDATA[#MsgType#]]></MsgType>");
        sb.append(BODY);
        sb.append("</xml>");
        base = sb.toString();
        Object var0 = null;
    }

    public Receive(Map<String, String> map) {
        if (map == null) {
            return;
        }
        this.map = map;
        this.setOpenid(map.get("FromUserName"));
        this.setOriginalid(map.get("ToUserName"));
        this.CreateTime = Format.strToLong((String)map.get("CreateTime"));
        this.init(map);
    }

    public abstract String getMsgType();

    private void init(Map<String, String> map) {
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if ("MsgType".equals(entry.getKey()) || "Event".equals(entry.getKey())) continue;
            String setMethodName = "set" + entry.getKey();
            try {
                Method setMethod = this.getClass().getMethod(setMethodName, String.class);
                if (setMethod == null) continue;
                setMethod.invoke((Object)this, entry.getValue());
            }
            catch (Exception e) {
                Log.error((String)e.getMessage());
            }
        }
    }

    protected String value(String key) {
        if (this.map == null) {
            return null;
        }
        return this.map.get(key);
    }

    public String getOpenid() {
        return this.openid;
    }

    public void setOpenid(String openid) {
        this.openid = openid;
    }

    public String getOriginalid() {
        return this.originalid;
    }

    public void setOriginalid(String originalid) {
        this.originalid = originalid;
    }

    public long getCreateTime() {
        return this.CreateTime;
    }

    public void setCreateTime(long createTime) {
        this.CreateTime = createTime;
    }

    @JsonIgnore
    public Client getClient() {
        return Clients.getClient(this.originalid);
    }

    public String toString() {
        String str = base.replace("#ToUserName#", this.originalid).replace("#FromUserName#", this.openid).replace("#CreateTime#", "" + this.CreateTime).replace("#MsgType#", this.getMsgType());
        return str;
    }

    public static Receive toReceive(Map<String, String> map) {
        String type = map.get("MsgType");
        if ("event".equals(type)) {
            return Receive.toReceiveEvent(map);
        }
        return Receive.toReceiveGeneral(map);
    }

    private static General toReceiveGeneral(Map<String, String> map) {
        String type = map.get("MsgType");
        if ("image".equals(type)) {
            return new GImage(map);
        }
        if ("link".equals(type)) {
            return new GLink(map);
        }
        if ("location".equals(type)) {
            return new GLocation(map);
        }
        if ("shortvideo".equals(type)) {
            return new GShortVideo(map);
        }
        if ("text".equals(type)) {
            return new GText(map);
        }
        if ("video".equals(type)) {
            return new GVideo(map);
        }
        if ("voice".equals(type)) {
            return new GVoice(map);
        }
        return null;
    }

    private static Event toReceiveEvent(Map<String, String> map) {
        String event = map.get("Event");
        if ("subscribe".equals(event)) {
            return new Subscribe(map);
        }
        if ("CLICK".equals(event)) {
            return new MenuClick(map);
        }
        if ("LOCATION".equals(event)) {
            return new Location(map);
        }
        if ("SCAN".equals(event)) {
            return new Scan(map);
        }
        if ("unsubscribe".equals(event)) {
            return new UnSubscribe(map);
        }
        if ("VIEW".equals(event)) {
            return new MenuView(map);
        }
        return null;
    }

    public String getMsgId() {
        return this.MsgId;
    }

    public void setMsgId(String msgId) {
        this.MsgId = msgId;
    }
}

