/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.wechat.proxy;

import bee.cloud.config.BConfig;
import bee.cloud.core.db.DBE;
import bee.cloud.core.db.RequestParam;
import bee.cloud.service.wechat.bean.Serviceno;
import bee.cloud.service.wechat.bean.Weapi;
import bee.cloud.service.wechat.proxy.AccessToken;
import bee.cloud.service.wechat.proxy.Client;
import bee.tool.Tool;
import bee.tool.log.Log;
import bee.tool.timer.Task;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Clients {
    private static Map<String, String> accountServicenoIds = new HashMap<String, String>();
    private static Map<String, String> originalidServicenoIds = new HashMap<String, String>();
    private static Map<String, String> appidServicenoIds = new HashMap<String, String>();
    private static Map<String, Client> clients = new HashMap<String, Client>();
    private static Map<String, Weapi> weapis = new HashMap<String, Weapi>();
    private static Map<String, String> weapiIds = new HashMap<String, String>();
    private static long lastUpdateTime = 0L;

    static {
        Clients.init();
    }

    private Clients() {
        Refresh refresh = new Refresh();
        refresh.start(600);
        Clients.flushToken();
    }

    private static void init() {
        List weapis;
        RequestParam param = new RequestParam();
        param.put("pagesize", 1000);
        param.put("valid", 0);
        param.put("fields", "merchant[mch_id,paykey,cert]");
        List servicenos = DBE.query(Serviceno.class, (RequestParam)param);
        if (servicenos != null) {
            servicenos.forEach(serviceno -> {
                long time;
                Date ut = serviceno.getUpdateTime();
                if (ut != null && (time = ut.getTime()) > lastUpdateTime) {
                    lastUpdateTime = time;
                }
                Client client = new Client((Serviceno)((Object)serviceno));
                Clients.addClient(serviceno.getServicenoId(), client);
            });
        }
        if ((weapis = DBE.query(Weapi.class, (RequestParam)param)) != null) {
            weapis.forEach(api -> Clients.addWeapi(api));
        }
    }

    private static void refreshSingle() {
        JsonNode node = BConfig.getNode((String)"wechat");
        if (node == null || !node.has("appid")) {
            return;
        }
        Serviceno sno = new Serviceno();
        sno.instance(node);
        Client client = Clients.getClient(sno.getAppid());
        if (client != null) {
            Serviceno osno = client.getServiceno();
            osno.setAccount(sno.getAccount());
            osno.setAeskey(sno.getAeskey());
            osno.setAppid(sno.getAppid());
            osno.setAppsecret(sno.getAppsecret());
            osno.setClassify(sno.getClassify());
            osno.setName(sno.getName());
            osno.setOriginalid(sno.getOriginalid());
            osno.setToken(sno.getToken());
            osno.setValid(sno.getValid());
            osno.setUpdateTime(sno.getUpdateTime());
            osno.setWelcome(sno.getWelcome());
            osno.setMchId(sno.getMchId());
            osno.setPaykey(sno.getPaykey());
        } else {
            client = new Client(sno);
            Clients.addClient(sno.getServicenoId(), client);
        }
    }

    public static void refresh() {
        Clients.refreshSingle();
        RequestParam param = new RequestParam();
        param.put("pagesize", 1000);
        param.put("update_time", ">" + lastUpdateTime);
        List servicenos = DBE.query(Serviceno.class, (RequestParam)param);
        if (servicenos != null) {
            servicenos.forEach(sno -> {
                if (sno.getValid() == 1) {
                    Clients.remove(sno.getServicenoId());
                    return;
                }
                if (clients.containsKey(sno.getServicenoId())) {
                    Serviceno osno = clients.get(sno.getServicenoId()).getServiceno();
                    osno.setAccount(sno.getAccount());
                    osno.setAeskey(sno.getAeskey());
                    osno.setAppid(sno.getAppid());
                    osno.setAppsecret(sno.getAppsecret());
                    osno.setClassify(sno.getClassify());
                    osno.setName(sno.getName());
                    osno.setOriginalid(sno.getOriginalid());
                    osno.setToken(sno.getToken());
                    osno.setValid(sno.getValid());
                    osno.setUpdateTime(sno.getUpdateTime());
                    osno.setWelcome(sno.getWelcome());
                    osno.setMchId(sno.getMchId());
                    osno.setPaykey(sno.getPaykey());
                    if (sno.getUpdateTime() != null && sno.getUpdateTime().getTime() > lastUpdateTime) {
                        lastUpdateTime = sno.getUpdateTime().getTime();
                    }
                }
            });
        }
    }

    public static Client[] getClients() {
        Collection<Client> list = clients.values();
        Client[] arr = new Client[list.size()];
        arr = list.toArray(arr);
        return arr;
    }

    public static String getServicenoId(String key) {
        String servicenoId = originalidServicenoIds.containsKey(key) ? originalidServicenoIds.get(key) : (appidServicenoIds.containsKey(key) ? appidServicenoIds.get(key) : (accountServicenoIds.containsKey(key) ? accountServicenoIds.get(key) : key));
        return servicenoId;
    }

    public static synchronized Client getClient(String key) {
        String servicenoId = Clients.getServicenoId(key);
        if (!clients.containsKey(servicenoId)) {
            Serviceno serviceno = new Serviceno();
            serviceno.setServicenoId(servicenoId);
            if (serviceno.load(new String[0])) {
                Client client = new Client(serviceno);
                Clients.addClient(serviceno.getServicenoId(), client);
            }
        }
        Client client = clients.get(servicenoId);
        Objects.requireNonNull(client, "[" + key + "]\u5bf9\u5e94\u7684\u670d\u52a1\u53f7\u6216\u5c0f\u7a0b\u5e8f\u4e0d\u5b58\u5728\uff01");
        return client;
    }

    public static void addClient(String servicenoId, Client client) {
        accountServicenoIds.put(client.getServiceno().getAccount(), servicenoId);
        originalidServicenoIds.put(client.getServiceno().getOriginalid(), servicenoId);
        appidServicenoIds.put(client.getServiceno().getAppid(), servicenoId);
        clients.put(servicenoId, client);
    }

    public static void remove(String servicenoId) {
        Client client = clients.remove(servicenoId);
        if (client == null) {
            if ((servicenoId = originalidServicenoIds.remove(servicenoId)) == null) {
                servicenoId = accountServicenoIds.remove(servicenoId);
            }
            if (servicenoId == null) {
                servicenoId = appidServicenoIds.remove(servicenoId);
            }
            if (servicenoId == null) {
                return;
            }
            client = clients.remove(servicenoId);
        }
        if (client == null) {
            return;
        }
        originalidServicenoIds.remove(client.getServiceno().getOriginalid());
        accountServicenoIds.remove(client.getServiceno().getAccount());
        appidServicenoIds.remove(client.getServiceno().getAppid());
    }

    public static void removeWeapi(String weapiId) {
        String keyword = weapiIds.remove(weapiId);
        weapis.remove(keyword);
    }

    public static void addWeapi(Weapi weapi) {
        weapiIds.put(weapi.getWeapiId(), weapi.getKeyword());
        weapis.put(weapi.getKeyword(), weapi);
    }

    public static Weapi getWeapi(String keyword) {
        return weapis.get(keyword);
    }

    public static void update(Serviceno serviceno) {
        if (!clients.containsKey(serviceno.getServicenoId())) {
            return;
        }
        for (Map.Entry<String, String> entry : accountServicenoIds.entrySet()) {
            if (entry.getValue() != serviceno.getServicenoId()) continue;
            accountServicenoIds.remove(entry.getKey());
            break;
        }
        accountServicenoIds.put(serviceno.getAccount(), serviceno.getServicenoId());
        for (Map.Entry<String, String> entry : appidServicenoIds.entrySet()) {
            if (entry.getValue() != serviceno.getAppid()) continue;
            appidServicenoIds.remove(entry.getKey());
            break;
        }
        appidServicenoIds.put(serviceno.getAppid(), serviceno.getServicenoId());
        for (Map.Entry<String, String> entry : originalidServicenoIds.entrySet()) {
            if (entry.getValue() != serviceno.getOriginalid()) continue;
            originalidServicenoIds.remove(entry.getKey());
            break;
        }
        originalidServicenoIds.put(serviceno.getOriginalid(), serviceno.getServicenoId());
        clients.get(serviceno.getServicenoId()).getServiceno().copy(serviceno);
        clients.get(serviceno.getServicenoId()).floushToken();
    }

    private static void flushToken() {
        TokenTask task = new TokenTask();
        task.start(300);
    }

    private static class Refresh
    extends Task {
        private Refresh() {
        }

        protected void go() {
            Clients.refresh();
        }
    }

    public static class TokenTask
    extends Task {
        protected void go() {
            for (Map.Entry entry : clients.entrySet()) {
                Client client = (Client)entry.getValue();
                AccessToken token = client.getAccessToken();
                if (Tool.Format.isEmpty((String)token.getAccessToken())) continue;
                long tmp = (System.currentTimeMillis() - token.getTime()) / 1000L;
                Log.info((String)("+ExpiresIn:" + token.getExpiresIn()));
                Log.info((String)("-ExpiresIn:" + ((long)token.getExpiresIn() - tmp)));
                if (token.getExpiresIn() != 0 && (long)token.getExpiresIn() - tmp >= 5400L) continue;
                client.floushToken();
            }
        }
    }
}

