/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.wechat.proxy;

import bee.cloud.core.db.RequestParam;
import bee.cloud.ri.http.Http;
import bee.cloud.ri.http.HttpClientImpl;
import bee.cloud.service.wechat.bean.Serviceno;
import bee.cloud.service.wechat.bean.Weapi;
import bee.cloud.service.wechat.proxy.AccessToken;
import bee.cloud.service.wechat.proxy.Clients;
import bee.cloud.service.wechat.proxy.message.send.SImage;
import bee.cloud.service.wechat.proxy.message.send.SMessage;
import bee.cloud.service.wechat.proxy.message.send.SText;
import bee.tool.Tool;
import bee.tool.log.Log;
import bee.tool.string.Format;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Set;

public class Client {
    private HttpClientImpl httpClientImpl;
    private final Serviceno serviceno;
    private static final String ACCESS_TOKEN = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=APPID&secret=APPSECRET";
    private AccessToken accessToken = new AccessToken();

    protected Client(Serviceno serviceno) {
        this.serviceno = serviceno;
        this.httpClientImpl = HttpClientImpl.createClient();
    }

    public AccessToken getAccessToken() {
        if (Tool.Format.isEmpty((String)this.accessToken.getAccessToken())) {
            this.floushToken();
        }
        return this.accessToken;
    }

    public HttpClientImpl getHttpClient() {
        return this.httpClientImpl;
    }

    public Serviceno getServiceno() {
        return this.serviceno;
    }

    public String excute(Weapi api, String data) {
        return this.excute(api, data, null);
    }

    public String sendImageMsg(String openid, String mediaId) {
        SImage simage = new SImage();
        simage.setOpenid(openid);
        simage.setMediaId(mediaId);
        return this.sendMsg(simage);
    }

    public String sendTextMsg(String openid, String content) {
        SText stext = new SText();
        stext.setOpenid(openid);
        stext.setContent(content);
        return this.sendMsg(stext);
    }

    public String sendMsg(SMessage message) {
        String cmd = "message/custom/send";
        String data = message.toString();
        String out = this.excute(Clients.getWeapi(cmd), data);
        return out;
    }

    public boolean floushToken() {
        if (this.serviceno.getClassify() == 4) {
            return false;
        }
        String url = ACCESS_TOKEN.replace("APPID", this.serviceno.getAppid()).replace("APPSECRET", this.serviceno.getAppsecret());
        Http http = this.httpClientImpl.createHttp(url, Http.Method.GET);
        Http.Response response = http.execute();
        String data = response.toString();
        JsonNode json = Tool.Json.readTree((String)response.toString());
        if (!json.has("access_token")) {
            Tool.Log.warn((String)"{}:\u83b7\u53d6token\u5931\u8d25", (Object[])new Object[]{this.serviceno.getAppid()});
            Tool.Log.warn((String)json.toString());
            return false;
        }
        String accessToken = Tool.Json.asText((JsonNode)json.get("access_token"));
        int expiresIn = Tool.Json.asInt((JsonNode)json.get("expires_in"));
        this.accessToken.setAccessToken(accessToken);
        this.accessToken.setExpiresIn(expiresIn);
        this.accessToken.setTime(System.currentTimeMillis());
        if (Format.isEmpty((String)this.accessToken.getAccessToken())) {
            this.accessToken.setInfo(data);
        } else {
            this.accessToken.setInfo(null);
        }
        Log.info((String)data);
        Log.info((String)this.serviceno.getAccount());
        Log.info((String)this.accessToken.getAccessToken());
        return true;
    }

    public String excute(Weapi api, String data, RequestParam params) {
        Http.Response response;
        String our;
        String url = api.getUrl();
        if (api.getUrl().indexOf("ACCESS_TOKEN") > 0) {
            if (Format.isEmpty((String)this.accessToken.getAccessToken()) && !this.floushToken()) {
                return this.accessToken.getInfo();
            }
            url = url.replace("ACCESS_TOKEN", this.accessToken.getAccessToken());
        }
        url = url.replace("APPID", this.serviceno.getAppid()).replace("APPSECRET", this.serviceno.getAppsecret());
        if (params != null) {
            Set keys = params.keys();
            for (String key : keys) {
                if (key.length() == 1 || key.startsWith("_")) continue;
                String value = params.asText(key);
                if (Format.isEmpty((String)value)) {
                    value = "";
                }
                url = url.replace(key.toUpperCase(), value);
                url = url.replace("{" + key + "}", value);
            }
        }
        Http http = this.httpClientImpl.createHttp(url, Http.Method.valueOf((String)api.getMethod().toUpperCase()));
        http.setHeader("Content-Type", "application/json;charset=ISO-8859-1");
        if (Format.noEmpty((Object)data)) {
            http.setJsonStrParams(data);
        }
        if ((our = (response = http.execute()).toString()).indexOf("42001") > 0 && this.floushToken()) {
            return this.excute(api, data, params);
        }
        return our;
    }

    public String excuteMultipart(Weapi api, Http.Multipart multipart) {
        if (Format.isEmpty((String)this.accessToken.getAccessToken())) {
            return this.accessToken.getInfo();
        }
        String url = api.getUrl().replace("ACCESS_TOKEN", this.accessToken.getAccessToken()).replace("APPID", this.serviceno.getAppid()).replace("APPSECRET", this.serviceno.getAppsecret());
        Log.info((String)("url:" + url));
        Http http = this.httpClientImpl.createHttp(url, Http.Method.valueOf((String)api.getMethod().toUpperCase()));
        if (multipart != null) {
            http.setMultipart(multipart);
        }
        Http.Response response = http.execute();
        String our = response.toString();
        return our;
    }
}

