/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.wechat.controller;

import bee.cloud.core.Bee;
import bee.cloud.core.db.RequestParam;
import bee.cloud.service.core.ShowApi;
import bee.cloud.service.core.annotation.API;
import bee.cloud.service.core.annotation.ApiParam;
import bee.cloud.service.wechat.proxy.pay.PayData;
import bee.cloud.service.wechat.proxy.pay.PayService;
import bee.cloud.service.wechat.proxy.pay.WePay;
import bee.cloud.service.wechat.proxy.pay.param.OrderInfo;
import bee.cloud.service.wechat.proxy.pay.param.RefundParam;
import bee.tool.Tool;
import bee.tool.err.BeeException;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
@RequestMapping(value={"/wepay"})
public class WechatPay
extends ShowApi {
    @Autowired(required=false)
    private PayService service;
    private static String WECHAT_TOOL_HOST = "servicewechat.com";
    public static final String NOTIFY_URL = "/notice/{paytype}/{out_trade_no}";

    public boolean isShow() {
        return this.service != null;
    }

    @API(title="\u53d1\u8d77\u9884\u652f\u4ed8\u8ba2\u5355\u7533\u8bf7", param={@ApiParam(name="product_id", title="\u4ea7\u54c1ID", required=true, memo="\u5bf9\u5e94\u4ea7\u54c1\u8868\u7684ID")})
    @PostMapping(value={"/unified/order"})
    public @ApiParam(name="product_id", title="\u4ea7\u54c1ID", required=true, memo="\u5bf9\u5e94\u4ea7\u54c1\u8868\u7684ID") PayData doUnifiedOrder() {
        Bee.Resreq resreq = Bee.getResreq();
        RequestParam param = resreq.getRequestParam();
        String appid = this.getAppid();
        String openid = param.header.get("openid");
        if (Tool.Format.isEmpty((String)appid) || Tool.Format.isEmpty((String)openid)) {
            throw new BeeException("\u8bf7\u5148\u901a\u8fc7JS_CODE\u83b7\u53d6OPENID\u540e\u518d\u8c03\u7528\u8be5\u63a5\u53e3\u3002");
        }
        param.header.put("openid", openid);
        OrderInfo info = this.service.createOrderInfo(param);
        WePay wepay = new WePay(appid);
        PayData paydata = wepay.unifiedOrder(openid, info);
        return paydata;
    }

    @API(title="WeChat\u652f\u4ed8\u5f02\u6b65\u7ed3\u679c\u901a\u77e5")
    @RequestMapping(value={"/notice/{paytype}/{out_trade_no}"}, method={RequestMethod.GET, RequestMethod.POST})
    public String wxPayNotify() {
        Bee.Resreq resreq = Bee.getResreq();
        RequestParam param = resreq.getRequestParam();
        String appid = this.getAppid();
        WePay wepay = new WePay(appid);
        return wepay.successNotice(param).toString();
    }

    @API(title="\u7533\u8bf7\u9000\u6b3e", param={@ApiParam(name="out_trade_no", length=32, required=true, title="\u5546\u6237\u8ba2\u5355\u53f7", memo="\u5546\u6237\u8ba2\u5355\u53f7")})
    @PostMapping(value={"/secapi/pay/refund"})
    public @ApiParam(name="out_trade_no", length=32, required=true, title="\u5546\u6237\u8ba2\u5355\u53f7", memo="\u5546\u6237\u8ba2\u5355\u53f7") Map<String, String> refund() {
        Bee.Resreq resreq = Bee.getResreq();
        RequestParam param = resreq.getRequestParam();
        String appid = this.getAppid();
        WePay wepay = new WePay(appid);
        String out_trade_no = param.asText("out_trade_no");
        RefundParam refundParam = this.service.getRefundParam(out_trade_no);
        refundParam.setOutTradeNo(out_trade_no);
        if (Tool.Format.isEmptys((String[])new String[]{refundParam.getAppid(), refundParam.getMchId()})) {
            Tool.Log.error((String)"APPID\u4e0emch_id\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            throw new BeeException("\u53c2\u6570\u4e0d\u5168\u3002");
        }
        return wepay.refund(out_trade_no);
    }

    @API(title="\u7533\u8bf7\u9000\u6b3e\u67e5\u8be2", param={@ApiParam(name="out_trade_no", length=32, required=true, title="\u5546\u6237\u8ba2\u5355\u53f7", memo="\u5546\u6237\u8ba2\u5355\u53f7")})
    @PostMapping(value={"/secapi/pay/refund/query"})
    public @ApiParam(name="out_trade_no", length=32, required=true, title="\u5546\u6237\u8ba2\u5355\u53f7", memo="\u5546\u6237\u8ba2\u5355\u53f7") Map<String, String> refundQuery() {
        Bee.Resreq resreq = Bee.getResreq();
        RequestParam param = resreq.getRequestParam();
        String appid = this.getAppid();
        WePay wepay = new WePay(appid);
        String out_trade_no = param.asText("out_trade_no");
        return wepay.queryRefund(out_trade_no);
    }

    @API(title="\u5173\u95ed\u8ba2\u5355", param={@ApiParam(name="out_trade_no", length=32, required=true, title="\u5546\u6237\u8ba2\u5355\u53f7", memo="\u5546\u6237\u8ba2\u5355\u53f7")})
    @PostMapping(value={"/close/order"})
    public @ApiParam(name="out_trade_no", length=32, required=true, title="\u5546\u6237\u8ba2\u5355\u53f7", memo="\u5546\u6237\u8ba2\u5355\u53f7") Map<String, String> closeOrder() {
        Bee.Resreq resreq = Bee.getResreq();
        RequestParam param = resreq.getRequestParam();
        String appid = this.getAppid();
        WePay wepay = new WePay(appid);
        String out_trade_no = param.asText("out_trade_no");
        return wepay.closeOrder(out_trade_no);
    }

    private String getAppid() {
        Bee.Resreq resreq = Bee.getResreq();
        RequestParam param = resreq.getRequestParam();
        String appid = Tool.Value.toSingle((String[])new String[]{param.uri.get("appid"), param.asText("appid"), param.getCookie("appid"), param.getHeader("appid")});
        if (Tool.Format.isEmpty((String)appid)) {
            String referer = param.header.getReferer();
            String wehost = param.header.getRefererDomain();
            if (!WECHAT_TOOL_HOST.equals(wehost)) {
                throw new BeeException("\u975e\u6cd5\u8c03\u7528\u5fae\u4fe1\u652f\u4ed8\u3002");
            }
            appid = referer.split("/")[3];
        }
        return appid;
    }
}

