/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.wechat.controller;

import bee.cloud.config.BConfig;
import bee.cloud.core.Bee;
import bee.cloud.core.db.RequestParam;
import bee.cloud.service.core.result.Results;
import bee.cloud.service.wechat.proxy.Client;
import bee.cloud.service.wechat.proxy.Clients;
import bee.cloud.service.wechat.work.DataWork;
import bee.tool.Tool;
import bee.tool.string.Format;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public abstract class WechatData {
    public static final String ACCOUNT = "account";
    public static final String ACCOUNT_TITLE = "\u8d26\u53f7";
    public static final String ACCOUNT_MEMO = "\u6bcf\u4e2a\u670d\u52a1\u53f7\u6216\u5c0f\u7a0b\u5e8f\u9700\u8981\u8bbe\u7f6e\u4e00\u4e2a\u552f\u4e00\u7684\u8d26\u53f7";
    public static final String DATA = "data";

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST}, path={"/{cmd}", "/{cmd}/{cmd1}", "/{cmd}/{cmd1}/{cmd2}", "/{cmd}/{cmd1}/{cmd2}/{cmd3}", "/{cmd}/{cmd1}/{cmd2}/{cmd3}/{cmd4}", "/{cmd}/{cmd1}/{cmd2}/{cmd3}/{cmd4}/{cmd5}"})
    public Results request(PathValue pathValue) {
        Bee.Resreq resreq = Bee.getResreq();
        if ("post".equalsIgnoreCase(resreq.getRequestParam().header.getMethod())) {
            return this.doPost(resreq, pathValue);
        }
        return this.doGet(resreq, pathValue);
    }

    private Results doPost(Bee.Resreq resreq, PathValue pathValue) {
        Results results = new Results();
        results.setResponse(resreq.getHttpServletResponse());
        RequestParam param = resreq.getRequestParam();
        String data = param.has(DATA) ? param.asText(DATA) : null;
        String account = Tool.Value.toSingle((String[])new String[]{param.uri.get(ACCOUNT), BConfig.asText((String)"wechat.appid")});
        Client client = Clients.getClient(account);
        String out = client.excute(Clients.getWeapi(pathValue.getPath()), data);
        results.succeed((Object)out);
        return results;
    }

    private Results doGet(Bee.Resreq resreq, PathValue pathValue) {
        Results results = new Results();
        results.setResponse(resreq.getHttpServletResponse());
        RequestParam param = resreq.getRequestParam();
        String account = Tool.Value.toSingle((String[])new String[]{param.uri.get(ACCOUNT), BConfig.asText((String)"wechat.appid")});
        Client client = Clients.getClient(account);
        String out = client.excute(Clients.getWeapi(pathValue.getPath()), null, param.getChildren(DATA));
        if ("user/get".equals(pathValue.getPath())) {
            out = DataWork.getUserInfo(out, resreq.getRequestParam());
        }
        results.succeed((Object)out);
        return results;
    }

    public static class PathValue {
        private String cmd;
        private String cmd1;
        private String cmd2;
        private String cmd3;
        private String cmd4;
        private String cmd5;

        public String getPath() {
            StringBuffer sb = new StringBuffer();
            if (Format.noEmpty((Object)this.cmd)) {
                sb.append(this.cmd);
            }
            if (Format.noEmpty((Object)this.cmd1)) {
                sb.append("/").append(this.cmd1);
            }
            if (Format.noEmpty((Object)this.cmd2)) {
                sb.append("/").append(this.cmd2);
            }
            if (Format.noEmpty((Object)this.cmd3)) {
                sb.append("/").append(this.cmd3);
            }
            if (Format.noEmpty((Object)this.cmd4)) {
                sb.append("/").append(this.cmd4);
            }
            if (Format.noEmpty((Object)this.cmd5)) {
                sb.append("/").append(this.cmd5);
            }
            return sb.toString();
        }

        public String getCmd() {
            return this.cmd;
        }

        public String getCmd1() {
            return this.cmd1;
        }

        public String getCmd2() {
            return this.cmd2;
        }

        public String getCmd3() {
            return this.cmd3;
        }

        public String getCmd4() {
            return this.cmd4;
        }

        public String getCmd5() {
            return this.cmd5;
        }

        public void setCmd(String cmd) {
            this.cmd = cmd;
        }

        public void setCmd1(String cmd1) {
            this.cmd1 = cmd1;
        }

        public void setCmd2(String cmd2) {
            this.cmd2 = cmd2;
        }

        public void setCmd3(String cmd3) {
            this.cmd3 = cmd3;
        }

        public void setCmd4(String cmd4) {
            this.cmd4 = cmd4;
        }

        public void setCmd5(String cmd5) {
            this.cmd5 = cmd5;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PathValue)) {
                return false;
            }
            PathValue other = (PathValue)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$cmd = this.getCmd();
            String other$cmd = other.getCmd();
            if (this$cmd == null ? other$cmd != null : !this$cmd.equals(other$cmd)) {
                return false;
            }
            String this$cmd1 = this.getCmd1();
            String other$cmd1 = other.getCmd1();
            if (this$cmd1 == null ? other$cmd1 != null : !this$cmd1.equals(other$cmd1)) {
                return false;
            }
            String this$cmd2 = this.getCmd2();
            String other$cmd2 = other.getCmd2();
            if (this$cmd2 == null ? other$cmd2 != null : !this$cmd2.equals(other$cmd2)) {
                return false;
            }
            String this$cmd3 = this.getCmd3();
            String other$cmd3 = other.getCmd3();
            if (this$cmd3 == null ? other$cmd3 != null : !this$cmd3.equals(other$cmd3)) {
                return false;
            }
            String this$cmd4 = this.getCmd4();
            String other$cmd4 = other.getCmd4();
            if (this$cmd4 == null ? other$cmd4 != null : !this$cmd4.equals(other$cmd4)) {
                return false;
            }
            String this$cmd5 = this.getCmd5();
            String other$cmd5 = other.getCmd5();
            return !(this$cmd5 == null ? other$cmd5 != null : !this$cmd5.equals(other$cmd5));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PathValue;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $cmd = this.getCmd();
            result = result * 59 + ($cmd == null ? 43 : $cmd.hashCode());
            String $cmd1 = this.getCmd1();
            result = result * 59 + ($cmd1 == null ? 43 : $cmd1.hashCode());
            String $cmd2 = this.getCmd2();
            result = result * 59 + ($cmd2 == null ? 43 : $cmd2.hashCode());
            String $cmd3 = this.getCmd3();
            result = result * 59 + ($cmd3 == null ? 43 : $cmd3.hashCode());
            String $cmd4 = this.getCmd4();
            result = result * 59 + ($cmd4 == null ? 43 : $cmd4.hashCode());
            String $cmd5 = this.getCmd5();
            result = result * 59 + ($cmd5 == null ? 43 : $cmd5.hashCode());
            return result;
        }

        public String toString() {
            return "WechatData.PathValue(cmd=" + this.getCmd() + ", cmd1=" + this.getCmd1() + ", cmd2=" + this.getCmd2() + ", cmd3=" + this.getCmd3() + ", cmd4=" + this.getCmd4() + ", cmd5=" + this.getCmd5() + ")";
        }
    }
}

