/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.wechat.controller;

import bee.cloud.config.BConfig;
import bee.cloud.core.Bee;
import bee.cloud.core.db.BusinessManage;
import bee.cloud.core.db.RequestParam;
import bee.cloud.service.core.annotation.API;
import bee.cloud.service.core.annotation.ApiParam;
import bee.cloud.service.core.result.Results;
import bee.cloud.service.wechat.bean.Serviceno;
import bee.cloud.service.wechat.bean.Weapi;
import bee.cloud.service.wechat.proxy.Client;
import bee.cloud.service.wechat.proxy.Clients;
import bee.cloud.service.wechat.proxy.Decript;
import bee.cloud.service.wechat.proxy.message.MsgLock;
import bee.cloud.service.wechat.proxy.message.receive.Receive;
import bee.cloud.service.wechat.proxy.message.reply.RText;
import bee.cloud.service.wechat.proxy.message.reply.Reply;
import bee.cloud.service.wechat.work.MsgWork;
import bee.tool.Tool;
import bee.tool.err.BeeException;
import bee.tool.log.Log;
import bee.tool.string.Encrypt;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
@RequestMapping(value={"/entrance"})
public class Entrance {
    public static final String GET_JS_TOKEN_URL = "https://api.weixin.qq.com/sns/jscode2session";
    @Autowired
    private MsgWork msgWork;

    private boolean checkSignature() {
        if (!BConfig.asBoolean((String)"wechat.check_signature", (boolean)true)) {
            return true;
        }
        RequestParam params = BusinessManage.inst().getRequestParam();
        Tool.Log.info((String)"===============================");
        Tool.Log.info((String)params.toString());
        String signature = params.asText("signature");
        String timestamp = params.asText("timestamp");
        String nonce = params.asText("nonce");
        Tool.Log.info((String)"signature:{}", (Object[])new Object[]{signature});
        if (Tool.Format.isEmptys((String[])new String[]{signature, timestamp, nonce})) {
            Tool.Log.error((String)"\u5b58\u5728\u6821\u9a8c\u7b7e\u540d\u53c2\u6570\u4e3a\u7a7a!");
            throw new BeeException("\u975e\u6cd5\u8bbf\u95ee\uff0c\u6821\u9a8c\u7b7e\u540d\u53c2\u6570\u4e3a\u7a7a");
        }
        String account = Tool.Value.toSingle((String[])new String[]{params.uri.get("account"), BConfig.asText((String)"wechat.appid")});
        Tool.Log.info((String)"account:{}", (Object[])new Object[]{account});
        String token = Clients.getClient(account).getServiceno().getToken();
        String sortString = Decript.sort(token, timestamp, nonce);
        Tool.Log.info((String)"sortString:{}", (Object[])new Object[]{sortString});
        String mytoken = Decript.SHA1(sortString);
        Tool.Log.info((String)"mytoken:{}", (Object[])new Object[]{mytoken});
        return mytoken != null && mytoken != "" && mytoken.equals(signature);
    }

    @API(title="\u5fae\u4fe1\u670d\u52a1\u53f7\u63a5\u5165\u6821\u9a8c\u63a5\u53e3\uff0c\u591a\u670d\u52a1\u53f7\u63a5\u53e3", memo="\u65e0\u9700\u5728\u5fae\u4fe1\u4e2d\u914d\u7f6e", param={@ApiParam(name="account", required=true, title="\u670d\u52a1\u53f7\u8d26\u53f7", memo="\u53ef\u4ee5\u662f\u670d\u52a1\u53f7\u7684\u539f\u59cbID\uff0c\u670d\u52a1\u53f7\u7684\u8d26\u53f7\uff0c\u670d\u52a1\u53f7\u7684appid")})
    @GetMapping(path={"/{account:.+}"})
    public void check(String account) {
        Results results = new Results();
        results.setResponse(Bee.getResreq().getHttpServletResponse());
        RequestParam params = Bee.getRequestParam();
        Tool.Log.info((String)params.toString());
        Tool.Log.info((String)params.header.toString());
        String echostr = params.asText("echostr");
        if (this.checkSignature()) {
            Log.info((String)"\u7b7e\u540d\u6821\u9a8c\u901a\u8fc7\u3002");
            results.build(echostr);
        } else {
            Log.info((String)"\u7b7e\u540d\u6821\u9a8c\u5931\u8d25\u3002");
            results.build("\u7b7e\u540d[" + echostr + "]\u6821\u9a8c\u5931\u8d25\u3002");
        }
    }

    @API(title="\u5fae\u4fe1\u670d\u52a1\u53f7\u63a5\u5165\u6821\u9a8c\u63a5\u53e3\uff0c\u5355\u670d\u52a1\u53f7\u63a5\u53e3", memo="\u65e0\u9700\u5728\u5fae\u4fe1\u4e2d\u914d\u7f6e\uff0c\u5fae\u4fe1\u76f8\u5173\u914d\u9700\u8981\u5728bee.yml\u4e2d\u914d\u7f6ewechat.appid")
    @GetMapping
    public void check() {
        String account = BConfig.asText((String)"wechat.appid");
        this.check(account);
    }

    @API(title="\u5fae\u4fe1\u670d\u52a1\u53f7\u63a5\u5165\u7edf\u4e00\u63a5\u53e3\uff0c\u591a\u670d\u52a1\u53f7\u63a5\u53e3", memo="\u9700\u8981\u5728\u5fae\u4fe1\u4e2d\u914d\u7f6e\u201c\u670d\u52a1\u5668\u5730\u5740(URL)\u201d", param={@ApiParam(name="account", required=true, title="\u670d\u52a1\u53f7\u8d26\u53f7", memo="\u53ef\u4ee5\u662f\u670d\u52a1\u53f7\u7684\u539f\u59cbID\uff0c\u670d\u52a1\u53f7\u7684\u8d26\u53f7\uff0c\u670d\u52a1\u53f7\u7684appid\uff0c\u914d\u7f6e\u5728\u670d\u52a1\u53f7\u4e2d\uff08\u57fa\u672c\u914d\u7f6e>\u670d\u52a1\u5668\u914d\u7f6e>\u670d\u52a1\u5668\u5730\u5740(URL)\uff09")})
    @PostMapping(path={"/{account:.+}"})
    public void post(String account) {
        Bee.Resreq resreq = Bee.getResreq();
        RequestParam params = resreq.getRequestParam();
        Tool.Log.info((String)params.toString());
        Tool.Log.info((String)params.header.toString());
        Results results = new Results();
        results.setResponse(resreq.getHttpServletResponse());
        if (!this.checkSignature()) {
            results.build("");
            return;
        }
        Map map = params.toMap();
        Receive receive = Receive.toReceive(map);
        if (MsgLock.lock(receive.getMsgId())) {
            results.build("");
            return;
        }
        MsgLock.addMsgid(receive.getMsgId());
        try {
            resreq.getHttpServletResponse().setCharacterEncoding("UTF-8");
            resreq.getHttpServletResponse().setContentType("text/xml");
            Reply reply = this.msgWork.parse(receive);
            if (reply != null) {
                String smsg = reply.toString();
                Log.debug((String)smsg);
                results.build(smsg);
            } else {
                results.build("");
            }
        }
        catch (Exception ex) {
            Tool.Log.error((Throwable)ex);
            RText rtext = new RText();
            rtext.init(receive);
            rtext.setContent(ex.getMessage());
            rtext.setCreateTime(System.currentTimeMillis());
            results.build(rtext.toString());
        }
        MsgLock.removeMsgid(receive.getMsgId());
    }

    @API(title="\u5fae\u4fe1\u670d\u52a1\u53f7\u63a5\u5165\u7edf\u4e00\u63a5\u53e3\uff0c\u5355\u670d\u52a1\u53f7\u63a5\u53e3", memo="\u9700\u8981\u5728\u5fae\u4fe1\u4e2d\u914d\u7f6e\u201c\u670d\u52a1\u5668\u5730\u5740(URL)\u201d\uff0c\u5fae\u4fe1\u76f8\u5173\u914d\u9700\u8981\u5728bee.yml\u4e2d\u914d\u7f6ewechat.appid")
    @PostMapping
    public void post() {
        String account = BConfig.asText((String)"wechat.appid");
        this.post(account);
    }

    @API(title="\u6839\u636e\u524d\u7aef\u83b7\u53d6\u7684CODE\u6362\u53d6\u7528\u6237\u7684OPENID\uff1a\u591a\u670d\u52a1\u53f7\u7248\u672c", param={@ApiParam(name="js_code", required=true, title="\u524d\u7aef\u6839\u636e\u5fae\u4fe1\u63d0\u4f9b\u7684JS\u63a5\u53e3\u83b7\u53d6\u7684CODE")})
    @GetMapping(value={"/getopenid"})
    public @ApiParam(name="js_code", required=true, title="\u524d\u7aef\u6839\u636e\u5fae\u4fe1\u63d0\u4f9b\u7684JS\u63a5\u53e3\u83b7\u53d6\u7684CODE") Results codeToOpenid() {
        Results results = new Results();
        Bee.Resreq resreq = Bee.getResreq();
        RequestParam params = resreq.getRequestParam();
        String appid = this.getAppid();
        Client client = Clients.getClient(appid);
        Serviceno serviceno = client.getServiceno();
        String secret = serviceno.getAppsecret();
        params.put("appid", appid);
        params.put("secret", secret);
        Weapi weapi = Clients.getWeapi("sns/jscode2session");
        String res = client.excute(weapi, null, params);
        JsonNode json = Tool.Json.readTree((String)res);
        if (json.has("openid")) {
            String openid = json.get("openid").asText();
            resreq.setCookie("openid", Encrypt.encodeEx((String)openid).toString());
            resreq.setCookie("appid", appid);
        }
        results.succeed((Object)res);
        return results;
    }

    private String getAppid() {
        Bee.Resreq resreq = Bee.getResreq();
        RequestParam param = resreq.getRequestParam();
        String appid = Tool.Value.toSingle((String[])new String[]{param.uri.get("appid"), param.asText("appid"), param.getCookie("appid"), param.getHeader("appid")});
        if (Tool.Format.isEmpty((String)appid)) {
            String referer = param.header.getReferer();
            appid = referer.split("/")[3];
        }
        return appid;
    }
}

