/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.work;

import bee.cloud.core.db.RequestParam;
import bee.cloud.core.db.work.After;
import bee.cloud.core.db.work.VSql;
import bee.cloud.engine.config.sqlmap.QEnum;
import bee.cloud.engine.db.SqlMap;
import bee.cloud.engine.db.annotation.BWork;
import bee.cloud.engine.db.core.CBase;
import bee.cloud.engine.util.Result;
import bee.cloud.ri.mq.BeeMQ;
import bee.cloud.ri.mq.DataBody;
import bee.cloud.ri.mq.DataBodys;
import bee.tool.string.Format;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@BWork(path={"search=*"}, func={QEnum.Func.DELETE, QEnum.Func.UPDATE, QEnum.Func.INSERT})
public class ElasticsearchAfter
implements After {
    @Autowired(required=false)
    private BeeMQ mq;

    public boolean go(Result result, RequestParam params) {
        if (this.mq == null) {
            return false;
        }
        SqlMap.Operator operator = result.getOperator();
        if (QEnum.Func.INSERT.equals((Object)operator.getFunc())) {
            return this.write(result, params);
        }
        if (QEnum.Func.DELETE.equals((Object)operator.getFunc())) {
            return this.delete(result, params);
        }
        if (QEnum.Func.UPDATE.equals((Object)operator.getFunc())) {
            return this.write(result, params);
        }
        return false;
    }

    private boolean write(Result result, RequestParam params) {
        SqlMap.Operator operator = result.getOperator();
        RequestParam nparams = params.cloneNew();
        nparams.put(operator.getQTable().pk.name, params.asText("create_id"));
        VSql vsql = operator.getQTable().build(QEnum.Func.QUERY, nparams);
        List tbs = operator.getSqlexe().query(vsql);
        DataBodys bodys = new DataBodys();
        bodys.setGroupId("search");
        bodys.setTopic("search");
        bodys.setTag("elasticsearch");
        if (tbs != null && tbs.size() > 0) {
            tbs.forEach(tb -> {
                JsonNode json = ((CBase)tb).toJson();
                ObjectNode on = (ObjectNode)json.get("@define");
                on.put("func", operator.getFunc().name());
                bodys.addBody(json.toString().getBytes());
            });
        }
        this.mq.send(bodys);
        return false;
    }

    private boolean delete(Result result, RequestParam params) {
        String pks = params.asText(result.getOperator().getQTable().pk.name);
        if (Format.isEmpty((String)pks)) {
            return false;
        }
        DataBody body = new DataBody();
        body.setGroupId("search");
        body.setTopic("search");
        body.setTag("elasticsearch");
        body.setBody(("delete:" + pks).getBytes());
        this.mq.send(body);
        return false;
    }
}

