/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.controller;

import bee.cloud.core.Bee;
import bee.cloud.service.core.result.Results;
import bee.cloud.service.web.api.WebApi;
import bee.tool.string.Format;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@ControllerAdvice
@RequestMapping(value={"/$api"})
public class WebController {
    private HttpServletResponse response;
    private HttpServletRequest request;
    private Results results = new Results();

    public WebController(HttpServletResponse response, HttpServletRequest request) {
        Bee.Resreq resreq = Bee.getResreq();
        if (resreq != null) {
            this.response = (HttpServletResponse)resreq.getServletResponse();
            this.request = (HttpServletRequest)resreq.getServletRequest();
        } else {
            this.response = response;
            this.request = request;
        }
        this.results.setResponse(response);
    }

    public ModelAndView go() {
        ModelAndView modelAndView = new ModelAndView("redirect:/$api/index.shtml");
        return modelAndView;
    }

    @RequestMapping
    public void index() throws IOException {
        if (this.response.isCommitted()) {
            return;
        }
        String contextPath = this.request.getContextPath();
        String content = WebApi.getContent("/index.shtml");
        StringBuffer sb = new StringBuffer();
        String prefix = Bee.getRequestParam().header.get("x-forwarded-prefix");
        if (prefix == null) {
            prefix = "";
        }
        sb.append("<script>");
        sb.append("location.href='" + (Format.noEmpty((Object)contextPath) ? contextPath : prefix) + "/$api/index.shtml';");
        sb.append("</script>");
        content = sb.toString();
        String type = "text/html";
        if (Format.isEmpty((String)content)) {
            this.response.sendError(404);
            return;
        }
        this.results.setContentType(type);
        this.results.build(content);
    }

    @RequestMapping(value={"/*.shtml", "/*.html", "/*.htm"})
    public void other() throws IOException {
        if (this.response.isCommitted()) {
            return;
        }
        String contextPath = this.request.getContextPath();
        String uri = this.request.getRequestURI();
        uri = uri.substring(contextPath.length());
        uri = uri.substring("/$api".length());
        String type = "text/html";
        String content = WebApi.getContent(uri);
        if (Format.isEmpty((String)content)) {
            this.response.sendError(404);
            return;
        }
        this.results.setContentType(type);
        this.results.build(content);
    }

    @RequestMapping(value={"/**/*.woff", "/**/*.woff2", "/**/*.ttf", "/**/*.eot", "/**/*.otf", "/**/*.svg"})
    public void font() throws IOException {
        if (this.response.isCommitted()) {
            return;
        }
        String contextPath = this.request.getContextPath();
        String uri = this.request.getRequestURI();
        uri = uri.substring(contextPath.length());
        String suffix = (uri = uri.substring("/$api".length()).toLowerCase()).substring(uri.lastIndexOf(".") + 1);
        String type = "woff".equals(suffix) ? "application/font-woff" : ("woff2".equals(suffix) ? "application/octet-stream" : ("ttf".equals(suffix) ? "application/octet-stream" : null));
        byte[] content = WebApi.getBytes(uri);
        if (Format.isEmpty((Object)content)) {
            this.response.sendError(404);
            return;
        }
        int catchTime = 18000;
        this.results.addHeader("Cache-Control", "max-age=" + catchTime);
        if (Format.noEmpty((Object)type)) {
            this.results.setContentType(type);
        }
        this.results.build(content);
    }

    @RequestMapping(value={"/**/*.js", "/**/*.css", "/**/*.html", "/**/*.shtml"})
    public void request() throws IOException {
        if (this.response.isCommitted()) {
            return;
        }
        String contextPath = this.request.getContextPath();
        String uri = this.request.getRequestURI();
        uri = uri.substring(contextPath.length());
        String suffix = (uri = uri.substring("/$api".length())).substring(uri.lastIndexOf(".") + 1);
        String type = "js".equalsIgnoreCase(suffix) ? "text/js" : ("css".equalsIgnoreCase(suffix) ? "text/css" : (suffix.indexOf("htm") >= 0 ? "text/html" : "text/plain"));
        String content = WebApi.getContent(uri);
        if (Format.isEmpty((String)content)) {
            this.response.sendError(404);
            return;
        }
        int catchTime = 18000;
        this.results.addHeader("Cache-Control", "max-age=" + catchTime);
        if (Format.noEmpty((Object)type)) {
            this.results.setContentType(type);
        }
        this.results.build(content);
    }

    @RequestMapping(value={"/**/*.png", "/**/*.jpg", "/**/*.bmp", "/**/*.gif", "*.ico"})
    public void requestImage() throws IOException {
        if (this.response.isCommitted()) {
            return;
        }
        String contextPath = this.request.getContextPath();
        String uri = this.request.getRequestURI();
        uri = uri.substring(contextPath.length());
        uri = uri.substring("/$api".length());
        String type = "image/*";
        byte[] content = WebApi.getBytes(uri);
        if (content == null || content.length == 0) {
            this.response.sendError(404);
            return;
        }
        int catchTime = 18000;
        this.results.addHeader("Cache-Control", "max-age=" + catchTime);
        this.results.setContentType(type);
        this.results.build(content);
    }
}

