/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.controller;

import bee.cloud.engine.config.HttpMethods;
import bee.cloud.engine.config.sqlmap.QApi;
import bee.cloud.engine.config.sqlmap.QEnum;
import bee.cloud.service.core.result.Results;
import bee.cloud.service.file.Upload;
import bee.tool.Tool;
import bee.tool.file.FileItem;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@ControllerAdvice
@RequestMapping(value={"/upload"})
public class UploadController {
    @Autowired(required=false)
    private Upload upload;

    public UploadController() {
        this.initApi();
    }

    @GetMapping
    @PutMapping
    @DeleteMapping
    public String other() {
        return "\u8bf7\u4f7f\u7528POST\u65b9\u5f0f\u4e0a\u4f20\u6587\u4ef6\uff01";
    }

    @PostMapping
    @ResponseBody
    public Results upload(@RequestParam(value="file") MultipartFile file) {
        Results results = new Results();
        if (this.upload == null) {
            results.error((Object)"\u65e0\u6587\u4ef6\u5904\u7406\u5668\uff0c\u8bf7\u5b9e\u73b0Upload\u7c7b\uff01");
            return results;
        }
        if (file.isEmpty()) {
            results.error((Object)"\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u6587\u4ef6");
            return results;
        }
        FileItem fileItem = new FileItem();
        try {
            fileItem.setName(file.getOriginalFilename());
            fileItem.setType(fileItem.getName().substring(fileItem.getName().lastIndexOf(".") + 1));
            fileItem.setSize(file.getSize());
            fileItem.setContentType(file.getContentType());
            fileItem.setInputStream(Tool.cloneInputStream((InputStream)file.getInputStream()));
            this.upload.execute(fileItem);
            results.succeed((Object)fileItem.getUrl());
        }
        catch (IOException e) {
            results.error((Object)"\u4e0a\u4f20\u5931\u8d25");
            e.printStackTrace();
            return results;
        }
        return results;
    }

    public Results upload1(@RequestParam(value="file") MultipartFile file) {
        Results results = new Results();
        if (file.isEmpty()) {
            results.error((Object)"\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u6587\u4ef6");
            return results;
        }
        FileItem fileItem = new FileItem();
        try {
            fileItem.setName(file.getOriginalFilename());
            fileItem.setType(fileItem.getName().substring(fileItem.getName().lastIndexOf(".") + 1));
            fileItem.setSize(file.getSize());
            fileItem.setContentType(file.getContentType());
            fileItem.setInputStream(file.getInputStream());
            if (this.upload != null) {
                HashMap<String, String> map = new HashMap<String, String>();
                this.upload.execute(fileItem);
                map.put("path", fileItem.getUrl());
                map.putAll(fileItem.getExtend());
                results.succeed(map);
            }
        }
        catch (IOException e) {
            results.error((Object)"\u4e0a\u4f20\u5931\u8d25");
            e.printStackTrace();
            return results;
        }
        return results;
    }

    private void initApi() {
        QApi.QUri quri = new QApi.QUri("post", "/upload");
        quri.setTitle("\u4e0a\u4f20\u6587\u4ef6");
        quri.setDescribe("\u4e0a\u4f20\u6587\u4ef6\u64cd\u4f5c\uff0c\u8fd4\u56de\u4e0a\u4f20\u6210\u529f\u7684\u6587\u4ef6\u8bbf\u95ee\u8def\u5f84");
        HttpMethods.Param param = new HttpMethods.Param("file", QEnum.QType.FILE);
        param.title = "\u6587\u4ef6";
        param.length = -1;
        quri.addParam(param);
        QApi.putQUri((QApi.QUri)quri);
    }
}

