/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service;

import bee.cloud.core.Bee;
import bee.cloud.service.base.work.Work;
import bee.cloud.service.controller.CacheController;
import bee.cloud.service.controller.PublicController;
import bee.cloud.service.controller.RmiapiController;
import bee.cloud.service.controller.UrisController;
import bee.cloud.service.filter.BeeFilter;
import bee.tool.Tool;
import bee.tool.string.Format;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;

@ComponentScan(basePackages={"bee.cloud.**", "bee.service.**"})
public class BeeApplication {
    private static Class<?> esFeignService;

    public static ConfigurableApplicationContext run(String[] args) {
        String path;
        String metapath;
        StackTraceElement[] stacks;
        Work.setStartTime((long)System.currentTimeMillis());
        Class<?> primaryClass = null;
        StackTraceElement[] stackTraceElementArray = stacks = Thread.currentThread().getStackTrace();
        int n = stacks.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement stack = stackTraceElementArray[n2];
            String name = stack.getClassName();
            if (!"java.lang.Thread".equals(name)) {
                try {
                    Class<?> clz = Class.forName(stack.getClassName());
                    Work.clazzs.add(clz);
                    Work.pkgs.add(clz.getPackage().getName());
                    primaryClass = clz;
                }
                catch (Exception clz) {
                    // empty catch block
                }
            }
            ++n2;
        }
        if (primaryClass != null) {
            Work.clazzs.remove(primaryClass);
            Work.clazzs.add(0, primaryClass);
        }
        if (Format.noEmpty((Object)(metapath = BeeApplication.toMetaPath(path = primaryClass.getProtectionDomain().getCodeSource().getLocation().getPath())))) {
            System.setProperty("config.metapath", metapath);
        }
        try {
            Class<?> clz = Class.forName("bee.service.config.NacosClient");
            Work.clazzs.add(clz);
            Work.pkgs.add(clz.getPackage().getName());
        }
        catch (Exception clz) {
            // empty catch block
        }
        Work.clazzs.add(BeeApplication.class);
        String pkg = BeeApplication.class.getPackage().getName();
        Work.pkgs.add(pkg);
        SpringApplication root = new SpringApplication(new Class[]{BeeApplication.class});
        Work.clazzs.add(BeeFilter.class);
        Work.clazzs.add(PublicController.class);
        Work.clazzs.add(UrisController.class);
        Work.clazzs.add(RmiapiController.class);
        Work.clazzs.add(CacheController.class);
        root.addPrimarySources((Collection)Work.clazzs);
        root.setSources(Work.pkgs);
        ConfigurableApplicationContext ctx = root.run(args);
        ComponentScan scan = primaryClass.getAnnotation(ComponentScan.class);
        if (scan != null) {
            String pck;
            String[] stringArray = scan.value();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                pck = stringArray[n4];
                Work.pkgs.add(pck.replace(".**", "").replace(".*", ""));
                ++n4;
            }
            stringArray = scan.basePackages();
            n3 = stringArray.length;
            n4 = 0;
            while (n4 < n3) {
                pck = stringArray[n4];
                Work.pkgs.add(pck.replace(".**", "").replace(".*", ""));
                ++n4;
            }
        }
        Work.init((ApplicationContext)ctx);
        return ctx;
    }

    public static void setEsFeignService(Class<?> service) {
        esFeignService = service;
    }

    public static Class<?> getEsFeignService() {
        return esFeignService;
    }

    private static String toMetaPath(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        String metapath = String.valueOf(file.getParent()) + File.separator + "META-INF";
        File metafile = new File(metapath);
        if (metafile.exists()) {
            return String.valueOf(metapath) + File.separator;
        }
        return BeeApplication.toMetaPath(file.getParent());
    }

    public static void addSources(Class<?> sources) {
        Work.clazzs.add(sources);
    }

    public static void addSources(String packageName) {
        Work.pkgs.add(packageName);
    }

    private static void started() {
        InputStream is = BeeApplication.class.getResourceAsStream("bee.logo");
        StringBuffer readFile = Tool.FileOperate.readFile((InputStream)is);
        System.out.println(readFile);
        Bee.started();
    }

    public static <T extends Work.WInit> void addBinit(Class<T> binit) {
        Work.binits.add(binit);
    }

    public static void main(String[] args) {
        BeeApplication.started();
    }
}

