/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.work;

import bee.cloud.engine.db.core.CBase;
import bee.cloud.service.bean.ExportTitle;
import bee.tool.Tool;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExportXls {
    public static final String SERIAL = "serial";
    private int serial = 0;
    private ExportTitle exportTitle;
    private List<ExportTitle.Title> titles;
    private OutputStream out;
    private XSSFWorkbook workbook = new XSSFWorkbook();
    private XSSFSheet sheet = this.workbook.createSheet();
    private XSSFRow row;

    public ExportXls(ExportTitle exportTitle, OutputStream out) {
        this.exportTitle = exportTitle;
        this.out = out;
        this.titles = exportTitle.getTitles();
        Collections.sort(this.titles, new Comparator<ExportTitle.Title>(){

            @Override
            public int compare(ExportTitle.Title o1, ExportTitle.Title o2) {
                return o1.getOrder() - o2.getOrder();
            }
        });
        this.initHeader();
    }

    private void initHeader() {
        this.row = this.sheet.createRow(0);
        int i = 0;
        for (ExportTitle.Title title : this.titles) {
            this.row.createCell(i++).setCellValue(title.getTitle());
        }
    }

    public <T extends CBase> void export(List<T> list) {
        for (CBase t : list) {
            int i = 0;
            ++this.serial;
            this.row = this.sheet.createRow(this.serial);
            for (ExportTitle.Title title : this.titles) {
                String value;
                if (SERIAL.equals(title.getName())) {
                    this.row.createCell(i++).setCellValue((double)this.serial);
                    continue;
                }
                Object tmp = t.get(title.getName());
                String string = value = tmp == null ? "" : Tool.Format.format((Object)tmp, null).toString();
                if (Tool.Format.noEmpty((Object)title.getTuomin())) {
                    value = Tool.tuomin((String)value, (String)title.getTuomin());
                }
                this.row.createCell(i++).setCellValue(value);
            }
        }
    }

    public void done() {
        try {
            this.workbook.write(this.out);
            this.workbook.close();
            System.out.println("\u6570\u636e\u5bfc\u51fa\u5b8c\u6210");
        }
        catch (IOException e) {
            Tool.Log.error((Throwable)e);
        }
    }
}

