/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.work;

import bee.cloud.config.tool.Dict;
import bee.cloud.core.Bee;
import bee.cloud.core.db.RequestParam;
import bee.cloud.core.db.work.After;
import bee.cloud.core.db.work.VSql;
import bee.cloud.engine.config.sqlmap.QEnum;
import bee.cloud.engine.config.sqlmap.QTable;
import bee.cloud.engine.db.annotation.BWork;
import bee.cloud.engine.db.core.CBase;
import bee.cloud.engine.util.Result;
import bee.cloud.service.bean.ExportTitle;
import bee.cloud.service.work.ExportXls;
import bee.tool.Tool;
import bee.tool.err.BeeException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

@BWork(func={QEnum.Func.QUERY}, path={"*/@export"}, order=0x7FFFFFFF)
public class ExportAfter
implements After {
    public boolean go(Result result, RequestParam params) {
        List tables = result.getTables();
        if (tables == null || tables.isEmpty()) {
            Tool.Log.warn((String)"\u65e0\u6570\u636e\u53ef\u5bfc\u51fa\uff01");
            return false;
        }
        QTable qTable = result.getOperator().getQTable();
        ExportTitle exportTitle = (ExportTitle)result.getBean(ExportTitle.class);
        if (exportTitle == null) {
            if (exportTitle == null) {
                exportTitle = new ExportTitle();
                exportTitle.setFileName(String.valueOf(Tool.Format.formatDate((Date)new Date(System.currentTimeMillis()), (String)"yyyy-MM-dd HH:mm:ss")) + ".xls");
            }
            Map fields = qTable.getFields();
            int i = 0;
            for (Map.Entry entry : fields.entrySet()) {
                ExportTitle.Title title = new ExportTitle.Title();
                title.setName((String)entry.getKey());
                title.setTitle(((QTable.QField)entry.getValue()).title);
                title.setOrder(i++);
                exportTitle.addTitle(title);
            }
        }
        this.export(result, exportTitle);
        return true;
    }

    private List<CBase> getNextPageData(Result result) {
        RequestParam rparam = result.getOperator().getRparam();
        int pageno = rparam.asInt("pageno", 1);
        rparam.put("pageno", pageno + 1);
        VSql vsql = result.getOperator().getQTable().build(QEnum.Func.QUERY, rparam);
        List list = result.getOperator().getSql().query(vsql);
        return list;
    }

    private void export(Result result, ExportTitle exportTitle) {
        Bee.Resreq resreq = Bee.getResreq();
        HttpServletResponse response = resreq.getHttpServletResponse();
        String lastFileName = exportTitle.getFileName();
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/vnd.ms-excel;charset=UTF-8");
        try {
            response.setHeader("Content-Disposition", "attachment; filename=" + lastFileName);
            ServletOutputStream out = response.getOutputStream();
            ExportXls ex = new ExportXls(exportTitle, (OutputStream)out);
            List<CBase> list = result.getTables();
            ex.export(list);
            while ((list = this.getNextPageData(result)) != null && !list.isEmpty()) {
                ex.export(list);
            }
            ex.done();
            out.flush();
            out.close();
        }
        catch (Exception e) {
            throw new BeeException((Throwable)e);
        }
    }

    private StringBuilder export1(Result result, ExportTitle exportTitle) {
        List<ExportTitle.Title> titles = exportTitle.getTitles();
        Collections.sort(titles, new Comparator<ExportTitle.Title>(){

            @Override
            public int compare(ExportTitle.Title o1, ExportTitle.Title o2) {
                return o2.getOrder() - o1.getOrder();
            }
        });
        StringBuilder sb = new StringBuilder();
        for (ExportTitle.Title title : titles) {
            sb.append(title.getTitle().trim()).append(",");
        }
        sb.append("\r\n");
        QTable qTable = result.getOperator().getQTable();
        List tables = result.getTables();
        for (CBase tb : tables) {
            for (ExportTitle.Title title : titles) {
                Dict dict;
                Object value = tb.get(title.getName());
                if (value == null) {
                    value = "";
                }
                QTable.QField field = qTable.getField(title.getName());
                if (field.dic != null && (dict = Dict.get((String)field.dic)) != null) {
                    List items = dict.getItems();
                    for (Dict.Item item : items) {
                        if (!item.getValue().equals(value.toString())) continue;
                        value = item.getName();
                    }
                }
                sb.append(value).append(",");
            }
            sb.append("\r\n");
        }
        return sb;
    }
}

