/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.web.api;

import bee.tool.Tool;
import bee.tool.file.FileOperate;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.regex.Matcher;

public class WebApi {
    private static String ROOT_PATH;

    static {
        WebApi.initRootPath();
    }

    public static String getRootPath() {
        return ROOT_PATH;
    }

    private static void initRootPath() {
        URL url = WebApi.class.getResource("");
        if (url.getFile().indexOf("jar!") > 0) {
            String path = url.getPath();
            Tool.Log.info((String)"WebApi:{}", (Object[])new Object[]{path});
            if (path.startsWith("file:")) {
                path = path.substring(6);
            }
            ROOT_PATH = String.valueOf(path.substring(0, path.indexOf("jar!") + 4)) + "/META-INF/web";
        } else {
            String path = url.getPath();
            path = path.substring(1, path.lastIndexOf("/target/classes"));
            ROOT_PATH = String.valueOf(path) + "/src/main/resources/web";
        }
        Tool.Log.info((String)"$API:{}", (Object[])new Object[]{ROOT_PATH});
    }

    public static String getContent(String uri) {
        StringBuffer readFile;
        File file = new File(String.valueOf(ROOT_PATH) + uri);
        if (ROOT_PATH.indexOf("jar!") > 0) {
            InputStream is = WebApi.class.getResourceAsStream("/META-INF/web" + uri);
            readFile = FileOperate.readFile((InputStream)is);
        } else {
            readFile = FileOperate.readFile((File)file);
        }
        if (uri.endsWith(".shtml")) {
            Matcher matcher = Tool.Html.INCLUDE_PATTERN.matcher(readFile.toString());
            while (matcher.find()) {
                String group = matcher.group(2);
                String cont = matcher.group(3);
                String[] tmp = cont.split("=");
                String path = tmp[1].trim().replace("\"", "");
                String shtml = WebApi.getContent(path);
                String tmpShtml = readFile.toString().replace(group, shtml);
                readFile.setLength(0);
                readFile.append(tmpShtml);
                matcher = Tool.Html.INCLUDE_PATTERN.matcher(readFile.toString());
            }
        }
        return readFile.toString();
    }

    public static byte[] getBytes(String uri) {
        if (ROOT_PATH.indexOf("jar!") > 0) {
            InputStream is = WebApi.class.getResourceAsStream("/META-INF/web" + uri);
            byte[] bytes = FileOperate.readBytes((InputStream)is);
            return bytes;
        }
        File file = new File(String.valueOf(ROOT_PATH) + uri);
        return FileOperate.readBytes((File)file);
    }
}

