/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.filter;

import bee.cloud.config.BConfig;
import bee.cloud.core.Bee;
import bee.cloud.core.db.RequestParam;
import bee.cloud.engine.config.HttpMethods;
import bee.cloud.engine.config.sqlmap.QApi;
import bee.cloud.engine.config.sqlmap.QEnum;
import bee.tool.Tool;
import bee.tool.err.BeeException;
import bee.tool.string.Format;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class BeeHandlerInterceptorAdapter
extends HandlerInterceptorAdapter {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        RequestParam param = Bee.getRequestParam();
        Map attrs = (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
        if (param != null && attrs != null && !attrs.isEmpty()) {
            attrs.forEach((k, v) -> {
                String value = this.checkParam((String)k, v.trim(), param);
                if (!v.trim().equals(value)) {
                    attrs.put(k, value);
                }
                requestParam.uri.put(k, value);
            });
        }
        return super.preHandle(request, response, handler);
    }

    public HttpMethods.Param toParam(String name, String uri) {
        QApi.HApi api = QApi.getApi((String)uri);
        if (api == null) {
            return null;
        }
        HttpMethods.Param param = api.getParam(name);
        return param;
    }

    private String checkParam(String name, String value, RequestParam rparam) {
        if (Format.isEmpty((String)value)) {
            return value;
        }
        HttpMethods.Param param = this.toParam(name, rparam.getUri());
        if (name.length() > 3 && name.endsWith("_id") || param != null && param.pk) {
            Set set = Format.strToSet((String)value);
            if (value.indexOf("O") >= 0) {
                for (String id : set) {
                    if (49 != id.length()) {
                        throw new BeeException(800001);
                    }
                    value = value.replace(id, "" + Tool.Security.decryptLong((String)id));
                }
            } else if (value.indexOf("L") >= 0) {
                for (String id : set) {
                    if ((id.length() - 1) % 16 != 0) {
                        throw new BeeException(800001);
                    }
                    String token = Tool.Value.toSingle((String[])new String[]{rparam.cookie.get("token"), rparam.header.get("token")});
                    String ov = Tool.Security.decrypt((String)id, (String)token);
                    if (ov == null) {
                        throw new BeeException("\u975e\u6cd5\u4f7f\u7528\u6570\u636e[%s=%s]!", new Object[]{name, id});
                    }
                    value = value.replace(id, ov);
                }
            } else {
                if (param != null && QEnum.QType.CHARACTER.equals((Object)param.type) && value.trim().length() < 32) {
                    return value;
                }
                if (param != null && param.type.isNumber() && Tool.Format.strToLong((String)value) < 0L) {
                    return value;
                }
                if (BConfig.OutConst.isEncryptPK((String)name)) {
                    throw new BeeException(800001);
                }
            }
        }
        return value;
    }
}

