/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.controller;

import bee.cloud.config.BConfig;
import bee.cloud.config.tool.Dict;
import bee.cloud.core.Bee;
import bee.cloud.core.db.RequestParam;
import bee.cloud.service.core.annotation.API;
import bee.cloud.service.core.annotation.ApiParam;
import bee.cloud.service.core.result.Results;
import bee.cloud.service.core.util.TokenUtil;
import bee.tool.RuntimeTool;
import bee.tool.Tool;
import bee.tool.err.BeeException;
import bee.tool.string.RSA;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
public class SystemController {
    private static final String _ED_CLASS = "46Hd9s1E2sz3A411XyKANH1890hCA3pgcRGrnatMkx9y4mep+M=";

    @API(title="\u83b7\u53d6\u6240\u6709\u6570\u636e\u5b57\u5178\u6570\u636e")
    @GetMapping(value={"/@dict"}, produces={"application/json"})
    public Results getDict(HttpServletResponse response, HttpServletRequest request) {
        Results results = new Results();
        String codes = request.getParameter("code");
        if (Tool.Format.isEmpty((String)codes)) {
            results.succeed((Object)Dict.toMaps());
        } else {
            HashMap<String, Map> map = new HashMap<String, Map>();
            String[] stringArray = codes.split(",|\uff0c");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String code = stringArray[n2];
                Dict dict = Dict.get((String)code.trim());
                map.put(code.trim(), dict != null ? dict.toMap() : null);
                ++n2;
            }
            results.succeed(map);
        }
        return results;
    }

    @API(title="\u83b7\u53d6\u5355\u4e2a\u6570\u636e\u5b57\u5178\u6570\u636e", param={@ApiParam(name="code", title="\u5b57\u5178\u4ee3\u7801", required=true, memo="\u5b57\u5178\u7684Code")})
    @GetMapping(value={"/@dict/{code:.+}"}, produces={"application/json"})
    public @ApiParam(name="code", title="\u5b57\u5178\u4ee3\u7801", required=true, memo="\u5b57\u5178\u7684Code") Map<String, Object> getDict(@PathVariable(value="code") String code) {
        Dict dict = Dict.get((String)code.trim());
        return dict != null ? dict.toMap() : null;
    }

    @API(title="\u6839\u636e\u63d0\u4f9b\u7684\u4ee3\u7801\u83b7\u53d6\u5bf9\u79f0\u52a0\u5bc6\u7684\u516c\u94a5", memo="\u63d0\u4f9b\u7ed9\u654f\u611f\u6570\u636e\u9700\u8981\u52a0\u5bc6\u4f20\u8f93\u7684\u52a0\u5bc6\u5bc6\u94a5\u3002")
    @PostMapping(value={"/rsa/pubkey"}, produces={"application/json"})
    public Results getRsaPubKey() {
        String code = Tool.getUUID();
        Results results = new Results();
        RSA.Key key = RSA.generateKey();
        results.put("pubkey", (Object)key.publicKey.toString());
        results.put("rsa_key_code", (Object)code);
        results.put("status", (Object)200);
        if (!TokenUtil.savePriKey((String)code, (String)key.privateKey.toString())) {
            throw new BeeException("\u5f53\u524d\u670d\u52a1\u5668\u4e0d\u652f\u6301\u8be5\u4e1a\u52a1\uff01");
        }
        Bee.Cookie cookie = new Bee.Cookie("rsa_key_code", code);
        Bee.getResreq().setCookie(cookie);
        return results;
    }

    @API(title="\u83b7\u53d6RSA\u5bc6\u94a5\u5bf9", memo="\u751f\u6210\u4e00\u5bf9\u5bc6\u94a5\uff08\u516c\u94a5\u4e0e\u79c1\u94a5\uff09\u3002")
    @PostMapping(value={"/rsa/key"}, produces={"application/json"})
    public Results getRsaKey() {
        Results results = new Results();
        RSA.Key key = RSA.generateKey();
        results.put("pubkey", (Object)key.publicKey.toString());
        results.put("prikey", (Object)key.privateKey.toString());
        results.put("status", (Object)200);
        return results;
    }

    @GetMapping(value={"/info"}, produces={"application/json"})
    public Object getSystem() {
        return RuntimeTool.getInfos();
    }

    @PostMapping(value={"/edstr/{code}"}, produces={"application/json"})
    public Results \u52a0\u5bc6\u89e3\u5bc6(@PathVariable(value="code") String code) {
        Results results = new Results();
        RequestParam param = Bee.getRequestParam();
        if ("md5".equals(code = code.trim().toLowerCase())) {
            results.succeed((Object)Tool.MD5.encode((String)param.asText("content").trim()));
        } else {
            Object val = Tool.callMethod((String)_ED_CLASS, (String)code, (Object[])new Object[]{param.asText("content").trim(), param.asText("key").trim()});
            if (val == null) {
                results.error((Object)"\u5bc6\u94a5\u4e0d\u6b63\u786e\uff01");
            } else {
                results.succeed(val);
            }
        }
        return results;
    }

    @PostMapping(value={"/@api/login"}, produces={"application/json"})
    public Results \u767b\u5f55API() {
        RequestParam param = Bee.getRequestParam();
        String username = param.asText("username");
        String password = param.asText("password");
        if (Tool.Format.isEmptys((String[])new String[]{username, password})) {
            throw new BeeException("\u7528\u6237\u540d\u4e0e\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (!Tool.MD5.encode((String)password).equals(BConfig.asText((String)"api.user.{username}".replace("{username}", username)))) {
            throw new BeeException("\u7528\u6237\u540d\u4e0e\u5bc6\u7801\u4e0d\u6b63\u786e\u3002");
        }
        String ip = param.header.getIP();
        String agent = param.header.getAgent();
        String edata = Tool.Encrypt.encodeEx((String)Tool.MD5.encode((String)(String.valueOf(ip) + agent)));
        Bee.getResreq().setCookie("devtoken", edata);
        Results results = new Results();
        results.succeed((Object)"ok");
        return results;
    }
}

