/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.controller;

import bee.cloud.core.db.DBE;
import bee.cloud.core.db.RequestParam;
import bee.cloud.core.db.RmiData;
import bee.cloud.engine.config.sqlmap.QApi;
import bee.cloud.engine.util.Result;
import bee.tool.Tool;
import bee.tool.err.BeeException;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
public class RmiapiController {
    @PostMapping(value={"/remote/call"}, produces={"application/json"})
    public RmiData springcloud(@RequestBody RmiData rdata) {
        RequestParam data = new RequestParam(rdata);
        try {
            Tool.Log.info((String)data.getUri());
            DBE.Param param = new DBE.Param(data.getUri(), data);
            Result result = DBE.execute((DBE.Param)param);
            RmiData res = new RmiData();
            res.setData(Tool.objectToBytes((Object)result));
            return res;
        }
        catch (BeeException e) {
            e.setOther((Object)data);
            throw e;
        }
    }

    @ResponseBody
    @PostMapping(value={"/remote/api"})
    public Result remoteApi(HttpServletResponse response, HttpServletRequest request, @RequestBody RmiData rdata) {
        RequestParam data = new RequestParam(rdata);
        try {
            String uri = data.getUri();
            QApi.HApi api = QApi.getApi((String)uri);
            if (api.getObject() == null) {
                try {
                    request.getRequestDispatcher(uri).forward((ServletRequest)request, (ServletResponse)response);
                }
                catch (IOException | ServletException e) {
                    e.printStackTrace();
                }
            }
            Tool.Log.info((String)uri);
            DBE.Param param = new DBE.Param(data.getUri(), data);
            Result result = DBE.execute((DBE.Param)param);
            return result;
        }
        catch (BeeException e) {
            e.setOther((Object)data);
            throw e;
        }
    }
}

