/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.controller;

import bee.cloud.core.Bee;
import bee.cloud.core.db.Import;
import bee.cloud.core.db.ImportXLS;
import bee.cloud.engine.config.sqlmap.QApi;
import bee.cloud.engine.config.sqlmap.QTable;
import bee.cloud.service.core.result.Results;
import bee.cloud.service.filter.Delay;
import bee.tool.Tool;
import bee.tool.err.BeeException;
import bee.tool.file.FileItem;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

public abstract class Controller {
    @Delay
    @RequestMapping(value={"", "/{item1}", "/{item1}/{item2}", "/{item1}/{item2}/{item3}", "/{item1}/{item2}/{item3}/{item4}", "/{item1}/{item2}/{item3}/{item4}/{item5}", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}/{item8}", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}/{item8}/{item9}", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}/{item8}/{item9}/{item10}"}, produces={"application/json"}, method={RequestMethod.POST, RequestMethod.GET, RequestMethod.PUT, RequestMethod.DELETE})
    public Results item(HttpServletResponse response, HttpServletRequest request) {
        return this.execute(response, request);
    }

    @PostMapping(value={"/**/@import"}, consumes={"multipart/form-data"})
    public Results importData(@RequestPart(name="file", required=false) MultipartFile file, HttpServletRequest request) {
        if (file == null) {
            throw new BeeException("\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u5165\u7684\u6587\u4ef6\uff01");
        }
        Results results = new Results();
        try {
            String contextPath = request.getContextPath();
            String uri = Tool.urlDecode((String)request.getRequestURI(), (String)request.getCharacterEncoding());
            uri = uri.substring(contextPath.length() + 1);
            uri = uri.replace("\u2019", "'");
            QTable qTable = QApi.getQTable((String)uri);
            if (qTable == null) {
                throw new BeeException("\u5f53\u524d\u63a5\u53e3\u4e0d\u652f\u6301\u5bfc\u5165\u529f\u80fd\uff01");
            }
            Import.Info info = ImportXLS.importData((InputStream)file.getInputStream(), (QTable)qTable);
            results.succeed((Object)info);
        }
        catch (IOException e) {
            Import.Info info = new Import.Info();
            info.setSign(9);
            info.setInfo(e.getMessage());
            results.error((Object)info);
        }
        return results;
    }

    @GetMapping(value={"/**/@import"}, consumes={"application/json"})
    public Results importDataInfo() {
        String id = Bee.getRequestParam().asText("id");
        Results results = new Results();
        Import.Info info = ImportXLS.getInfo((String)id);
        results.succeed((Object)info);
        return results;
    }

    @PutMapping(value={"/**/@import"}, consumes={"application/json"})
    public Results cancelDataInfo() {
        String id = Bee.getRequestParam().asText("id");
        Results results = new Results();
        Import.Info info = ImportXLS.cancelData((String)id);
        results.succeed((Object)(info == null ? "\u4efb\u52a1\u4e0d\u5b58\u5728\uff1a" + id : info));
        return results;
    }

    protected abstract Results execute(HttpServletResponse var1, HttpServletRequest var2);

    private FileItem uploadFile(MultipartFile file) {
        FileItem fileItem = new FileItem();
        try {
            fileItem.setName(file.getOriginalFilename());
            fileItem.setType(fileItem.getName().substring(fileItem.getName().lastIndexOf(".") + 1));
            fileItem.setSize(file.getSize());
            fileItem.setContentType(file.getContentType());
            fileItem.setInputStream(Tool.cloneInputStream((InputStream)file.getInputStream()));
            fileItem.setInfo("\u4e0a\u4f20\u6210\u529f");
        }
        catch (IOException e) {
            Tool.Log.error((Throwable)e);
            fileItem.setInfo("\u4e0a\u4f20\u5931\u8d25\uff1a" + e.getMessage());
            fileItem.setStatus(false);
        }
        return fileItem;
    }
}

