/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.controller;

import bee.cloud.cache.Cache;
import bee.cloud.cache.TBCache;
import bee.cloud.cache.redis.Cedis;
import bee.cloud.cache.redis.Config;
import bee.cloud.cache.redis.Pools;
import bee.cloud.cache.redis.SuperCache;
import bee.cloud.config.tool.Dict;
import bee.cloud.core.Bee;
import bee.cloud.core.db.RequestParam;
import bee.cloud.engine.config.HttpMethods;
import bee.cloud.engine.config.sqlmap.QApi;
import bee.cloud.engine.config.sqlmap.QEnum;
import bee.cloud.engine.config.sqlmap.QTable;
import bee.cloud.service.core.HttpParam;
import bee.cloud.service.core.ShowApi;
import bee.cloud.service.core.annotation.API;
import bee.cloud.service.core.annotation.ApiParam;
import bee.cloud.service.core.result.Results;
import bee.tool.RuntimeTool;
import bee.tool.Tool;
import bee.tool.err.BeeException;
import bee.tool.string.Format;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import redis.clients.jedis.Jedis;

@RestController
@ControllerAdvice
@RequestMapping(value={"/cache"})
public class CacheController
extends ShowApi {
    public boolean isShow() {
        return Tool.Format.strToBoolean((String)System.getProperty("initCacheUrl"), (Boolean)(Pools.length() > 0 ? 1 : 0));
    }

    @API(title="\u521d\u59cb\u5316\u7f13\u5b58", param={@ApiParam(name="_path", title="\u7f13\u5b58\u8868\u683c\u8def\u5f84", required=true, memo="\u9700\u8981\u4f20\u7f13\u5b58\u5bf9\u5e94\u7684path\uff0c\u53c2\u6570\u4e3a_path\uff0c\u591a\u4e2apath\u95f4\u7528\u5206\u53f7\u9694\u5f00\u3002\u5982\u679c\u7f13\u5b58\u4e2d\u5b58\u5728\u6570\u636e\u5219\u66f4\u65b0\uff0c\u4e0d\u5b58\u5728\u5219\u52a0\u5165\uff0c\u591a\u4f59\u6570\u636e\u5219\u5220\u9664"), @ApiParam(name="full_update", title="\u662f\u5426\u5168\u91cf\u66f4\u65b0", memo="\u9ed8\u8ba4\u4e3afalse-\u589e\u91cf\u5f0f\u66f4\u65b0\uff0c\u5982\u679c\u4e3atrue\u65f6\u5148\u6e05\u9664\u7f13\u5b58\u4e2d\u7684\u6570\u636e\uff0c\u518d\u4ece\u6570\u636e\u5e93\u8868\u4e2d\u91cd\u65b0\u540c\u6b65\u6570\u636e\u5230\u7f13\u5b58\u4e2d\u3002")})
    @GetMapping(value={"/init"})
    public @ApiParam(name="_path", title="\u7f13\u5b58\u8868\u683c\u8def\u5f84", required=true, memo="\u9700\u8981\u4f20\u7f13\u5b58\u5bf9\u5e94\u7684path\uff0c\u53c2\u6570\u4e3a_path\uff0c\u591a\u4e2apath\u95f4\u7528\u5206\u53f7\u9694\u5f00\u3002\u5982\u679c\u7f13\u5b58\u4e2d\u5b58\u5728\u6570\u636e\u5219\u66f4\u65b0\uff0c\u4e0d\u5b58\u5728\u5219\u52a0\u5165\uff0c\u591a\u4f59\u6570\u636e\u5219\u5220\u9664") @ApiParam(name="full_update", title="\u662f\u5426\u5168\u91cf\u66f4\u65b0", memo="\u9ed8\u8ba4\u4e3afalse-\u589e\u91cf\u5f0f\u66f4\u65b0\uff0c\u5982\u679c\u4e3atrue\u65f6\u5148\u6e05\u9664\u7f13\u5b58\u4e2d\u7684\u6570\u636e\uff0c\u518d\u4ece\u6570\u636e\u5e93\u8868\u4e2d\u91cd\u65b0\u540c\u6b65\u6570\u636e\u5230\u7f13\u5b58\u4e2d\u3002") Results init(HttpServletResponse response, HttpServletRequest request) {
        HttpParam httpParam = new HttpParam(request);
        Results results = new Results();
        String[] paths = httpParam.getParam("_path").split(";|\uff1b|,|\uff0c");
        ArrayList list = new ArrayList();
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            HashMap<String, Object> map = new HashMap<String, Object>();
            list.add(map);
            map.put("path", path);
            QTable table = QApi.getQTable((String)path);
            if (table == null) {
                map.put("info", String.format("\u5730\u5740\u4e0d\u5b58\u5728\uff0c\u8bf7\u67e5\u8bc1\uff01", new Object[0]));
            } else {
                TBCache tbcache = TBCache.ins((QTable)table);
                if (tbcache != null) {
                    tbcache.update(httpParam.getRParam());
                }
                map.put("count", tbcache.getCount());
                map.put("state", tbcache.isRun());
                map.put("info", tbcache.getInfo());
            }
            ++n2;
        }
        results.succeed(list.size() > 1 ? list : list.get(0));
        return results;
    }

    @API(title="\u5237\u65b0\u6570\u636e\u5b57\u5178", memo="\u5f53\u5b57\u5178\u7f13\u5b58\u5185\u5bb9\u4e0e\u6570\u636e\u5e93\u4e0d\u540c\u6b65\u65f6\uff0c\u6267\u884c\u4e9b\u63a5\u53e3\u91cd\u65b0\u52a0\u8f7d\u7f13\u5b58\u6570\u636e\u5230\u5185\u5b58")
    @GetMapping(value={"/reflesh/dict"})
    public Results refleshDict() {
        Dict.reflesh();
        Results results = new Results();
        results.succeed((Object)RuntimeTool.getMAC());
        return results;
    }

    @GetMapping(value={"/info"})
    public Results gets(HttpServletRequest request) {
        Results results = new Results();
        boolean c = Format.strToBoolean((String)request.getParameter("c"), (Boolean)false);
        boolean s = Format.strToBoolean((String)request.getParameter("s"), (Boolean)false);
        List apis = HttpMethods.getApis((boolean)c, (boolean)s, (HttpMethods.AType)HttpMethods.AType.CACHE);
        results.succeed((Object)apis);
        return results;
    }

    @API(title="\u83b7\u53d6Redis\u7f13\u5b58\u4e2d\u7684KEY\u96c6\u5408", param={@ApiParam(name="group", title="\u7f13\u5b58\u5206\u7ec4\u540d\u79f0", memo="cache\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684\u5b9a\u4e49\u3002"), @ApiParam(name="cursor", title="\u6e38\u6807\u503c", memo="\u9996\u6b21\u67e5\u8be2\u9ed8\u8ba4\u4e3a0\uff0c\u63a5\u53e3\u4f1a\u8fd4\u56de\u65b0\u7684\u6e38\u6807\u503c\u3002"), @ApiParam(name="count", title="\u6279\u6b21\u91cf", memo="\u6bcf\u6b21\u6240\u53d6\u7684\u6570\u91cf\uff0c\u9ed8\u8ba4\u4e3a10000\u6761\u3002"), @ApiParam(name="pattern", title="\u7f13\u5b58KEY\u8868\u8fbe\u5f0f")})
    @GetMapping(value={"/keys"})
    public @ApiParam(name="group", title="\u7f13\u5b58\u5206\u7ec4\u540d\u79f0", memo="cache\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684\u5b9a\u4e49\u3002") @ApiParam(name="cursor", title="\u6e38\u6807\u503c", memo="\u9996\u6b21\u67e5\u8be2\u9ed8\u8ba4\u4e3a0\uff0c\u63a5\u53e3\u4f1a\u8fd4\u56de\u65b0\u7684\u6e38\u6807\u503c\u3002") @ApiParam(name="count", title="\u6279\u6b21\u91cf", memo="\u6bcf\u6b21\u6240\u53d6\u7684\u6570\u91cf\uff0c\u9ed8\u8ba4\u4e3a10000\u6761\u3002") @ApiParam(name="pattern", title="\u7f13\u5b58KEY\u8868\u8fbe\u5f0f") Results getKeys() {
        Results results = new Results();
        RequestParam param = Bee.getRequestParam();
        String group = param.asText("group");
        if (Tool.Format.isEmpty((String)group)) {
            throw new BeeException("\u7f13\u5b58\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Cache cache = Bee.getCache((String)group);
        if (cache == null) {
            throw new BeeException("\u7f13\u5b58\u5206\u7ec4[{}]\u4e0d\u80fd\u5b58\u5728\uff01", new Object[]{group});
        }
        int cursor = param.asInt("cursor", 0);
        int count = param.asInt("count", 10000);
        String pattern = param.asText("pattern", "*");
        Cache.Scan keys = cache.keys(pattern, (long)cursor, count);
        Set value = (Set)keys.getValue();
        results.put("cursor", (Object)keys.getCursor());
        results.put("size", (Object)value.size());
        results.succeed((Object)value);
        return results;
    }

    @API(title="\u83b7\u53d6key\u5bf9\u5e94\u7684value", param={@ApiParam(name="group", title="\u7f13\u5b58\u5206\u7ec4\u540d\u79f0", memo="cache\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684\u5b9a\u4e49\u3002"), @ApiParam(name="key", title="\u7f13\u5b58key")})
    @GetMapping(value={"/value"})
    public @ApiParam(name="group", title="\u7f13\u5b58\u5206\u7ec4\u540d\u79f0", memo="cache\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684\u5b9a\u4e49\u3002") @ApiParam(name="key", title="\u7f13\u5b58key") Results getValue() {
        Results results = new Results();
        RequestParam param = Bee.getRequestParam();
        String group = param.asText("group");
        if (Tool.Format.isEmpty((String)group)) {
            throw new BeeException("\u7f13\u5b58\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Cache cache = Bee.getCache((String)group);
        if (cache == null) {
            throw new BeeException("\u7f13\u5b58\u5206\u7ec4[{}]\u4e0d\u80fd\u5b58\u5728\uff01", new Object[]{group});
        }
        try {
            String key = param.asText("key");
            if (Tool.Format.isEmpty((String)key)) {
                throw new BeeException("\u7f13\u5b58Key\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            String type = cache.type(key = key.trim());
            if ("string".equalsIgnoreCase(type)) {
                results.succeed(this.toValue(cache.get(key)));
            } else if ("hash".equalsIgnoreCase(type)) {
                Map map = cache.hgetAll(key);
                if (Tool.Format.isEmpty((Object)map)) {
                    results.succeed((Object)map);
                } else {
                    HashMap<String, Object> _map = new HashMap<String, Object>();
                    for (Map.Entry entry : map.entrySet()) {
                        Object o = this.toValue((String)entry.getValue());
                        if (Tool.Format.isEmpty((Object)o)) continue;
                        _map.put((String)entry.getKey(), o);
                    }
                    map.clear();
                    results.succeed(_map);
                }
            } else if ("list".equalsIgnoreCase(type)) {
                List lrange = cache.getStack(key).lrange();
                if (Tool.Format.isEmpty((Object)lrange)) {
                    results.succeed((Object)lrange);
                } else {
                    ArrayList<Object> list = new ArrayList<Object>();
                    for (String v : lrange) {
                        Object o = this.toValue(v);
                        if (Tool.Format.isEmpty((Object)o)) continue;
                        list.add(o);
                    }
                    lrange.clear();
                    results.succeed(list);
                }
            } else if ("set".equalsIgnoreCase(type)) {
                results.succeed((Object)cache.getRSet(key).get());
            } else if ("none".equals(type)) {
                results.succeed((Object)("key[" + key + "]\u4e0d\u5b58\u5728\uff01"));
            } else {
                results.succeed((Object)"zset\u672a\u5b9e\u73b0");
            }
            long ttl = cache.ttl(key);
            results.put("ttl", (Object)ttl);
            String type2 = cache.type(key);
            results.put("type", (Object)type2);
            Results results2 = results;
            return results2;
        }
        finally {
            cache.close();
        }
    }

    @API(title="\u83b7\u53d6\u7f13\u5b58\u5206\u7ec4")
    @GetMapping(value={"/groups"})
    public Results getGroup() {
        Results results = new Results();
        Set groups = Pools.getGroups();
        ArrayList<ObjectNode> list = new ArrayList<ObjectNode>();
        for (String group : groups) {
            if (Tool.Format.isEmpty((String)group)) continue;
            Config config = Pools.getConfig((String)group);
            ObjectNode json = (ObjectNode)Tool.Json.objToJson((Object)config);
            SuperCache cache = null;
            Cedis cedis = null;
            Jedis jedis = null;
            try {
                cache = (SuperCache)Bee.getCache((String)group);
                cedis = cache.getCedis();
                jedis = cedis.jedis();
                Long dbSize = jedis.dbSize();
                json.put("keys", dbSize);
                list.add(json);
            }
            catch (Throwable throwable) {
                if (jedis != null) {
                    jedis.close();
                }
                if (cedis != null) {
                    cedis.returnResource(jedis);
                }
                if (cache != null) {
                    cache.close();
                }
                throw throwable;
            }
            if (jedis != null) {
                jedis.close();
            }
            if (cedis != null) {
                cedis.returnResource(jedis);
            }
            if (cache == null) continue;
            cache.close();
        }
        results.succeed(list);
        return results;
    }

    @API(title="\u589e\u52a0\u7f13\u5b58", param={@ApiParam(name="group", title="\u7f13\u5b58\u5206\u7ec4", required=true), @ApiParam(name="key", title="\u7f13\u5b58KEY", required=true), @ApiParam(name="type", title="\u7f13\u5b58\u7c7b\u578b", memo="\u7f13\u5b58\u7c7b\u578b\u9ed8\u8ba4\u4e3a\uff1astring\uff0c[list,set,hash]"), @ApiParam(name="value", title="\u7f13\u5b58\u503c", memo="\u9664String\u7c7b\u578b\u5916\uff0c\u5176\u4ed6\u7c7b\u578b\u7528json\u683c\u5f0f"), @ApiParam(name="ttl", title="\u6709\u6548\u671f", memo="\u5355\u4f4d\u4e3a\u79d2\uff0c\u9ed8\u8ba4\u4e3a\u7a7a\uff0c\u6c38\u4e45\u6709\u6548", type=QEnum.QType.INTEGER)})
    @PostMapping(value={"/key"})
    public @ApiParam(name="group", title="\u7f13\u5b58\u5206\u7ec4", required=true) @ApiParam(name="key", title="\u7f13\u5b58KEY", required=true) @ApiParam(name="type", title="\u7f13\u5b58\u7c7b\u578b", memo="\u7f13\u5b58\u7c7b\u578b\u9ed8\u8ba4\u4e3a\uff1astring\uff0c[list,set,hash]") @ApiParam(name="value", title="\u7f13\u5b58\u503c", memo="\u9664String\u7c7b\u578b\u5916\uff0c\u5176\u4ed6\u7c7b\u578b\u7528json\u683c\u5f0f") @ApiParam(name="ttl", title="\u6709\u6548\u671f", memo="\u5355\u4f4d\u4e3a\u79d2\uff0c\u9ed8\u8ba4\u4e3a\u7a7a\uff0c\u6c38\u4e45\u6709\u6548", type=QEnum.QType.INTEGER) Results add() {
        Results results = new Results();
        RequestParam param = Bee.getRequestParam();
        String group = param.asText("group");
        if (Tool.Format.isEmpty((String)group)) {
            throw new BeeException("\u7f13\u5b58\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String key = param.asText("key");
        if (Tool.Format.isEmpty((String)key)) {
            throw new BeeException("\u7f13\u5b58KEY\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String type = param.asText("type", "string");
        if ("|string|list|set|hash|".indexOf("|" + type.trim().toLowerCase() + "|") < 0) {
            throw new BeeException("\u7f13\u5b58\u7c7b\u578b\u4e0d\u6b63\u786e\uff01");
        }
        String value = param.asText("value");
        if (Tool.Format.isEmpty((String)value)) {
            throw new BeeException("\u7f13\u5b58\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Cache cache = Bee.getCache((String)group);
        if (cache == null) {
            throw new BeeException("\u7f13\u5b58\u5206\u7ec4[{}]\u4e0d\u80fd\u5b58\u5728\uff01", new Object[]{group});
        }
        try {
            JsonNode json;
            if (type.equalsIgnoreCase("string")) {
                cache.set(key.trim(), value.trim());
            } else if (type.equalsIgnoreCase("list")) {
                json = Tool.Json.readTree((String)value.trim());
                if (json == null) {
                    cache.getStack(key.trim()).rpush((Object)value.trim());
                } else {
                    Cache.Stack stack = cache.getStack(key.trim());
                    ArrayList list = new ArrayList();
                    json.forEach(node -> {
                        boolean bl = list.add(node.asText());
                    });
                    stack.rpush(list);
                }
            } else if (type.equalsIgnoreCase("set")) {
                json = Tool.Json.readTree((String)value.trim());
                if (json == null) {
                    cache.getRSet(key.trim()).add(new String[]{value.trim()});
                } else {
                    HashSet list = new HashSet();
                    json.forEach(node -> {
                        boolean bl = list.add(node.asText());
                    });
                    cache.getRSet(key.trim()).add(list);
                }
            } else if (type.equalsIgnoreCase("hash")) {
                json = Tool.Json.readTree((String)value.trim());
                if (json == null) {
                    throw new BeeException("\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                }
                Iterator fields = json.fieldNames();
                HashMap<String, String> map = new HashMap<String, String>();
                while (fields.hasNext()) {
                    String name = (String)fields.next();
                    map.put(name, json.get(name).asText());
                }
                cache.hset(key.trim(), map);
            }
            int ttl = param.asInt("ttl");
            if (ttl > 0) {
                cache.expire(key.trim(), (long)ttl);
            }
            results.succeed((Object)true);
            Results results2 = results;
            return results2;
        }
        finally {
            cache.close();
        }
    }

    @API(title="\u5220\u9664\u7f13\u5b58", memo="\u652f\u6301\u6309\u524d\u7f00\u5220\u9664", param={@ApiParam(name="group", title="\u7f13\u5b58\u5206\u7ec4", required=true), @ApiParam(name="key", title="\u7f13\u5b58KEY", required=true, memo="\u5f53\u6709*\u53f7\u7ed3\u5c3e\u65f6\u8868\u793a\u6309\u524d\u7f00\u5220\u9664")})
    @DeleteMapping(value={"/key"})
    public @ApiParam(name="group", title="\u7f13\u5b58\u5206\u7ec4", required=true) @ApiParam(name="key", title="\u7f13\u5b58KEY", required=true, memo="\u5f53\u6709*\u53f7\u7ed3\u5c3e\u65f6\u8868\u793a\u6309\u524d\u7f00\u5220\u9664") Results deleteKey() {
        Results results = new Results();
        RequestParam param = Bee.getRequestParam();
        String group = param.asText("group");
        if (Tool.Format.isEmpty((String)group)) {
            throw new BeeException("\u7f13\u5b58\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Cache cache = Bee.getCache((String)group);
        if (cache == null) {
            throw new BeeException("\u7f13\u5b58\u5206\u7ec4[{}]\u4e0d\u80fd\u5b58\u5728\uff01", new Object[]{group});
        }
        try {
            String key = param.asText("key");
            if (Tool.Format.isEmpty((String)key)) {
                throw new BeeException("\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if ((key = key.trim()).equals("*")) {
                throw new BeeException("\u5371\u9669\u64cd\u4f5c\uff01");
            }
            if (key.endsWith("*")) {
                cache.dels(key);
            } else {
                cache.del(new String[]{key.trim()});
            }
            results.succeed((Object)true);
            Results results2 = results;
            return results2;
        }
        finally {
            cache.close();
        }
    }

    @API(title="\u589e\u52a0Hash\u7c7b\u578b\u7f13\u5b58\u5c5e\u6027", param={@ApiParam(name="group", title="\u7f13\u5b58\u5206\u7ec4", required=true), @ApiParam(name="key", title="\u7f13\u5b58KEY", required=true), @ApiParam(name="field", title="hash\u5c5e\u6027", required=true), @ApiParam(name="value", title="hash\u5c5e\u6027\u503c", required=true)})
    @PostMapping(value={"/field"})
    public @ApiParam(name="group", title="\u7f13\u5b58\u5206\u7ec4", required=true) @ApiParam(name="key", title="\u7f13\u5b58KEY", required=true) @ApiParam(name="field", title="hash\u5c5e\u6027", required=true) @ApiParam(name="value", title="hash\u5c5e\u6027\u503c", required=true) Results addField() {
        Results results = new Results();
        RequestParam param = Bee.getRequestParam();
        String group = param.asText("group");
        if (Tool.Format.isEmpty((String)group)) {
            throw new BeeException("\u7f13\u5b58\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String key = param.asText("key");
        if (Tool.Format.isEmpty((String)key)) {
            throw new BeeException("\u7f13\u5b58KEY\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String field = param.asText("field");
        if (Tool.Format.isEmpty((String)field)) {
            throw new BeeException("\u7f13\u5b58\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String value = param.asText("value");
        if (Tool.Format.isEmpty((String)value)) {
            throw new BeeException("\u7f13\u5b58\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Cache cache = Bee.getCache((String)group.trim());
        if (cache == null) {
            throw new BeeException("\u7f13\u5b58\u5206\u7ec4[{}]\u4e0d\u80fd\u5b58\u5728\uff01", new Object[]{group});
        }
        try {
            cache.hset(key.trim(), field.trim(), value.trim());
            results.succeed((Object)true);
            Results results2 = results;
            return results2;
        }
        finally {
            cache.close();
        }
    }

    @API(title="\u5220\u9664Hash\u7c7b\u578b\u7f13\u5b58", param={@ApiParam(name="group", title="\u7f13\u5b58\u5206\u7ec4", required=true), @ApiParam(name="key", title="\u7f13\u5b58KEY", required=true), @ApiParam(name="field", title="hash\u5c5e\u6027", memo="\u591a\u4e2a\u5c5e\u6027\u7528\u9017\u53f7\u9694\u5f00", required=true)})
    @DeleteMapping(value={"/field"})
    public @ApiParam(name="group", title="\u7f13\u5b58\u5206\u7ec4", required=true) @ApiParam(name="key", title="\u7f13\u5b58KEY", required=true) @ApiParam(name="field", title="hash\u5c5e\u6027", memo="\u591a\u4e2a\u5c5e\u6027\u7528\u9017\u53f7\u9694\u5f00", required=true) Results deleteField() {
        Results results = new Results();
        RequestParam param = Bee.getRequestParam();
        String group = param.asText("group");
        if (Tool.Format.isEmpty((String)group)) {
            throw new BeeException("\u7f13\u5b58\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String key = param.asText("key");
        if (Tool.Format.isEmpty((String)key)) {
            throw new BeeException("\u7f13\u5b58KEY\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String field = param.asText("field");
        if (Tool.Format.isEmpty((String)field)) {
            throw new BeeException("\u7f13\u5b58\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Cache cache = Bee.getCache((String)group.trim());
        if (cache == null) {
            throw new BeeException("\u7f13\u5b58\u5206\u7ec4[{}]\u4e0d\u80fd\u5b58\u5728\uff01", new Object[]{group});
        }
        try {
            cache.hdel(key, Tool.Format.strToSet((String)field));
            results.succeed((Object)true);
            Results results2 = results;
            return results2;
        }
        finally {
            cache.close();
        }
    }

    @API(title="\u589e\u52a0Set\u7c7b\u578b\u7f13\u5b58\u5143\u7d20", param={@ApiParam(name="group", title="\u7f13\u5b58\u5206\u7ec4", required=true), @ApiParam(name="key", title="\u7f13\u5b58KEY", required=true), @ApiParam(name="value", title="set\u5143\u7d20\u503c", required=true)})
    @PostMapping(value={"/set"})
    public @ApiParam(name="group", title="\u7f13\u5b58\u5206\u7ec4", required=true) @ApiParam(name="key", title="\u7f13\u5b58KEY", required=true) @ApiParam(name="value", title="set\u5143\u7d20\u503c", required=true) Results addSet() {
        Results results = new Results();
        RequestParam param = Bee.getRequestParam();
        String group = param.asText("group");
        if (Tool.Format.isEmpty((String)group)) {
            throw new BeeException("\u7f13\u5b58\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String key = param.asText("key");
        if (Tool.Format.isEmpty((String)key)) {
            throw new BeeException("\u7f13\u5b58KEY\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String value = param.asText("value");
        if (Tool.Format.isEmpty((String)value)) {
            throw new BeeException("\u7f13\u5b58\u5c5e\u6027\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Cache cache = Bee.getCache((String)group.trim());
        if (cache == null) {
            throw new BeeException("\u7f13\u5b58\u5206\u7ec4[{}]\u4e0d\u80fd\u5b58\u5728\uff01", new Object[]{group});
        }
        try {
            cache.getRSet(key.trim()).add(new String[]{value.trim()});
            results.succeed((Object)true);
            Results results2 = results;
            return results2;
        }
        finally {
            cache.close();
        }
    }

    @API(title="\u589e\u52a0List\u7c7b\u578b\u7f13\u5b58\u5143\u7d20", param={@ApiParam(name="group", title="\u7f13\u5b58\u5206\u7ec4", required=true), @ApiParam(name="key", title="\u7f13\u5b58KEY", required=true), @ApiParam(name="value", title="list\u5143\u7d20\u503c", required=true), @ApiParam(name="index", title="\u63d2\u5165\u4f4d\u7f6e", memo="\u63d2\u5165\u4f4d\u7f6e\uff0c\u9ed8\u8ba4\u4e3a0\uff0c\u63d2\u5165\u5230\u6700\u524d\u9762\uff0c-1\uff1a\u63d2\u5165\u5230\u6700\u540e\u8fb9")})
    @PostMapping(value={"/list"})
    public @ApiParam(name="group", title="\u7f13\u5b58\u5206\u7ec4", required=true) @ApiParam(name="key", title="\u7f13\u5b58KEY", required=true) @ApiParam(name="value", title="list\u5143\u7d20\u503c", required=true) @ApiParam(name="index", title="\u63d2\u5165\u4f4d\u7f6e", memo="\u63d2\u5165\u4f4d\u7f6e\uff0c\u9ed8\u8ba4\u4e3a0\uff0c\u63d2\u5165\u5230\u6700\u524d\u9762\uff0c-1\uff1a\u63d2\u5165\u5230\u6700\u540e\u8fb9") Results addList() {
        Results results = new Results();
        RequestParam param = Bee.getRequestParam();
        String group = param.asText("group");
        if (Tool.Format.isEmpty((String)group)) {
            throw new BeeException("\u7f13\u5b58\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String key = param.asText("key");
        if (Tool.Format.isEmpty((String)key)) {
            throw new BeeException("\u7f13\u5b58KEY\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String value = param.asText("value");
        if (Tool.Format.isEmpty((String)value)) {
            throw new BeeException("\u7f13\u5b58\u5c5e\u6027\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        int index = param.asInt("index");
        Cache cache = Bee.getCache((String)group.trim());
        if (cache == null) {
            throw new BeeException("\u7f13\u5b58\u5206\u7ec4[{}]\u4e0d\u80fd\u5b58\u5728\uff01", new Object[]{group});
        }
        try {
            Cache.Stack stack = cache.getStack(key.trim());
            if (index >= 0) {
                stack.lpush((Object)value.trim());
            } else if (index < 0) {
                stack.rpush((Object)value.trim());
            }
            results.succeed((Object)true);
            Results results2 = results;
            return results2;
        }
        finally {
            cache.close();
        }
    }

    @API(title="\u5220\u9664Set\u7c7b\u578b\u7f13\u5b58\u5143\u7d20", param={@ApiParam(name="group", title="\u7f13\u5b58\u5206\u7ec4", required=true), @ApiParam(name="key", title="\u7f13\u5b58KEY", required=true), @ApiParam(name="value", title="set\u5143\u7d20\u503c", required=true)})
    @DeleteMapping(value={"/set"})
    public @ApiParam(name="group", title="\u7f13\u5b58\u5206\u7ec4", required=true) @ApiParam(name="key", title="\u7f13\u5b58KEY", required=true) @ApiParam(name="value", title="set\u5143\u7d20\u503c", required=true) Results deleteSet() {
        Results results = new Results();
        RequestParam param = Bee.getRequestParam();
        String group = param.asText("group");
        if (Tool.Format.isEmpty((String)group)) {
            throw new BeeException("\u7f13\u5b58\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String key = param.asText("key");
        if (Tool.Format.isEmpty((String)key)) {
            throw new BeeException("\u7f13\u5b58KEY\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String value = param.asText("value");
        if (Tool.Format.isEmpty((String)value)) {
            throw new BeeException("Set\u7f13\u5b58\u5c5e\u6027\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Cache cache = Bee.getCache((String)group.trim());
        if (cache == null) {
            throw new BeeException("\u7f13\u5b58\u5206\u7ec4[{}]\u4e0d\u80fd\u5b58\u5728\uff01", new Object[]{group});
        }
        try {
            cache.getRSet(key.trim()).rem(new String[]{value.trim()});
            results.succeed((Object)true);
            Results results2 = results;
            return results2;
        }
        finally {
            cache.close();
        }
    }

    @API(title="\u5220\u9664List\u7c7b\u578b\u7f13\u5b58\u76f8\u540c\u7c7b\u578b\u5143\u7d20", param={@ApiParam(name="group", title="\u7f13\u5b58\u5206\u7ec4", required=true), @ApiParam(name="key", title="\u7f13\u5b58KEY", required=true), @ApiParam(name="value", title="list\u5143\u7d20\u503c", memo="\u5220\u9664\u6240\u6709\u76f8\u540c\u7684\u5143\u7d20\u3002", required=true)})
    @DeleteMapping(value={"/list"})
    public @ApiParam(name="group", title="\u7f13\u5b58\u5206\u7ec4", required=true) @ApiParam(name="key", title="\u7f13\u5b58KEY", required=true) @ApiParam(name="value", title="list\u5143\u7d20\u503c", memo="\u5220\u9664\u6240\u6709\u76f8\u540c\u7684\u5143\u7d20\u3002", required=true) Results deleteList() {
        Results results = new Results();
        RequestParam param = Bee.getRequestParam();
        String group = param.asText("group");
        if (Tool.Format.isEmpty((String)group)) {
            throw new BeeException("\u7f13\u5b58\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String key = param.asText("key");
        if (Tool.Format.isEmpty((String)key)) {
            throw new BeeException("\u7f13\u5b58KEY\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String value = param.asText("value");
        if (Tool.Format.isEmpty((String)value)) {
            throw new BeeException("list\u7f13\u5b58\u5c5e\u6027\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Cache cache = Bee.getCache((String)group.trim());
        if (cache == null) {
            throw new BeeException("\u7f13\u5b58\u5206\u7ec4[{}]\u4e0d\u80fd\u5b58\u5728\uff01", new Object[]{group});
        }
        try {
            cache.getStack(key.trim()).lrem(0L, value.trim());
            results.succeed((Object)true);
            Results results2 = results;
            return results2;
        }
        finally {
            cache.close();
        }
    }

    private Object toValue(String cval) {
        if (Tool.Format.isEmpty((String)cval)) {
            return cval;
        }
        if (cval.startsWith("{") && cval.endsWith("}") || cval.startsWith("[") && cval.endsWith("]")) {
            JsonNode json = Tool.Json.readTree((String)cval);
            return json != null ? json : cval;
        }
        return cval;
    }
}

