/*!
 * 表格数据绑定插件 主要是对<ul id=listID res={url}></ul>的HTML进行数据绑定
 * 
 * list属性说明： id:表格唯一ID，List对象变量名，可通过List.{id}来引用对象
 * res:取数据的URL接口，其中{}为变量名，与condition中的输入项对应，[]分级，如果分组中的{}存在，则分组存在
 * 引用公共变量：${公共变量名称}， 如，有公共变量为： var context_path="asfsdf"; 引用方法为:
 * ${context_path}/core/******** condition:参数输入项，必须包含有form表单
 * auto:是否自动加载表格数据，如果为false需要手工加载数据 key:key或唯一组合，多个属性用逗号“,”隔开
 * subtotal:需要做小计属性，多个属性用逗号“,”隔开 showblankrow:是否自动填充空行，默认为false，不自动填充空行
 * 
 * th属性说明： name:与返回的数据对象中的属性名对应，其中checkbox、select等html标签、serial为保留名称
 * type:数据类型，string、number、date、serial，checkbox、select等html标签
 * formatter:格式化，主要用于数字类型与日期类型 span:是否需要合并结果相同列，为true是合并
 * class:样式，如果包含有sort样式时，该列可做排序查询
 * 
 * 分页说明： 在tfoot中有一个class="pagebar"的容器，容器的属性有 pagesize:每页显示的数量
 * simple:是否为简单分页，默认为true简单分页
 * setting:分页配置，"pagesize,total,first,prev,next,last,number,pageno,jump"
 * pagesize:每页显示的数量，默认为20条； total:显示总记录数； first:显示第一页功能键； prev:显示上一页功能键；
 * next:显示下一页功能键： last:显示最后一页功能键； pageno:显示当前页码与总页数； number:显示可点击的页码数量功能键；
 * jump:显示自定义跳转功能区。 number:显示可点击的页码数量，默认为显示5个页码。当在setting中指定pages时，些属性生效。
 * 
 * 扩展方法：
 * 以下方法放在jquery的加载方法中或者List.method()中，分别使用如下：
 * a:jquery
 * $(document).ready(function() {
 * 	  //放在这里，如：
 *    List.listID.changeParams=function(params){ // 在这里修改参数 }
 * })
 * 
 * b:List.method()
 * List.method({
 * 	 changeParams:function(params){ // 在这里修改参数 }
 * })
 * 
 * 表格对象引用 通过"List.{id}"来引用，如表格的ID为listID,则引用表格的对象为"List.listID"
 * 1)手工绑定数据 要自行绑定数据，请实现bind方法，如下 
 * List.{id}.bind=function(data){ * //在这里绑定数据列表，data就是后台接口返回的json数据 }
 * 
 * 2)数据绑定完后要处理其他业务 绑定完数据后要处理其他业务，请实现binded方法，如下：
 * List.{id}.binded=function(data){ //在这里绑定完数据列表后的回调方法，data就是后台接口返回的json数据 }
 * 
 * 3)请求发送前修改提交的参数
 * List.{id}.changeParams=function(params){ // 在这里修改参数 }
 * 
 * 4)绑定数据前修改数据集
 * List.{id}.changeData=function(data){ // 在这里修改原数据 }
 * 
 * @author chenxiang
 */
;var lists={};var List=function(table){var me=this;var $tb=this._table=$(table);this.res=$tb.attr("res");this.del=$tb.attr("del")||this.res.substr(0,this.res.indexOf("'"))||this.res.substr(0,this.res.indexOf("?"))||this.res.substr(0,this.res.indexOf("#"))||this.res;this.key=$tb.attr("key");this.type=$tb.attr("type");this.showblankrow=$tb.attr("showblankrow");var _method=$tb.attr("method");this.method=_method=="post"?$.post:$.get;var _isinit=false;if(this.id=$tb.attr("id")){var _tmp=List[this.id];if(_tmp){$.each(_tmp,function(k,item){me[k]=item})}lists[this.id]=List[this.id]=List.lists[this.id]=this}var strToNumObj=function(str){if(!str){return{}}var arr=str.split(","),obj={};for(var i=0;i<arr.length;i++){obj[arr[i]]=0}return obj};try{var _init=$tb.attr("init");var uinit=_init?eval($tb.attr("init")):null;if(uinit&&typeof(uinit)=="function"){uinit()}}catch(e){}var sortIndex=0;var dFields;try{var json=$tb.attr("fields");dFields=JSON.parse(json)}catch(e){}this._fields=dFields||{};this.template=this._template=$tb.find(">.template").remove();this.body=this._tbody=$tb.find(">.body");this._nodata="<div>{massage}</div>";this.foot=this._tfoot=$tb.children("div.foot").eq(0);if($tb.attr("total")){this.total=new List.total($tb.attr("total"));this._tbody.after(this.total.tbody=$("<div class='total'></div>"))}this.pagebar=new Pagebar(this);if(_isinit==false){this.init()}_isinit=true};List.lists={};List.total=function(options){if(!options){return}var that=this;try{that.options=eval("("+options+")");that.clear()}catch(e){alert("数据格式错误："+options)}return this};List.total.prototype={options:null,tbody:null,count:0,subtotal:function(){var f=arguments[0];var d=this.options.subtotal.total;for(var e=0;e<this.options.subtotal.fields.length;e++){if(d[this.options.subtotal.fields[e]]==undefined){d[this.options.subtotal.fields[e]]=0}d[this.options.subtotal.fields[e]]+=parseFloat(f[this.options.subtotal.fields[e]])||0}},average:function(){var g=arguments[0];var h=this.options.average.total;var f=this.options.average.subtotal=this.count>1?this.options.average.subtotal||{}:{};for(var e=0;e<this.options.subtotal.fields.length;e++){f[this.options.subtotal.fields[e]]=(f[this.options.subtotal.fields[e]]||0)+(parseFloat(g[this.options.subtotal.fields[e]])||0);h[this.options.subtotal.fields[e]]=f[this.options.subtotal.fields[e]]/this.count}},max:function(){var f=arguments[0];var d=this.options.max.total;for(var e=0;e<this.options.max.fields.length;e++){d[this.options.max.fields[e]]=d[this.options.max.fields[e]]==undefined?parseFloat(f[this.options.max.fields[e]])||0:Math.max(parseFloat(f[this.options.max.fields[e]])||0,d[this.options.max.fields[e]])}},min:function(){var f=arguments[0];var d=this.options.min.total;for(var e=0;e<this.options.min.fields.length;e++){d[this.options.min.fields[e]]=d[this.options.min.fields[e]]==undefined?parseFloat(f[this.options.min.fields[e]])||0:Math.min(parseFloat(f[this.options.min.fields[e]])||0,d[this.options.min.fields[e]])}},clear:function(){var b=this;b.count=0;$.each(b.options,function(a,d){b.options[a].total={}})},total:function(c){if(!c){return}var d=this;d.count+=1;$.each(this.options||{},function(a,b){if(typeof(d[a])=="function"){d[a].call(d,c)}})}};List.prototype={init:function(){var c=this;this.param={set:function(b,a){this.params[b]=a;return this},get:function(a){return this.params[a]},remove:function(a){delete this.params[a];return this},clear:function(){if(c.$condition.length>0){c.$condition[0].reset()}this.params={};return this},params:{}};if(c.res.indexOf("?")>0){var d=$.getParams(c.res);if(d){c.param.params=d;if(d.pagesize>0){c.pagebar.setPagesize(d.pagesize)}c.res=c.res.substr(0,c.res.indexOf("?"))}}this.initCondition()},initHead:function(){},initCondition:function(){if(!this._table.attr("condition")){return}var b=this;b.$condition=$("#"+this._table.attr("condition")).find("form:eq(0)");b.$condition.submit(function(a){a.returnValue=false;a.preventDefault();a.stopPropagation();b._data=null;b.pagebar.pageno=1;b.go();return false})},changeCondParams:null,key:null,res:null,showblankrow:null,bind:null,binded:null,param:null,sorts:[],method:null,$condition:null,getKeys:function(){var b=[];this._tbody.find(":checkbox:not('input:disabled'):checked").each(function(){b.push(this.value)});return b},go:function(){var b=this;if(this._data&&this._data.data.length>this.pagebar.pagesize){this._bindData(this._data)}else{this._getData()}return this},download:function(){var d=this;d._initConData();var f=$.extend({pagesize:d.pagebar.pagesize,pageno:d.pagebar.pageno},d.param.params,d.param.condParams);f=d.changeParams&&typeof(d.changeParams)=="function"?d.changeParams(f):f;f._t=new Date().getTime();var e=d.getUrl?d.getUrl():d._getUrl();$.download(e+"/@export",f,function(a){console.log("导出成功")})},remove:function(f){var e=this;if(!e.del){alert("请配置删除数据的接口。");return}if(!e.key){alert("请配置数据资源的KEY。");return}var d={};d[e.key]=f||e.getKeys().join(",");if(!d[e.key]){alert("请选择需要删除的数据");return}if(!confirm("确定删除选中的数据吗？")){return}$.del(e.del,d,function(a){e.go()})},_table:null,getUrl:null,_getUrl:function(){var b=this;return this.res.replace(/\${(.)*?}/g,function(a){return self[a.replace(/[\${}]+/g,"")]||$.getParam(a.replace(/[\${}]+/g,""))||""}).replace(/{(.)*?}/g,function(a){var d=a.replace(/[{}]+/g,"");return b.param.params[d]||$.getParam(d)||(top.data||{})[d]||(b.param.condParams||{})[d]||a}).replace(/\[.*?{.*?}\]/g,"").replace(/[\[\]]/g,"").replace(/{.*?}/g,"")},_pg:null,_thead:null,_tbody:null,_tfoot:null,_fields:null,_data:null,_tr:"<div parent_id='${parent_id}'>{td}</div>",_td:"<span name='{key}'>{value}</span>",_checkbox:"<input type='checkbox' value='{value}' name='{key}'/>",_loading:"<div class='_loading'><span class='loading'>正在加载数据，请稍后……</span></div>",_loadtime:null,changeData:null,changeParams:null,checkboxClick:null,_initConData:function(){var c=this;var d=c.$condition?c.$condition.serializeArray():[];if(c.changeCondParams&&typeof(c.changeCondParams)=="function"){c.changeCondParams(d)}c.param.condParams={};$.each(d,function(b,a){if(!a.value&&a.value!="0"&&a.value!==false){delete c.param.params[a.name];return}if(c.param.condParams[a.name]===undefined){c.param.condParams[a.name]=a.value}else{c.param.condParams[a.name]+=","+a.value}})},toGetUrl:function(){var h=this;h._initConData();var e=h.getUrl?h.getUrl():h._getUrl();var g=$.extend({pagesize:h.pagebar.pagesize,pageno:h.pagebar.pageno},h.param.params,h.param.condParams);g=h.changeParams&&typeof(h.changeParams)=="function"?h.changeParams(g):g;var f=[];$.each(g||{},function(a,b){f.push(a+"="+encodeURIComponent(decodeURIComponent(b)))});return e+=(e.indexOf("?")?"&":"?")+f.join("&")},_getData:function(){var d=this;d._table.addClass("tbloading");d._initConData();var c=$.extend({pagesize:d.pagebar.pagesize,pageno:d.pagebar.pageno},d.param.params,d.param.condParams,$.getParams());c=d.changeParams&&typeof(d.changeParams)=="function"?d.changeParams(c):c;c._t=new Date().getTime();d.method(d.getUrl?d.getUrl():d._getUrl(),c,function(a){d._data=a;if(a.total!==undefined){d.pagebar.total=Math.max(a.total,a.data.length);d.pagebar.pagenos=Math.ceil(Math.max(a.total,a.data.length)/d.pagebar.pagesize)||1}d._bindData(a)})},_bindData:function(d){var e=this;var f={};$.extend(f,d);if(f.data&&f.data.length>e.pagebar.pagesize){f.data=f.data.slice(e.pagebar.pagesize*(e.pagebar.pageno-1),e.pagebar.pagesize*e.pagebar.pageno)}if(e.changeData&&typeof(e.changeData)=="function"){e.changeData(f)}clearInterval(e._loadtime);e.bind&&typeof(e.bind)=="function"?e.bind(f):e._bind(f);if(e.pagebar){e.pagebar.loaded()}e._table.removeClass("tbloading");if(e.binded&&typeof(e.binded)=="function"){e.binded(f)}},_bindByTemplate:function(g){var h=this;var f=[];var e=h._template.html();$.each(g.data||[],function(c,b){b.serial=c;var a=h._bindLine(b,e);f.push(a.bind(g).clear("--"))});return f},_bindLine:function(k,e){var l=this;var i=e;if(l.total){l.total.total(k)}var h=$.extend({},l.param.params,k);$.each(l._fields||{},function(a,c){try{if(c&&c.type=="serial"){h.serial=k.serial+1+l.pagebar.pagesize*(l.pagebar.pageno-1)}else{var d=h[a];if(l._subtotal&&l._subtotal[a]!==undefined){l._subtotal[a]+=parseFloat(d)||0}if(c.type=="date"&&c.formatter){d=Util.formatDate(d,c.formatter)}else{if(c.type=="number"){d=Util.formatNumber(d,c.formatter)}else{d=typeof(d)=="string"?d.replace(/\r\n/g,"<br />"):d}}h[a]=d}}catch(b){alert(b)}});try{i=i.bind(h)}catch(j){alert(j)}return i},_bindNoTemplate:function(f){var d=this;var e=[];$.each(f.data||[],function(h,b){if(d.total){d.total.total(b)}var c=d._tr,a=[];$.each(d._fields||{},function(g,k){if(k&&k.type=="serial"){a.push(d._td.replace(/{key}/g,g).replace(/{value}/g,h+d.pagebar.pagesize*(d.pagebar.pageno-1)+1))}else{var l=b[g];if(d._subtotal&&d._subtotal[g]!==undefined){d._subtotal[g]+=parseFloat(l)||0}if(k.type=="date"&&k.formatter){l=Util.formatDate(l,k.formatter)}else{if(k.type=="number"){l=Util.formatNumber(l,k.formatter)}else{if(k.type=="checkbox"){l=d._checkbox.replace(/{value}/g,b[k.eq]).replace(/{key}/g,k.eq)}}}a.push(d._td.replace(/{key}/g,g).replace(/{value}/g,l))}});e.push(c.replace("{td}",a.join("")))});return e},_bindChildren:function(h,f){var i=this;if(!i.serial){i.serial=0}var g=[];var j=i._template.html();$.each(h||[],function(c,b){b.layer=f||0;b.serial=i.serial++;b.arrow=b.children?"arrow":"noarrow";var a=i._bindLine(b,j);g.push(a);if(b.children){g=g.concat(i._bindChildren(b.children,b.layer+1))}});return g},_initTree:function(){var d=this;var f=function(b){var a=d._table.find("li[parent_id='"+b+"']");a.show()};var e=function(b){var a=d._table.find("li[parent_id='"+b+"']");a.each(function(){e($(this).attr("_id"))});a.hide();a.find(".spread").removeClass("spread")};d._table.find("span.arrow").on("click",{},function(a){var b=$(this);b.parent().toggleClass("spread");var c=b.parents("tr").attr("_id");b.parent().hasClass("spread")?f(c):e(c)})},_bind:function(q){var i=new Date().getTime();var m=this;if(m.total){if(m.pagebar.simple&&m.pagebar.pageno==1||!m.pagebar.simple){m.total.clear()}}var n=m._template.length==0?m._bindNoTemplate(q):m.type=="tree"?m._bindChildren(q.data):m._bindByTemplate(q);m.serial=0;if(n.length==0){n.push(m._nodata.replace(/{massage}/g,q.massage||"找不到相关数据！"))}if(m.total){var r=[];$.each(m.total.options||{},function(c,d){var b=m._tr,e=[],a=0;$.each(m._fields||{},function(f,g){a++;if(d.total[f]!==undefined){if(e.length==0){e.push("<span align='right' class='"+c+"' style='text-align: right;' colspan="+(a-1)+">"+d.title+"</span>")}var h=d.total[f];if(g.type=="date"&&g.formatter){h=Util.formatDate(h,g.formatter)}else{if(g.type=="number"){h=Util.formatNumber(h,g.formatter)}}e.push("<td>"+h+"</td>")}else{if(e.length==0){return}else{e.push("")}}});r.push(b.replace("{td}",e.join("")))});m.total.tbody.html(r.join(""))}if(m.showblankrow&&!m.pagebar.simple){var s=this._thead.children(":last-child").children().length;var p=[];for(o=0;o<s;o++){p.push("<span>&nbsp;</span>")}p=p.join("");for(var o=(q.data||[]).length;o<m.pagebar.pagesize;o++){n.push("<div>"+p+"</div>")}}if(m.pagebar&&m.pagebar.simple){var t=document.body.clientHeight;m._tbody.empty().html(n.join(""));m._tbody.find(">._loading").remove();var l=document.body.clientHeight;scrollTo(scrollX,scrollY+l-t)}else{m._tbody.empty().html(n.join(""))}if(m.type=="tree"){m._initTree()}}};List.init=function(b){$("div[res]",b||document).each(function(){if($(this).attr("init")===false){return}List.from(this)})};List.from=function(c){if(typeof(c)=="string"){c=$("#"+c)[0]}var d=new List(c);d.param.params=$.extend(d.param.params,$.getParams());if($(c).attr("auto")=="true"){d.go()}return d};List.method=function(b){$.each(b,function(a,d){List[a]=d})};$(document).ready(function(){List.init()});