/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.work;

import bee.cloud.core.db.Holder;
import bee.cloud.engine.config.HttpMethods;
import bee.cloud.engine.config.sqlmap.QApi;
import bee.cloud.engine.config.sqlmap.QEnum;
import bee.cloud.service.base.work.Work;
import bee.cloud.service.controller.Controller;
import bee.cloud.service.controller.FaviconController;
import bee.cloud.service.controller.RmiapiController;
import bee.cloud.service.controller.UploadController;
import bee.cloud.service.controller.UrisController;
import bee.cloud.service.controller.WebController;
import bee.cloud.service.core.annotation.API;
import bee.cloud.service.core.annotation.ApiDesc;
import bee.cloud.service.core.annotation.ApiParam;
import bee.cloud.service.core.annotation.BInit;
import bee.cloud.service.error.ExcHandler;
import bee.cloud.service.file.Upload;
import bee.tool.Tool;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@BInit
public class InitController
implements Work.WInit {
    private static final Pattern pattern = Pattern.compile("\\{(.*?)\\}");

    public void go() {
        Work.apis.forEach(clazz -> this.init((Class<?>)clazz));
    }

    private void init(Class<?> clazz) {
        String[] stringArray;
        Upload upload;
        if (Controller.class.isAssignableFrom(clazz) || clazz.equals(ExcHandler.class) || clazz.equals(FaviconController.class) || clazz.equals(RmiapiController.class) || clazz.equals(UrisController.class) || clazz.equals(WebController.class)) {
            return;
        }
        if (clazz.equals(UploadController.class) && (upload = (Upload)Holder.self().getBean(Upload.class, new Object[0])) == null) {
            return;
        }
        RequestMapping rootmp = (RequestMapping)AnnotationUtils.findAnnotation(clazz, RequestMapping.class);
        if (rootmp != null) {
            stringArray = rootmp.path();
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        }
        String[] rootPath = stringArray;
        Map<String, Method> methods = this.findMethods(clazz);
        for (Method m : methods.values()) {
            API api = m.getAnnotation(API.class);
            String[] mpath = null;
            PostMapping post = null;
            PutMapping put = null;
            GetMapping get = null;
            DeleteMapping del = null;
            RequestMapping mmp = null;
            post = (PostMapping)AnnotationUtils.getAnnotation((Method)m, PostMapping.class);
            if (post != null) {
                mpath = post.path();
            } else {
                put = (PutMapping)AnnotationUtils.getAnnotation((Method)m, PutMapping.class);
                if (put != null) {
                    mpath = put.path();
                } else {
                    get = (GetMapping)AnnotationUtils.getAnnotation((Method)m, GetMapping.class);
                    if (get != null) {
                        mpath = get.path();
                    } else {
                        del = (DeleteMapping)AnnotationUtils.getAnnotation((Method)m, DeleteMapping.class);
                        if (del != null) {
                            mpath = del.path();
                        } else {
                            mmp = (RequestMapping)AnnotationUtils.getAnnotation((Method)m, RequestMapping.class);
                            if (mmp == null) continue;
                            mpath = mmp.path();
                        }
                    }
                }
            }
            Tool.Log.info((String)"\u6ce8\u518c\u63a5\u53e3\u914d\u7f6e\uff1a{}.{}().", (Object[])new Object[]{clazz.getName(), m.getName()});
            RequestMethod rm = post != null ? RequestMethod.POST : (put != null ? RequestMethod.PUT : (get != null ? RequestMethod.GET : (del != null ? RequestMethod.DELETE : this.toRequestMethod(mmp))));
            String[] stringArray3 = rootPath;
            int n = rootPath.length;
            int n2 = 0;
            while (n2 < n) {
                String rp = stringArray3[n2];
                if (mpath.length == 0) {
                    mpath = new String[]{""};
                }
                String[] stringArray4 = mpath;
                int n3 = mpath.length;
                int n4 = 0;
                while (n4 < n3) {
                    Parameter[] parameters;
                    String mp = stringArray4[n4];
                    HashMap<String, String> ppath = new HashMap<String, String>();
                    Matcher matcher = pattern.matcher(mp);
                    while (matcher.find()) {
                        String desc = matcher.group(1);
                        String[] var = desc.split(":");
                        ppath.put(var[0], matcher.group(0));
                        mp = mp.replace(desc, var[0]);
                    }
                    String uri = String.valueOf(rp) + mp;
                    QEnum.HttpMethod hm = QEnum.HttpMethod.nameOf((String)rm.name());
                    QApi.QUri quri = new QApi.QUri(hm.name().toLowerCase(), uri);
                    quri.setTitle(api != null ? api.title() : m.getName());
                    quri.setDescribe(api != null ? Tool.Value.toSingle((String[])new String[]{api.memo(), api.title()}) : m.getName());
                    quri.setContentType(api != null ? api.contentType() : null);
                    if (api != null) {
                        ApiParam[] apiParamArray = api.param();
                        int n5 = apiParamArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            ApiParam ap = apiParamArray[n6];
                            HttpMethods.Param param = new HttpMethods.Param(ap.name(), ap.type());
                            param.title = ap.title();
                            param.length = ap.length();
                            param.dic = ap.dict();
                            param.describe = Tool.Value.toSingle((String[])new String[]{ap.memo(), ap.title()});
                            param.required = ap.required();
                            quri.addParam(param);
                            ++n6;
                        }
                    }
                    Map params = quri.getParams();
                    Parameter[] parameterArray = parameters = m.getParameters();
                    int n7 = parameters.length;
                    int n8 = 0;
                    while (n8 < n7) {
                        block28: {
                            block29: {
                                HttpMethods.Param param;
                                String pname;
                                Class<?> type;
                                RequestParam arp;
                                ApiDesc adesc;
                                block27: {
                                    Parameter p = parameterArray[n8];
                                    adesc = p.getAnnotation(ApiDesc.class);
                                    PathVariable apath = p.getAnnotation(PathVariable.class);
                                    arp = p.getAnnotation(RequestParam.class);
                                    type = p.getType();
                                    if (apath == null) break block27;
                                    pname = Tool.Value.toSingle((String[])new String[]{apath.name(), apath.value()});
                                    if (params != null && params.containsKey(pname)) break block28;
                                    param = new HttpMethods.Param(pname, QEnum.QType.nameOf((String)type.getName()));
                                    if (adesc != null) {
                                        param.title = Tool.Value.toSingle((String[])new String[]{adesc.title(), adesc.value()});
                                        param.describe = Tool.Value.toSingle((String[])new String[]{adesc.memo(), adesc.title(), adesc.value()});
                                        param.length = adesc.length();
                                        param.dic = adesc.dict();
                                        param.required = adesc.required();
                                    } else {
                                        param.title = param.describe = pname;
                                    }
                                    quri.addParam(param);
                                    break block29;
                                }
                                if (arp == null) break block29;
                                pname = Tool.Value.toSingle((String[])new String[]{arp.name(), arp.value()});
                                if (params != null && params.containsKey(pname)) break block28;
                                param = new HttpMethods.Param(pname, QEnum.QType.nameOf((String)type.getName()));
                                if (adesc != null) {
                                    param.title = Tool.Value.toSingle((String[])new String[]{adesc.title(), adesc.value()});
                                    param.describe = Tool.Value.toSingle((String[])new String[]{adesc.memo(), adesc.title(), adesc.value()});
                                    param.length = adesc.length();
                                    param.dic = adesc.dict();
                                    param.required = adesc.required();
                                } else {
                                    param.title = param.describe = pname;
                                }
                                quri.addParam(param);
                            }
                            ppath.forEach((k, v) -> {
                                if (params != null && params.containsKey(k)) {
                                    ((HttpMethods.Param)map.get((Object)k)).describe = String.valueOf(((HttpMethods.Param)map.get((Object)k)).describe) + " " + v;
                                    return;
                                }
                                HttpMethods.Param param = new HttpMethods.Param(k, QEnum.QType.CHARACTER);
                                param.title = k;
                                param.describe = v;
                                quri.addParam(param);
                            });
                        }
                        ++n8;
                    }
                    QApi.putQUri((QApi.QUri)quri);
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private Map<String, Method> findMethods(Class<?> clazz) {
        Method[] curms;
        HashMap<String, Method> methods = new HashMap<String, Method>();
        Method[] methodArray = curms = clazz.getMethods();
        int n = curms.length;
        int n2 = 0;
        while (n2 < n) {
            Method m2 = methodArray[n2];
            if (Modifier.isPublic(m2.getModifiers()) && !Modifier.isStatic(m2.getModifiers()) && (m2.isAnnotationPresent(GetMapping.class) || m2.isAnnotationPresent(PostMapping.class) || m2.isAnnotationPresent(PutMapping.class) || m2.isAnnotationPresent(DeleteMapping.class) || m2.isAnnotationPresent(RequestMapping.class)) && m2.isAnnotationPresent(API.class)) {
                Parameter[] parameters = m2.getParameters();
                StringBuffer sb = new StringBuffer();
                Parameter[] parameterArray = parameters;
                int n3 = parameters.length;
                int n4 = 0;
                while (n4 < n3) {
                    Parameter p = parameterArray[n4];
                    String name = p.getName();
                    sb.append("_").append(name);
                    ++n4;
                }
                String key = String.valueOf(m2.getName()) + sb.toString();
                methods.put(key, m2);
            }
            ++n2;
        }
        Class<?> sup = clazz.getSuperclass();
        if (!sup.getName().equals(Object.class.getName())) {
            Map<String, Method> supMethods = this.findMethods(sup);
            supMethods.forEach((k, m) -> {
                if (methods.containsKey(k)) {
                    return;
                }
                methods.put((String)k, (Method)m);
            });
        }
        return methods;
    }

    private RequestMethod toRequestMethod(RequestMapping rm) {
        RequestMethod[] methods;
        StringBuilder sb = new StringBuilder();
        RequestMethod[] requestMethodArray = methods = rm.method();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            RequestMethod m = requestMethodArray[n2];
            sb.append(m.name().toLowerCase()).append(" ");
            ++n2;
        }
        return sb.indexOf("post") >= 0 ? RequestMethod.POST : (sb.indexOf("put") >= 0 ? RequestMethod.PUT : (sb.indexOf("get") >= 0 ? RequestMethod.GET : (sb.indexOf("delete") >= 0 ? RequestMethod.DELETE : RequestMethod.GET)));
    }
}

