/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.work;

import bee.tool.Tool;
import bee.tool.err.BeeException;
import bee.tool.string.Format;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.LineNumberReader;

public abstract class Command {
    private String projectPath;

    public void setProjectRoot(String path) {
        this.projectPath = path;
    }

    public void execute(Listener listener, String ... command) {
        String os = System.getProperty("os.name").toLowerCase();
        Tool.Log.info((String)os);
        if (os.startsWith("windows")) {
            this.executeWindow(listener, command);
        } else if (os.startsWith("linux")) {
            this.executeLinux(listener, command);
        }
    }

    public void executeLinux(Listener listener, String ... command) {
        StringBuilder cmds = new StringBuilder();
        String usrDir = Tool.Value.toSingle((String[])new String[]{this.projectPath, System.getProperty("user.dir")});
        cmds.append("cd " + usrDir);
        String[] stringArray = command;
        int n = command.length;
        int n2 = 0;
        while (n2 < n) {
            String cmd = stringArray[n2];
            if (!Format.isEmpty((String)cmd)) {
                if (cmd.trim().toLowerCase().startsWith("rm")) {
                    throw new BeeException("\u4e0d\u5141\u8bb8\u6267\u884crm\u547d\u4ee4");
                }
                if (cmds.length() > 0) {
                    cmds.append(" && ");
                }
                cmds.append(cmd.trim());
            }
            ++n2;
        }
        Tool.Log.info((Object)cmds);
        try {
            String line;
            Process process = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", cmds.toString()}, null, null);
            InputStreamReader ir = new InputStreamReader(process.getInputStream());
            LineNumberReader input = new LineNumberReader(ir);
            int waitFor = process.waitFor();
            Tool.Log.info((String)"waitFor:{}", (Object[])new Object[]{waitFor});
            while ((line = input.readLine()) != null) {
                listener.log(line);
            }
            listener.log("end");
        }
        catch (Exception e) {
            throw new BeeException((Throwable)e);
        }
    }

    private void executeWindow(Listener listener, String ... command) {
        StringBuilder cmds = new StringBuilder();
        String usrDir = this.projectPath;
        cmds.append("cd " + usrDir);
        String[] stringArray = command;
        int n = command.length;
        int n2 = 0;
        while (n2 < n) {
            String cmd = stringArray[n2];
            if (!Format.isEmpty((String)cmd) && cmd.trim().toLowerCase().startsWith("del")) {
                throw new BeeException("\u4e0d\u5141\u8bb8\u6267\u884crm\u547d\u4ee4");
            }
            ++n2;
        }
        try {
            Runtime rt = Runtime.getRuntime();
            Process pr = rt.exec("cmd /c e: & " + cmds);
            BufferedReader input = new BufferedReader(new InputStreamReader(pr.getInputStream(), "GBK"));
            String line = null;
            while ((line = input.readLine()) != null) {
                Tool.Log.info((String)line);
                listener.log(line);
            }
            listener.log("end");
            int n3 = pr.waitFor();
        }
        catch (Exception e) {
            throw new BeeException((Throwable)e);
        }
    }

    public static interface Listener {
        public void log(String var1);
    }
}

