/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.filter;

import bee.cloud.config.BConfig;
import bee.cloud.config.BSystem;
import bee.cloud.core.Bee;
import bee.cloud.core.db.BusinessManage;
import bee.cloud.service.core.result.Results;
import bee.cloud.service.error.ExcHandler;
import bee.cloud.service.work.Respond;
import bee.tool.Tool;
import bee.tool.err.BeeException;
import bee.tool.string.Format;
import bee.tool.string.MD5;
import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;

@Order(value=-10)
@WebFilter(filterName="beeFilter", urlPatterns={"/*"})
public class BeeFilter
implements Filter {
    @Autowired
    private ExcHandler handler;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block29: {
            String method;
            String uri;
            long start;
            block30: {
                BusinessManage bm;
                block26: {
                    String method2;
                    String uri2;
                    block27: {
                        block24: {
                            String method3;
                            String uri3;
                            block25: {
                                String uri4;
                                Respond resreq;
                                block22: {
                                    String method4;
                                    String uri5;
                                    block23: {
                                        block20: {
                                            String method5;
                                            String uri6;
                                            block21: {
                                                block18: {
                                                    String method6;
                                                    String uri7;
                                                    block19: {
                                                        block16: {
                                                            String method7;
                                                            String uri8;
                                                            block17: {
                                                                start = System.currentTimeMillis();
                                                                bm = null;
                                                                Thread.currentThread().setName(String.valueOf(BSystem.getApplicationName()) + Thread.currentThread().getId());
                                                                if (Bee.isStarted()) break block16;
                                                                Results results = new Results();
                                                                results.setResponse((HttpServletResponse)response);
                                                                results.warning((Object)"\u7cfb\u7edf\u6b63\u5728\u7ef4\u62a4\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01").build();
                                                                uri8 = null;
                                                                method7 = null;
                                                                if (bm == null) break block17;
                                                                uri8 = bm.getRequestParam().getUri();
                                                                method7 = bm.getRequestParam().header.getMethod();
                                                                bm.clear();
                                                            }
                                                            long end = System.currentTimeMillis();
                                                            Tool.Log.info((String)"\u5f53\u524d\u8bf7\u6c42\u603b\u7528\u65f6\uff1a{}ms\uff0c[{}]{}", (Object[])new Object[]{end - start, method7, uri8});
                                                            return;
                                                        }
                                                        bm = BusinessManage.inst();
                                                        bm.setRequest(true);
                                                        resreq = new Respond((HttpServletResponse)response, (HttpServletRequest)request);
                                                        bm.setResponse((Bee.Resreq)resreq);
                                                        String beeGateway = bm.getRequestParam().getHeader("bee_gateway");
                                                        String beeSign = bm.getRequestParam().getHeader("bee_sign");
                                                        if (!Tool.Format.noEmptys((String[])new String[]{beeSign, beeGateway}) || !beeSign.equals(Tool.Encrypt.decrypt((String)beeGateway))) break block18;
                                                        chain.doFilter(request, response);
                                                        uri7 = null;
                                                        method6 = null;
                                                        if (bm == null) break block19;
                                                        uri7 = bm.getRequestParam().getUri();
                                                        method6 = bm.getRequestParam().header.getMethod();
                                                        bm.clear();
                                                    }
                                                    long end = System.currentTimeMillis();
                                                    Tool.Log.info((String)"\u5f53\u524d\u8bf7\u6c42\u603b\u7528\u65f6\uff1a{}ms\uff0c[{}]{}", (Object[])new Object[]{end - start, method6, uri7});
                                                    return;
                                                }
                                                uri4 = bm.getRequestParam().getUri();
                                                if (!uri4.endsWith("/remote/api")) break block20;
                                                chain.doFilter(request, response);
                                                uri6 = null;
                                                method5 = null;
                                                if (bm == null) break block21;
                                                uri6 = bm.getRequestParam().getUri();
                                                method5 = bm.getRequestParam().header.getMethod();
                                                bm.clear();
                                            }
                                            long end = System.currentTimeMillis();
                                            Tool.Log.info((String)"\u5f53\u524d\u8bf7\u6c42\u603b\u7528\u65f6\uff1a{}ms\uff0c[{}]{}", (Object[])new Object[]{end - start, method5, uri6});
                                            return;
                                        }
                                        String encode = request.getCharacterEncoding();
                                        response.setContentType("application/json;charset=" + encode);
                                        response.setCharacterEncoding(encode);
                                        if (!uri4.startsWith("$api")) break block22;
                                        chain.doFilter(request, response);
                                        uri5 = null;
                                        method4 = null;
                                        if (bm == null) break block23;
                                        uri5 = bm.getRequestParam().getUri();
                                        method4 = bm.getRequestParam().header.getMethod();
                                        bm.clear();
                                    }
                                    long end = System.currentTimeMillis();
                                    Tool.Log.info((String)"\u5f53\u524d\u8bf7\u6c42\u603b\u7528\u65f6\uff1a{}ms\uff0c[{}]{}", (Object[])new Object[]{end - start, method4, uri5});
                                    return;
                                }
                                if (BConfig.asBoolean((String)"api.ispub", (boolean)true) || !uri4.startsWith("uris")) break block24;
                                String ip = resreq.getRequestParam().header.getIP();
                                String agent = resreq.getRequestParam().header.getAgent();
                                String devtoken = resreq.getRequestParam().getCookie("devtoken");
                                if (Tool.Format.isEmpty((String)devtoken)) {
                                    throw new BeeException("\u4eb2\uff0c\u4f60\u8fd8\u672a\u767b\u5f55\u7cfb\u7edf\uff0c\u8bf7\u767b\u9646\uff01").setCode(399);
                                }
                                String edata = Tool.Encrypt.decrypt((String)devtoken);
                                if (!Tool.MD5.encode((String)(String.valueOf(ip) + agent)).equals(edata)) {
                                    throw new BeeException("\u4eb2\uff0c\u767b\u9646\u8d85\u65f6\u4e86\uff0c\u8bf7\u91cd\u65b0\u767b\u9646\uff01").setCode(398);
                                }
                                chain.doFilter(request, response);
                                uri3 = null;
                                method3 = null;
                                if (bm == null) break block25;
                                uri3 = bm.getRequestParam().getUri();
                                method3 = bm.getRequestParam().header.getMethod();
                                bm.clear();
                            }
                            long end = System.currentTimeMillis();
                            Tool.Log.info((String)"\u5f53\u524d\u8bf7\u6c42\u603b\u7528\u65f6\uff1a{}ms\uff0c[{}]{}", (Object[])new Object[]{end - start, method3, uri3});
                            return;
                        }
                        if (this.check()) break block26;
                        Results results = new Results();
                        results.setResponse((HttpServletResponse)response);
                        results.warning((Object)"\u975e\u6cd5\u8bbf\u95ee\uff01\u5c0f\u6837\uff0c\u4f60\u4ee5\u4e3a\u6362\u4e86\u4e2a\u9a6c\u7532\u6211\u5c31\u4e0d\u8ba4\u8bc6\u4f60\u4e86\u3002").build();
                        uri2 = null;
                        method2 = null;
                        if (bm == null) break block27;
                        uri2 = bm.getRequestParam().getUri();
                        method2 = bm.getRequestParam().header.getMethod();
                        bm.clear();
                    }
                    long end = System.currentTimeMillis();
                    Tool.Log.info((String)"\u5f53\u524d\u8bf7\u6c42\u603b\u7528\u65f6\uff1a{}ms\uff0c[{}]{}", (Object[])new Object[]{end - start, method2, uri2});
                    return;
                }
                try {
                    chain.doFilter(request, response);
                }
                catch (BeeException e) {
                    Map<String, Object> map = this.handler.errorHandler((Exception)((Object)e));
                    Results results = new Results();
                    results.setResponse((HttpServletResponse)response);
                    results.putAll(map);
                    results.build();
                    String uri9 = null;
                    String method8 = null;
                    if (bm != null) {
                        uri9 = bm.getRequestParam().getUri();
                        method8 = bm.getRequestParam().header.getMethod();
                        bm.clear();
                    }
                    long end = System.currentTimeMillis();
                    Tool.Log.info((String)"\u5f53\u524d\u8bf7\u6c42\u603b\u7528\u65f6\uff1a{}ms\uff0c[{}]{}", (Object[])new Object[]{end - start, method8, uri9});
                    return;
                }
                catch (Exception e1) {
                    String method9;
                    String uri10;
                    block28: {
                        try {
                            e1.printStackTrace();
                            uri10 = null;
                            method9 = null;
                            if (bm == null) break block28;
                        }
                        catch (Throwable throwable) {
                            String uri11 = null;
                            String method10 = null;
                            if (bm != null) {
                                uri11 = bm.getRequestParam().getUri();
                                method10 = bm.getRequestParam().header.getMethod();
                                bm.clear();
                            }
                            long end = System.currentTimeMillis();
                            Tool.Log.info((String)"\u5f53\u524d\u8bf7\u6c42\u603b\u7528\u65f6\uff1a{}ms\uff0c[{}]{}", (Object[])new Object[]{end - start, method10, uri11});
                            throw throwable;
                        }
                        uri10 = bm.getRequestParam().getUri();
                        method9 = bm.getRequestParam().header.getMethod();
                        bm.clear();
                    }
                    long end = System.currentTimeMillis();
                    Tool.Log.info((String)"\u5f53\u524d\u8bf7\u6c42\u603b\u7528\u65f6\uff1a{}ms\uff0c[{}]{}", (Object[])new Object[]{end - start, method9, uri10});
                    break block29;
                }
                uri = null;
                method = null;
                if (bm == null) break block30;
                uri = bm.getRequestParam().getUri();
                method = bm.getRequestParam().header.getMethod();
                bm.clear();
            }
            long end = System.currentTimeMillis();
            Tool.Log.info((String)"\u5f53\u524d\u8bf7\u6c42\u603b\u7528\u65f6\uff1a{}ms\uff0c[{}]{}", (Object[])new Object[]{end - start, method, uri});
        }
    }

    private boolean check() {
        String id = Bee.getResreq().getCookie("_client");
        String clientId = Bee.getRequestParam().header.getClientId();
        String random = Bee.getResreq().getCookie("_random");
        String tmpId = MD5.encode((String)(String.valueOf(clientId) + random));
        return !Format.noEmpty((Object)id) || !Format.noEmpty((Object)random) || id.equals(tmpId);
    }
}

