/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.controller;

import bee.cloud.config.BSystem;
import bee.cloud.core.Bee;
import bee.cloud.service.core.result.Results;
import bee.cloud.service.web.api.WebApi;
import bee.tool.Tool;
import bee.tool.string.Format;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@ControllerAdvice
@RequestMapping(value={"/$api"})
public class WebController {
    private HttpServletResponse response;
    private HttpServletRequest request;
    private Results results = new Results();

    public WebController(HttpServletResponse response, HttpServletRequest request) {
        Bee.Resreq resreq = Bee.getResreq();
        if (resreq != null) {
            this.response = resreq.getHttpServletResponse();
            this.request = resreq.getHttpServletRequest();
        } else {
            this.response = response;
            this.request = request;
        }
        this.results.setResponse(response);
    }

    public String getLoginContent() {
        String contextPath = this.request.getContextPath();
        String prefix = Bee.getRequestParam().header.get("x-forwarded-prefix");
        if (prefix == null) {
            prefix = "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<script>");
        sb.append("location.href='" + (Format.noEmpty((Object)contextPath) ? contextPath : prefix) + "/$api/login.html';");
        sb.append("</script>");
        return sb.toString();
    }

    public ModelAndView go() {
        ModelAndView modelAndView = new ModelAndView("redirect:/$api/index.shtml");
        return modelAndView;
    }

    @GetMapping
    public void index() throws IOException {
        if (this.response.isCommitted()) {
            return;
        }
        String contextPath = this.request.getContextPath();
        String content = WebApi.getContent("/index.shtml");
        StringBuffer sb = new StringBuffer();
        String prefix = Bee.getRequestParam().header.get("x-forwarded-prefix");
        if (prefix == null) {
            prefix = "";
        }
        sb.append("<script>");
        sb.append("location.href='" + (Format.noEmpty((Object)contextPath) ? contextPath : prefix) + "/$api/index.shtml';");
        sb.append("</script>");
        content = sb.toString();
        String type = "text/html";
        if (Format.isEmpty((String)content)) {
            this.response.sendError(404);
            return;
        }
        this.results.setContentType(type);
        this.results.build(content);
    }

    @GetMapping(value={"/*.shtml", "/*.html", "/*.htm"})
    public void other() throws IOException {
        if (this.response.isCommitted()) {
            return;
        }
        String contextPath = this.request.getContextPath();
        String uri = this.request.getRequestURI();
        uri = uri.substring(contextPath.length());
        if ((uri = uri.substring("/$api".length())).indexOf("?") > 0) {
            uri = uri.substring(0, uri.indexOf("?"));
        }
        String type = "text/html; charset=utf-8";
        String content = WebApi.getContent(uri);
        if (uri.endsWith("/index.shtml")) {
            String title = BSystem.get((String)"spring.application.title", (String)"BEECLOUD\u5fae\u670d\u52a1\u5feb\u901f\u5f00\u53d1\u6846\u67b6");
            content = content.replace("##[title]##", title);
            content = content.replace("##[description]##", BSystem.get((String)"spring.application.description", (String)"---"));
        }
        if (Format.isEmpty((String)content)) {
            this.response.sendError(404);
            return;
        }
        this.results.setContentType(type);
        this.results.build(content);
    }

    @GetMapping(value={"/**/*.woff", "/**/*.woff2", "/**/*.ttf", "/**/*.eot", "/**/*.otf", "/**/*.svg"})
    public void font() throws IOException {
        String suffix;
        if (this.response.isCommitted()) {
            return;
        }
        String contextPath = this.request.getContextPath();
        String uri = this.request.getRequestURI();
        uri = uri.substring(contextPath.length());
        if ((uri = uri.substring("/$api".length()).toLowerCase()).indexOf("?") > 0) {
            uri = uri.substring(0, uri.indexOf("?"));
        }
        String type = "woff".equals(suffix = uri.substring(uri.lastIndexOf(".") + 1)) ? "application/font-woff" : ("woff2".equals(suffix) ? "application/octet-stream" : ("ttf".equals(suffix) ? "application/octet-stream" : null));
        byte[] content = WebApi.getBytes(uri);
        if (Format.isEmpty((Object)content)) {
            this.response.sendError(404);
            return;
        }
        int catchTime = 18000;
        this.results.addHeader("Cache-Control", "max-age=" + catchTime);
        if (Format.noEmpty((Object)type)) {
            this.results.setContentType(type);
        }
        this.results.build(content);
    }

    @GetMapping(value={"/**/*.js", "/**/*.css", "/**/*.html", "/**/*.shtml"})
    public void request() throws IOException {
        String suffix;
        if (this.response.isCommitted()) {
            return;
        }
        String contextPath = this.request.getContextPath();
        String uri = this.request.getRequestURI();
        uri = uri.substring(contextPath.length());
        if ((uri = uri.substring("/$api".length())).indexOf("?") > 0) {
            uri = uri.substring(0, uri.indexOf("?"));
        }
        String type = "js".equalsIgnoreCase(suffix = uri.substring(uri.lastIndexOf(".") + 1)) ? "text/js" : ("css".equalsIgnoreCase(suffix) ? "text/css" : (suffix.indexOf("htm") >= 0 ? "text/html; charset=utf-8" : "text/plain"));
        String content = WebApi.getContent(uri);
        if (Format.isEmpty((String)content)) {
            this.response.sendError(404);
            return;
        }
        int catchTime = 18000;
        this.results.addHeader("Cache-Control", "max-age=" + catchTime);
        if (Format.noEmpty((Object)type)) {
            this.results.setContentType(type);
        }
        this.results.build(content);
    }

    @GetMapping(value={"/**/*.png", "/**/*.jpg", "/**/*.bmp", "/**/*.gif", "*.ico"})
    public void requestImage() throws IOException {
        if (this.response.isCommitted()) {
            return;
        }
        String contextPath = this.request.getContextPath();
        String uri = this.request.getRequestURI();
        uri = uri.substring(contextPath.length());
        if ((uri = uri.substring("/$api".length())).indexOf("?") > 0) {
            uri = uri.substring(0, uri.indexOf("?"));
        }
        String type = "image/*";
        byte[] content = WebApi.getBytes(uri);
        if (content == null || content.length == 0) {
            this.response.sendError(404);
            return;
        }
        int catchTime = 18000;
        this.results.addHeader("Cache-Control", "max-age=" + catchTime);
        this.results.setContentType(type);
        this.results.build(content);
    }

    @GetMapping(value={"/readme"})
    public void readme() {
        if (this.response.isCommitted()) {
            return;
        }
        String metaPath = Tool.Path.getMetaPath();
        StringBuffer sb = Tool.FileOperate.readFile((String)(String.valueOf(metaPath) + "readme.md"));
        int catchTime = 18000;
        this.results.addHeader("Cache-Control", "max-age=" + catchTime);
        this.results.setContentType("text/html; charset=utf-8");
        this.results.build(sb != null ? sb.toString() : "\u5f00\u53d1\u4eba\u5458\u672a\u7f16\u5199\u7cfb\u7edf\u4f7f\u7528\u8bf4\u660e\uff0c\u8bf7\u7814\u53d1\u4eba\u5458\u5c06\u7cfb\u7edf\u4f7f\u7528\u8bf4\u660e\u5199\u5728\u5e94\u7528\u5de5\u7a0b\u4e0b\u7684\u201creadme.md\u201d\u6587\u4ef6\u4e2d\uff01");
    }
}

