/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.controller;

import bee.cloud.core.Bee;
import bee.cloud.core.db.RequestParam;
import bee.cloud.engine.config.HttpMethods;
import bee.cloud.engine.config.sqlmap.QApi;
import bee.cloud.engine.config.sqlmap.QEnum;
import bee.cloud.engine.config.sqlmap.QTable;
import bee.cloud.engine.config.sqlmap.RParent;
import bee.cloud.engine.config.sqlmap.Relation;
import bee.cloud.service.core.HttpParam;
import bee.cloud.service.core.PathData;
import bee.cloud.service.core.result.Results;
import bee.tool.Tool;
import bee.tool.img.VerifyCode;
import bee.tool.string.Format;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
@RequestMapping(value={"/uris"})
public class UrisController {
    @GetMapping(produces={"application/json"})
    public Results getApi(HttpServletResponse response, HttpServletRequest request) {
        Results results = new Results();
        boolean c = Format.strToBoolean((String)request.getParameter("c"), (Boolean)false);
        boolean s = Format.strToBoolean((String)request.getParameter("s"), (Boolean)true);
        List apis = HttpMethods.getApis((boolean)c, (boolean)s);
        results.succeed((Object)apis);
        return results;
    }

    @GetMapping(value={"apis"}, produces={"application/json"})
    public Results getApis(HttpServletResponse response, HttpServletRequest request) {
        Results results = new Results();
        boolean c = Format.strToBoolean((String)request.getParameter("c"), (Boolean)false);
        boolean s = Format.strToBoolean((String)request.getParameter("s"), (Boolean)true);
        List tmps = HttpMethods.getApis((boolean)c, (boolean)s);
        results.succeed((Object)tmps);
        return results;
    }

    @GetMapping(value={"/{item1}", "/{item1}/{item2}", "/{item1}/{item2}/{item3}", "/{item1}/{item2}/{item3}/{item4}", "/{item1}/{item2}/{item3}/{item4}/{item5}", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}/{item8}", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}/{item8}/{item9}", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}/{item8}/{item9}/{item10}", "/**/@import"}, produces={"application/json"})
    public Results getApiInfo(HttpServletResponse response, HttpServletRequest request, PathData pdata) {
        QApi.HApi api;
        Results results = new Results();
        String method = request.getParameter("method");
        String uri = pdata.getUri();
        if (uri == null) {
            RequestParam rp = Bee.getRequestParam();
            uri = rp.getUri().substring("uris/".length());
        }
        if ((api = QApi.getApi((String)(uri = Format.noEmpty((Object)method) ? String.valueOf(method.trim().toLowerCase()) + ":" + uri : uri))) == null) {
            results.error((Object)("\u63a5\u53e3\u3010" + uri + "\u3011\u4e0d\u5b58\u5728\uff01"));
            return results;
        }
        Map mapInfo = api.toMapInfo();
        if (Format.noEmpty((Object)method)) {
            mapInfo.put("method", method);
        }
        if (uri.endsWith("/@import")) {
            HashMap map = new HashMap(mapInfo);
            ArrayList list = new ArrayList();
            HashMap<String, Object> param = new HashMap<String, Object>();
            if ("post".equalsIgnoreCase(method)) {
                param.put("name", "file");
                param.put("title", "\u9009\u62e9\u6570\u636e\u6587\u4ef6");
                param.put("type", QEnum.QType.FILE);
                param.put("describe", "\u4e0eid\u53c2\u6570\u4e92\u65a5\uff0c\u6839\u636e\u6570\u636e\u6a21\u677f\u6587\u4ef6\u6784\u9020\u6570\u636e\u6587\u4ef6");
                param.put("accept", ".xls,.xlsx,.csv");
                param.put("required", true);
                list.add(param);
            } else if ("get".equalsIgnoreCase(method)) {
                param = new HashMap();
                param.put("name", "id");
                param.put("title", "\u5bfc\u5165\u6587\u4ef6ID");
                param.put("describe", "\u4e0efile\u53c2\u6570\u4e92\u65a5\uff0c\u9009\u62e9\u6587\u4ef6\u5bfc\u5165\u6210\u529f\u540e\u4f1a\u8fd4\u56deid\uff0cid\u4f9b\u67e5\u8be2\u8fdb\u5ea6\u4f7f\u7528\u3002");
                param.put("required", true);
                list.add(param);
            } else {
                results.error((Object)("\u63a5\u53e3\u3010" + uri + "\u3011\u4e0d\u5b58\u5728\uff01"));
                return results;
            }
            map.put("params", list);
            results.succeed(map);
        } else {
            results.succeed((Object)mapInfo);
        }
        return results;
    }

    @PutMapping(value={"/{item1}", "/{item1}/{item2}", "/{item1}/{item2}/{item3}", "/{item1}/{item2}/{item3}/{item4}", "/{item1}/{item2}/{item3}/{item4}/{item5}", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}/{item8}", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}/{item8}/{item9}", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}/{item8}/{item9}/{item10}"}, produces={"application/json"})
    public Results updateUriInfo(HttpServletResponse response, HttpServletRequest request, PathData pdata) {
        HttpParam httpParam = new HttpParam(request);
        Results results = new Results();
        QApi.HApi api = QApi.getApi((String)pdata.getUri());
        if (api.getObject() instanceof QTable) {
            RequestParam rparam = httpParam.getRParam();
            rparam.put("uri", pdata.getUri());
            rparam.put("type", "uri");
            api.update(rparam);
            results.succeed((Object)"ok");
        } else {
            results.error((Object)"\u6b64\u63a5\u53e3\u4e0d\u652f\u6301\u4fee\u6539\u64cd\u4f5c");
        }
        return results;
    }

    @PutMapping(value={"/{item1}/param", "/{item1}/{item2}/param", "/{item1}/{item2}/{item3}/param", "/{item1}/{item2}/{item3}/{item4}/param", "/{item1}/{item2}/{item3}/{item4}/{item5}/param", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/param", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}/param", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}/{item8}/param", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}/{item8}/{item9}/param", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}/{item8}/{item9}/{item10}/param"}, produces={"application/json"})
    public Results updateUriParam(HttpServletResponse response, HttpServletRequest request, PathData pdata) {
        HttpParam httpParam = new HttpParam(request);
        Results results = new Results();
        QApi.HApi api = QApi.getApi((String)pdata.getUri());
        if (api.getObject() instanceof QTable) {
            RequestParam rparam = httpParam.getRParam();
            rparam.put("uri", pdata.getUri());
            rparam.put("type", "param");
            api.update(rparam);
            results.succeed((Object)"ok");
        } else {
            results.error((Object)"\u6b64\u63a5\u53e3\u4e0d\u652f\u6301\u4fee\u6539\u64cd\u4f5c");
        }
        return results;
    }

    @PutMapping(value={"/{item1}/relation", "/{item1}/{item2}/relation", "/{item1}/{item2}/{item3}/relation", "/{item1}/{item2}/{item3}/{item4}/relation", "/{item1}/{item2}/{item3}/{item4}/{item5}/relation", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/relation", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}/relation", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}/{item8}/relation", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}/{item8}/{item9}/relation", "/{item1}/{item2}/{item3}/{item4}/{item5}/{item6}/{item7}/{item8}/{item9}/{item10}/relation"}, produces={"application/json"})
    public Results updateUriRelation(HttpServletResponse response, HttpServletRequest request, PathData pdata) {
        HttpParam httpParam = new HttpParam(request);
        Results results = new Results();
        QApi.HApi api = QApi.getApi((String)pdata.getUri());
        if (api.getObject() instanceof QTable) {
            QTable qt = (QTable)api.getObject();
            RequestParam rparam = httpParam.getRParam();
            rparam.put("uri", pdata.getUri());
            rparam.put("type", "relation");
            String fk = httpParam.getParam("fk");
            String ruri = httpParam.getParam("ruri");
            String alias = httpParam.getParam("alias");
            int state = rparam.asInt("state");
            if (state == 1) {
                qt.getRelations().remove(alias);
            } else {
                QApi.HApi rapi = QApi.getApi((String)ruri);
                if (rapi == null) {
                    results.error((Object)("\u3010" + ruri + "\u3011\u4e0d\u5b58\u5728!"));
                } else {
                    Relation.Link link = Relation.Link.builder().parentTable((QTable)rapi.getObject()).parentField(fk).childrenTable(qt).alias(alias).build();
                    RParent parent = new RParent(link);
                    qt.addRelation((Relation)parent);
                    results.succeed((Object)"ok");
                }
            }
            api.update(httpParam.getRParam());
        } else {
            results.error((Object)"\u6b64\u63a5\u53e3\u4e0d\u652f\u6301\u4fee\u6539\u64cd\u4f5c");
        }
        return results;
    }

    @GetMapping(value={"/code"})
    public void verifyCode(HttpServletResponse response, HttpServletRequest request) throws IOException {
        Results results = new Results();
        results.setResponse(response);
        VerifyCode.Img img = Tool.VerifyCode.getImgCode();
        results.setContentType("image/gif;charset=UTF-8");
        Cookie cookie = new Cookie("code", img.verifyCode);
        cookie.setDomain("web.bee.com");
        cookie.setPath("/");
        cookie.setMaxAge(3600);
        response.addCookie(cookie);
        results.build(img.getBytes());
    }
}

