/*
 * Decompiled with CFR 0.152.
 */
package bee.cloud.service.controller;

import bee.cloud.core.Bee;
import bee.cloud.core.db.BusinessManage;
import bee.cloud.core.db.DBE;
import bee.cloud.core.db.RequestParam;
import bee.cloud.service.controller.Controller;
import bee.cloud.service.core.result.Results;
import bee.tool.Tool;
import bee.tool.err.BeeException;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class CommController
extends Controller {
    @Override
    protected Results execute(HttpServletResponse response, HttpServletRequest request) {
        long time = System.currentTimeMillis();
        Results results = new Results();
        String contextPath = request.getContextPath();
        String uri = Tool.urlDecode((String)request.getRequestURI(), (String)request.getCharacterEncoding());
        uri = uri.substring(contextPath.length() + 1);
        uri = uri.replace("\u2019", "'");
        RequestParam rparam = BusinessManage.inst().getRequestParam();
        try {
            results.setCallback(rparam.asText("callback"));
            DBE.Param dparam = new DBE.Param(uri, rparam);
            dparam.check();
            Bee.getSql().setAutoCommit(false);
            results.succeed((Object)DBE.execute((DBE.Param)dparam));
        }
        catch (BeeException e) {
            e.setOther((Object)rparam);
            throw e;
        }
        Tool.Log.info((String)"\u603b\u7528\u65f6\uff1a{}", (Object[])new Object[]{System.currentTimeMillis() - time});
        if (response.isCommitted() && response.getStatus() == 200) {
            try {
                response.flushBuffer();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Thread.currentThread().interrupt();
            return null;
        }
        if (response.getStatus() == 302) {
            return null;
        }
        BusinessManage.inst().getWork().setOut(true);
        return results;
    }
}

